/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddLoop;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestInvocation;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.BehaviorActionGroup;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.InsertLoop;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.InsertTestInvocation;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.adapter.TestAdapterFactory;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.LocalTransfer;
import org.eclipse.hyades.test.ui.internal.model.ui.ViewerDragAdapter;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class BehaviorSection
extends EObjectTreeSection
implements IITestSuiteProvider {
    protected static final int HELP_SECTION_CONTROL = 1;
    protected static final int HELP_SECTION_UP_ACTION = 2;
    protected static final int HELP_SECTION_DOWN_ACTION = 3;
    protected static final int HELP_SECTION_ADD_LOOP_ACTION = 4;
    protected static final int HELP_SECTION_ADD_INV_ACTION = 5;
    private BehaviorActionGroup addBehaviorActionGroup;
    private BehaviorActionGroup insertBehaviorActionGroup;

    public BehaviorSection(BehaviorForm behaviorForm) {
        super((EditorForm)behaviorForm, (EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction_InteractionFragments(), null);
    }

    public void dispose() {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.dispose();
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.dispose();
        }
        super.dispose();
    }

    public ITestSuite getTestSuite() {
        return ((BehaviorForm)this.getEditorForm()).getTestSuite();
    }

    protected void adjustButtonLabels(String addLabel) {
        super.adjustButtonLabels(UiPlugin.getString((String)"BTN_ADD"), UiPlugin.getString((String)"BTN_INSERT"));
    }

    protected void adjustClient(Composite parent) {
        super.adjustClient(parent);
        this.initDragAndDrop();
        this.registerHelp(1, this.getTreeViewer().getControl());
        this.registerHelp(2, this.moveUpAction);
        this.registerHelp(3, this.moveDownAction);
    }

    private void initDragAndDrop() {
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        ViewerDragAdapter dragListener = new ViewerDragAdapter((Viewer)this.getTreeViewer());
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)dragListener);
        ElementSectionDropAdapter dropListener = new ElementSectionDropAdapter(this.getTreeViewer());
        dropListener.setSelectionFeedbackEnabled(false);
        dropListener.setFeedbackEnabled(false);
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    protected void buttonSelected(int index) {
        if (!this.isReadOnly()) {
            switch (index) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doInsert();
                    break;
                }
                case 2: {
                    this.doRemove();
                    break;
                }
                case 3: {
                    this.doMoveUp();
                    break;
                }
                case 4: {
                    this.doMoveDown();
                }
            }
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void createActions() {
        this.addBehaviorActionGroup = this.createAddBehaviorActionGroup();
        this.insertBehaviorActionGroup = this.createInsertBehaviorActionGroup();
        super.createActions();
    }

    protected IContentProvider createContentProvider() {
        return new BehaviorContentProvider(this.getEditorForm(), this.getEStructuralFeature());
    }

    protected ILabelProvider createLabelProvider() {
        return new BehaviorLabelProvider();
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.fillContextMenu(menuManager);
            if (this.isReadOnly()) {
                this.addBehaviorActionGroup.disableActions();
            }
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.fillContextMenu(menuManager);
            if (this.isReadOnly()) {
                this.insertBehaviorActionGroup.disableActions();
            }
        }
        super.fillContextMenu(menuManager);
    }

    protected void doAdd() {
        if (this.addBehaviorActionGroup != null) {
            Menu menu = this.getTreePart().getButtonMenu(0);
            this.addBehaviorActionGroup.fillContextMenu(menu, true);
            menu.setVisible(true);
        }
    }

    protected void doInsert() {
        if (this.insertBehaviorActionGroup != null) {
            Menu menu = this.getTreePart().getButtonMenu(1);
            this.insertBehaviorActionGroup.fillContextMenu(menu, true);
            menu.setVisible(true);
        }
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.setContext(new ActionContext((ISelection)structuredSelection));
            this.getTreePart().setButtonEnabled(0, this.addBehaviorActionGroup.isEnabled());
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.setContext(new ActionContext((ISelection)structuredSelection));
            this.getTreePart().setButtonEnabled(1, this.insertBehaviorActionGroup.isEnabled());
        }
        if (!structuredSelection.isEmpty() && ((EObject)structuredSelection.getFirstElement()).eContainer() != this.getInput()) {
            this.moveUpAction.setEStructuralFeature((EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
            this.moveDownAction.setEStructuralFeature((EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
        } else {
            this.moveUpAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveDownAction.setEStructuralFeature(this.getEStructuralFeature());
        }
        if (this.addAction != null) {
            if (this.addAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.addAction).selectionChanged(structuredSelection);
            }
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.insertAction != null) {
            if (this.insertAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.insertAction).selectionChanged(structuredSelection);
            }
            this.getTreePart().setButtonEnabled(1, this.insertAction.isEnabled());
        }
        if (this.removeAction != null) {
            this.removeAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(2, this.removeAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(4, this.moveDownAction.isEnabled());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(3, this.moveUpAction.isEnabled());
        }
    }

    protected BehaviorActionGroup createAddBehaviorActionGroup() {
        BehaviorActionGroup group = new BehaviorActionGroup(this, UiPlugin.getString((String)"LBL_ADD"));
        AddLoop addLoop = new AddLoop(this, ToolsUiPlugin.getString("LBL_LOOP"), ToolsUiPlugin.getString("W_LOOP"));
        this.registerHelp(4, (Object)addLoop);
        group.addAction(addLoop);
        AddTestInvocation addTestInvocation = new AddTestInvocation(this, ToolsUiPlugin.getString("W_LWR_INV")){

            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite) {
                return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, false);
            }
        };
        this.registerHelp(5, (Object)addTestInvocation);
        group.addAction(addTestInvocation);
        return group;
    }

    protected BehaviorActionGroup createInsertBehaviorActionGroup() {
        BehaviorActionGroup group = new BehaviorActionGroup(this, UiPlugin.getString((String)"LBL_INSERT"));
        this.createContentProvider();
        InsertLoop insertLoop = new InsertLoop(this, ToolsUiPlugin.getString("LBL_LOOP"), ToolsUiPlugin.getString("W_LOOP"));
        this.registerHelp(4, (Object)insertLoop);
        group.addAction(insertLoop);
        InsertTestInvocation insertTestInvocation = new InsertTestInvocation(this, ToolsUiPlugin.getString("W_LWR_INV")){

            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite) {
                return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, false);
            }
        };
        this.registerHelp(5, (Object)insertTestInvocation);
        group.addAction(insertTestInvocation);
        return group;
    }

    protected void registerHelp(int flag, Object object) {
        switch (flag) {
            case 1: {
                WorkbenchHelp.setHelp((Control)((Control)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".behf0004"));
                break;
            }
            case 3: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".behf0006"));
                break;
            }
            case 2: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".behf0005"));
                break;
            }
            case 4: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addl0001"));
                break;
            }
            case 5: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".adti0001"));
            }
        }
    }

    public static class BehaviorContentProvider
    extends EObjectTreeSection.EObjectContainerContentProvider {
        public BehaviorContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            super(editorForm, eStructuralFeature);
        }

        public void dispose() {
            if (this.getContainer() != null) {
                EMFUtil.removeAdapter((Iterator)this.getContainer().eResource().getAllContents(), (Adapter)this);
            }
            super.dispose();
        }

        protected void deregisterInputAdapters(EObject oldInput, Object value) {
            if (oldInput.eResource() != null) {
                EMFUtil.removeAdapter((Iterator)oldInput.eResource().getAllContents(), (Adapter)this);
            }
        }

        protected void registerInputAdapters(EObject newInput, Object value) {
            EMFUtil.addAdapter((Iterator)newInput.eResource().getAllContents(), (Adapter)this);
        }

        public Object getParent(Object element) {
            if (element instanceof org.eclipse.hyades.models.common.facades.behavioral.IAction) {
                EObject eObject = ((EObject)element).eContainer();
                while (!(eObject instanceof ILoop) && eObject != null) {
                    eObject = eObject.eContainer();
                }
                return eObject;
            }
            return super.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (super.hasChildren(element)) {
                return true;
            }
            if (element instanceof ILoop) {
                return !((ILoop)element).getBlock().getActions().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ILoop) {
                return ((ILoop)parentElement).getBlock().getActions().toArray();
            }
            return super.getChildren(parentElement);
        }

        protected void adjustAdapter(Notification msg) {
            EObject eObject = null;
            switch (msg.getEventType()) {
                case 3: {
                    eObject = (EObject)msg.getNewValue();
                    eObject.eAdapters().add((Object)this);
                    EMFUtil.addAdapter((Iterator)eObject.eAllContents(), (Adapter)this);
                    break;
                }
                case 5: {
                    Iterator i = ((Collection)msg.getNewValue()).iterator();
                    while (i.hasNext()) {
                        EMFUtil.addAdapter((Iterator)((EObject)i.next()).eAllContents(), (Adapter)this);
                    }
                    break;
                }
                case 4: {
                    eObject = (EObject)msg.getOldValue();
                    eObject.eAdapters().remove((Object)this);
                    EMFUtil.removeAdapter((Iterator)eObject.eAllContents(), (Adapter)this);
                    break;
                }
                case 6: {
                    Iterator i = ((Collection)msg.getOldValue()).iterator();
                    while (i.hasNext()) {
                        EMFUtil.removeAdapter((Iterator)((EObject)i.next()).eAllContents(), (Adapter)this);
                    }
                    break;
                }
            }
        }

        protected boolean shouldUpdateViewer(Notification msg) {
            if (super.shouldUpdateViewer(msg)) {
                return true;
            }
            return msg.getNotifier() instanceof IBlock && msg.getFeature() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments();
        }

        protected void attributeChanged(Notification msg) {
            super.attributeChanged(msg);
            if (this.getViewer() != null && msg.getFeature() == Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence_OtherBehavior() && msg.getNotifier() instanceof ITestInvocation) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.getViewer().getSelection();
                if (structuredSelection.isEmpty()) {
                    return;
                }
                if (structuredSelection.getFirstElement() == msg.getNotifier()) {
                    UIUtil.fireCurrentSelection((StructuredViewer)((StructuredViewer)this.getViewer()));
                }
            }
        }
    }

    public static class BehaviorLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getLabel(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ILoop) {
                return TestCommonImages.INSTANCE.getImage("loop.gif");
            }
            if (element instanceof ITestInvocation) {
                return TestCommonImages.INSTANCE.getImage("invocation.gif");
            }
            ImageDescriptor imageDescriptor = TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getImageDescriptor(element);
            if (imageDescriptor != null) {
                return imageDescriptor.createImage();
            }
            return null;
        }
    }

    public static class ElementSectionDropAdapter
    extends ViewerDropAdapter {
        public ElementSectionDropAdapter(TreeViewer treeViewer) {
            super((Viewer)treeViewer);
        }

        public boolean performDrop(Object data) {
            boolean ret = false;
            Object target = this.getCurrentTarget();
            if (target instanceof ILoop && data instanceof StructuredSelection) {
                ILoop loop = (ILoop)target;
                Iterator it = ((StructuredSelection)data).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof ITestInvocation)) continue;
                    loop.getBlock().getActions().add((ITestInvocation)obj);
                    ret = true;
                }
            }
            return ret;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (!LocalTransfer.getInstance().isSupportedType(transferType)) {
                return false;
            }
            return target instanceof ILoop;
        }
    }
}

