/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailPropertiesSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailsPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTree;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorEclipseForm;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class TestCasesEclipseForm
extends EditorEclipseForm
implements IITestSuiteProvider,
ISelectionChangedListener {
    protected static final int HELP_NAMED_ELEMENT_CONTROL = 1;
    protected static final int HELP_TEST_CASES_SECTION_CONTROL = 2;
    protected static final int HELP_TEST_CASES_SECTION_TREE_CONTROL = 3;
    protected static final int HELP_DETAIL_SECTION_CONTROL = 4;
    private IEditorExtension editor;
    private ScrolledForm form;
    private EObjectTree eobjectTree;
    private Section sectionc;
    private FormUtil.CommonSection commonSection;
    private Section sectiond;
    private DetailPropertiesSection propertySection;
    private ITestCase currentSelection;

    public TestCasesEclipseForm(IEditorExtension editor, String editorTitle, String id, String title) {
        super(editor, editorTitle, id, title);
        this.editor = editor;
    }

    public void dispose() {
        if (this.eobjectTree != null) {
            this.eobjectTree.dispose();
            this.eobjectTree = null;
        }
        if (this.form != null) {
            this.form.dispose();
            this.form = null;
        }
        if (this.sectionc != null) {
            this.sectionc.dispose();
            this.sectionc = null;
        }
        if (this.commonSection != null) {
            this.commonSection.dispose();
            this.commonSection = null;
        }
        if (this.sectiond != null) {
            this.sectiond.dispose();
            this.sectiond = null;
        }
        if (this.propertySection != null) {
            this.propertySection.dispose();
            this.propertySection = null;
        }
        super.dispose();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        super.createFormContent(managedForm);
    }

    protected void createLeftColumnControls(Composite parent) {
        Control control = this.createTestCaseSection(parent, UiPlugin.getString((String)"W_TST_CASES"), ToolsUiPlugin.getString("EDT_TST_CASE_DSC"));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Control createTestCaseSection(Composite parent, String header, String desc) {
        FormToolkit toolkit = ((FormEditor)this.editor.getHyadesEditorPart()).getToolkit();
        Section section = FormUtil.createSection(toolkit, parent, this.form);
        this.eobjectTree = new EObjectTree(this.editor, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), this.getAddTestCaseAction());
        this.addCustomButtons();
        Composite sectionClient = this.eobjectTree.createControls((Composite)section, toolkit);
        this.buttonsCreated();
        this.setStandardControlIndices();
        this.eobjectTree.getViewerPart().getViewer().setInput((Object)this.getTestSuite());
        this.eobjectTree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.toggleStdButtonEnableStatus(0, 0, true);
        this.toggleStdButtonEnableStatus(1, 3, false);
        FormUtil.setSectionProperty(toolkit, section, (Control)sectionClient, header, desc);
        this.registerHelp(2, (Control)section);
        this.registerHelp(3, this.eobjectTree.getTreeViewer().getControl());
        return section;
    }

    protected int[] getStanderdControlIndices() {
        return this.eobjectTree.getButtonIndices();
    }

    protected void setStandardControlIndices() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.eobjectTree.setButtonIndices(nArray);
    }

    protected void addCustomButtons() {
    }

    protected void buttonsCreated() {
    }

    protected void createRightColumnControls(Composite parent) {
        FormToolkit toolkit = ((FormEditor)this.editor.getHyadesEditorPart()).getToolkit();
        Control commonPropertySection = this.createCommonPropertySection(toolkit, parent);
        this.propertySection = new DetailPropertiesSection(this.editor, (EditorEclipseForm)this, toolkit);
        Control detailSection = this.createDetailPropertySection(toolkit, parent);
        if (detailSection != null) {
            detailSection.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        commonPropertySection.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected Control createCommonPropertySection(FormToolkit toolkit, Composite parent) {
        this.sectionc = FormUtil.createSection(toolkit, parent, this.form);
        FormUtil formUtil = FormUtil.getInstance();
        formUtil.getClass();
        this.commonSection = new FormUtil.CommonSection(formUtil, 1);
        Composite sectionClient = this.commonSection.createControl(this.editor, this.sectionc, toolkit, "", "");
        FormUtil.setSectionProperty(toolkit, this.sectionc, (Control)sectionClient, UiPlugin.getString((String)"EDT_GENERAL_INFO"), UiPlugin.getString((String)"EDT_GENERAL_DSC"));
        return this.sectionc;
    }

    protected Control createDetailPropertySection(FormToolkit toolkit, Composite parent) {
        DetailsPageProvider detailPageProvider = new DetailsPageProvider();
        this.addDetails(detailPageProvider);
        this.sectiond = FormUtil.createSection(toolkit, parent, this.form);
        Composite sectionClient = this.propertySection.createDefaultControl((Composite)this.sectiond);
        this.propertySection.setDetailPageProvider((DetailPropertiesSection.IDetailFormProvider)detailPageProvider);
        FormUtil.setSectionProperty(toolkit, this.sectiond, (Control)sectionClient, ToolsUiPlugin.getString("W_DETAIL"), ToolsUiPlugin.getString("TST_SUITE_GENERAL_DETAILS_DESC"));
        return this.sectiond;
    }

    protected void registerHelp(int flag, Control control) {
    }

    protected IAction getAddTestCaseAction() {
        return null;
    }

    public ITestSuite getTestSuite() {
        return super.getCommonTestSuite();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.eobjectTree.getTreeViewer()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.eobjectTree.getTreeViewer().getSelection();
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof ITestCase) {
                this.currentSelection = (ITestCase)selection;
                this.commonSection.setInput(this.currentSelection);
            } else {
                this.currentSelection = null;
            }
            if (this.propertySection != null) {
                this.propertySection.setInput((Object)structuredSelection);
            }
        } else {
            this.currentSelection = null;
        }
        if (this.currentSelection == null) {
            this.toggleStdButtonEnableStatus(0, 0, true);
            this.toggleStdButtonEnableStatus(1, 3, false);
        }
    }

    protected void toggleEnableStatus(int start, int end, boolean isEnabled) {
        StructuredViewerPart viewerPart = this.eobjectTree.getViewerPart();
        int i = start;
        while (i <= end) {
            viewerPart.setButtonEnabled(i, isEnabled);
            ++i;
        }
    }

    protected void toggleEnableStatus(boolean[] enableStatus) {
        StructuredViewerPart viewerPart = this.eobjectTree.getViewerPart();
        int i = 0;
        while (i < enableStatus.length) {
            viewerPart.setButtonEnabled(i, enableStatus[i]);
            ++i;
        }
    }

    protected void toggleStdButtonEnableStatus(int start, int end, boolean isEnabled) {
        int[] indices = this.getStanderdControlIndices();
        StructuredViewerPart viewerPart = this.eobjectTree.getViewerPart();
        int i = start;
        while (i <= end) {
            viewerPart.setButtonEnabled(indices[i], isEnabled);
            ++i;
        }
    }

    protected boolean[] getEnableStatus(int start, int end) {
        boolean[] enableStatus = new boolean[end - start + 1];
        StructuredViewerPart viewerPart = this.eobjectTree.getViewerPart();
        int i = start;
        while (i <= end) {
            Button b = viewerPart.getButton(i);
            enableStatus[i] = b != null ? b.getEnabled() : false;
            ++i;
        }
        return enableStatus;
    }

    public EObjectTree getEobjectTree() {
        return this.eobjectTree;
    }

    public ITestCase getCurrentSelection() {
        return this.currentSelection;
    }
}

