/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestInvocationCleaner;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TestCasesForm
extends EditorForm
implements ISelectionChangedListener,
IITestSuiteProvider {
    protected static final int HELP_NAMED_ELEMENT_CONTROL = 1;
    protected static final int HELP_TEST_CASES_SECTION_CONTROL = 2;
    protected static final int HELP_TEST_CASES_SECTION_TREE_CONTROL = 3;
    protected static final int HELP_DETAIL_SECTION_CONTROL = 4;
    private EObjectTreeSection testCasesSection;
    private NamedElementSection namedElementSection;
    private DetailSection detailSection;
    private boolean firstActivation = true;
    private TestInvocationCleaner testInvocationCleaner;

    public TestCasesForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory) {
        super(testSuiteEditorExtension, widgetFactory);
        IBlock block;
        ITestSuite ts = this.getTestSuite();
        if (ts != null && (block = ts.getImplementor().getBlock()) instanceof BVRInteraction) {
            BVRInteraction interaction = (BVRInteraction)block;
            if (this.testInvocationCleaner == null || !interaction.eAdapters().contains((Object)this.testInvocationCleaner)) {
                this.testInvocationCleaner = new TestInvocationCleaner();
                interaction.eAdapters().add((Object)this.testInvocationCleaner);
            }
            List actions = block.getActions();
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                org.eclipse.hyades.models.common.facades.behavioral.IAction action = (org.eclipse.hyades.models.common.facades.behavioral.IAction)it.next();
                if (action instanceof BVRExecutionOccurrence) {
                    this.addInvocationCleanerAdapter((BVRExecutionOccurrence)action);
                    continue;
                }
                if (!(action instanceof BVRCombinedFragment)) continue;
                BVRCombinedFragment combi = (BVRCombinedFragment)action;
                EList operands = combi.getInteractionOperands();
                Iterator iter = operands.iterator();
                while (iter.hasNext()) {
                    BVRInteractionOperand operand = (BVRInteractionOperand)iter.next();
                    EList fragments = operand.getInteractionFragments();
                    Iterator iterator = fragments.iterator();
                    while (iterator.hasNext()) {
                        BVRInteractionFragment interact = (BVRInteractionFragment)iterator.next();
                        if (!(interact instanceof BVRExecutionOccurrence)) continue;
                        this.addInvocationCleanerAdapter((BVRExecutionOccurrence)interact);
                    }
                }
            }
        }
    }

    private void addInvocationCleanerAdapter(BVRExecutionOccurrence occurrence) {
        if (occurrence != null && !occurrence.eAdapters().contains((Object)this.testInvocationCleaner)) {
            occurrence.eAdapters().add((Object)this.testInvocationCleaner);
        }
    }

    public void dispose() {
        this.testCasesSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.testCasesSection.dispose();
        this.namedElementSection.dispose();
        if (this.detailSection != null) {
            this.detailSection.dispose();
        }
        super.dispose();
    }

    public ITestSuite getTestSuite() {
        return ((IITestSuiteProvider)this.getBaseEditorExtension()).getTestSuite();
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        this.createLeftColumn(leftColumn);
        this.createRightColumn(rightColumn);
    }

    protected void createLeftColumn(Composite parent) {
        this.createTestCaseSection(parent);
    }

    protected void createRightColumn(Composite parent) {
        this.createNamedElementSection(parent);
        this.createDetailSection(parent);
    }

    protected void createTestCaseSection(Composite parent) {
        this.testCasesSection = this.createTestCasesSection();
        this.registerSection((FormSection)this.testCasesSection);
        this.testCasesSection.setHeaderText(this.getTestCasesSectionHeaderText());
        this.testCasesSection.setCollapsable(true);
        Control control = this.testCasesSection.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.registerHelp(2, control);
        this.registerHelp(3, this.testCasesSection.getTreeViewer().getControl());
    }

    protected EObjectTreeSection createTestCasesSection() {
        return new EObjectTreeSection((EditorForm)this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), this.getAddTestCaseAction());
    }

    protected void createNamedElementSection(Composite parent) {
        class MyNamedElementSection
        extends NamedElementSection {
            final /* synthetic */ TestCasesForm this$0;

            public MyNamedElementSection(TestCasesForm testCasesForm, TestCasesForm form) {
                super((EditorForm)form);
                this.this$0 = testCasesForm;
            }

            public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite comp = super.createClient(parent, formWidgetFactory);
                StyledText text = this.getDescriptionTextField();
                text.setLayoutData((Object)new GridData(1810));
                return comp;
            }
        }
        this.namedElementSection = new MyNamedElementSection(this, this);
        this.namedElementSection.setHeaderText(ToolsUiPlugin.getString("EDT_GENERAL_INFO"));
        this.registerSection((FormSection)this.namedElementSection);
        Control control = this.namedElementSection.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        GridData gridData = new GridData(1810);
        control.setLayoutData((Object)gridData);
        this.registerHelp(1, control);
    }

    protected void createDetailSection(Composite parent) {
        StaticDetailPageProvider detailPageProvider = new StaticDetailPageProvider();
        this.addDetails(detailPageProvider);
        if (!detailPageProvider.isEmpty()) {
            this.detailSection = new DetailSection((EditorForm)this);
            this.detailSection.setDetailPageProvider((DetailSection.IDetailPageProvider)detailPageProvider);
            this.detailSection.setHeaderText(ToolsUiPlugin.getString("TTL_DTL_PROPS"));
            this.registerSection((FormSection)this.detailSection);
            Control control = this.detailSection.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
            control.setLayoutData((Object)new GridData(1810));
            this.registerHelp(4, control);
        }
    }

    protected IAction getAddTestCaseAction() {
        return null;
    }

    protected String getTestCasesSectionHeaderText() {
        return ToolsUiPlugin.getString("W_TST_CASES");
    }

    protected void registerHelp(int flag, Object object) {
    }

    protected void addDetails(StaticDetailPageProvider detailPageProvider) {
    }

    public void load() {
        this.testCasesSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.testCasesSection.setInput((Object)this.getTestSuite());
        this.testCasesSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectReveal(ISelection selection) {
        this.testCasesSection.selectReveal(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.testCasesSection.getTreeViewer()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.getSelection();
            this.namedElementSection.setInput((Object)structuredSelection);
            if (this.detailSection != null) {
                this.detailSection.setInput((Object)structuredSelection);
            }
        }
    }

    public ISelection getSelection() {
        return this.testCasesSection.getTreeViewer().getSelection();
    }

    public boolean activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.testCasesSection.setFocus();
        }
        return super.activated();
    }

    protected DetailSection getDetailSection() {
        return this.detailSection;
    }
}

