/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.AbstractDetailForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class TestInvocationDetailForm
extends AbstractDetailForm
implements SelectionListener {
    protected static final int HELP_PAGE_CONTROL = 1;
    protected static final int HELP_SYNCHRONOUS_CONTROL = 2;
    protected static final int HELP_FILE_CONTROL = 3;
    protected static final int HELP_EDIT_CONTROL = 4;
    protected static final int HELP_TYPE_CONTROL = 5;
    private Button synchronousButton;
    private Label imageLabel;
    private Text typeText;
    private Text fileText;
    private Button editButton;
    private Hyperlink testLink;
    private ITestInvocation testInvocation;
    static /* synthetic */ Class class$0;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.testInvocation = null;
    }

    public Control createControl(Composite parent, FormToolkit widgetFactory, IDetailPageContext context) {
        this.context = context;
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        GridData compositeGD = new GridData();
        composite.setLayoutData((Object)compositeGD);
        this.synchronousButton = widgetFactory.createButton(composite, this.getSynchronousLabel(), 32);
        this.synchronousButton.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.createTestLink(composite);
        this.registerHelp(1, composite);
        this.registerHelp(1, this.synchronousButton);
        this.registerHelp(1, this.fileText);
        this.registerHelp(1, this.editButton);
        this.registerHelp(1, this.typeText);
        return composite;
    }

    protected abstract String getSynchronousLabel();

    protected void registerHelp(int flag, Object object) {
    }

    protected void createTestLink(Composite parent) {
        FormToolkit widgetFactory = this.getEditorForm().getEditor().getToolkit();
        Composite composite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Composite linkComposite = widgetFactory.createComposite(composite);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        linkComposite.setLayout((Layout)gridLayout);
        linkComposite.setLayoutData((Object)new GridData(768));
        this.imageLabel = widgetFactory.createLabel(linkComposite, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        Composite c1 = widgetFactory.createComposite(linkComposite);
        c1.setLayout((Layout)new GridLayout());
        c1.setLayoutData((Object)new GridData(768));
        this.testLink = widgetFactory.createHyperlink(c1, "", 64);
        this.testLink.setText(this.getDeftaultLinkText());
        this.testLink.setToolTipText(this.getDeftaultLinkToolTip());
        GridData testLinkGD = new GridData();
        testLinkGD.grabExcessHorizontalSpace = true;
        testLinkGD.horizontalAlignment = 4;
        this.testLink.setLayoutData((Object)testLinkGD);
        this.testLink.addHyperlinkListener((IHyperlinkListener)new TestCaseLinkListener());
        this.editButton = widgetFactory.createButton(linkComposite, ToolsUiPlugin.getString("label.Update"), 8);
        this.editButton.setLayoutData((Object)new GridData(128));
        Text[] typeAndFile = FormUtil.createTypeFileControls(null, null, composite, widgetFactory);
        if (typeAndFile != null && typeAndFile.length >= 2) {
            this.typeText = typeAndFile[0];
            this.fileText = typeAndFile[1];
        }
    }

    protected String getDeftaultLinkText() {
        return "unspecified";
    }

    protected String getDeftaultLinkToolTip() {
        return "";
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.testInvocation = null;
        if (this.synchronousButton != null) {
            this.synchronousButton.removeSelectionListener((SelectionListener)this);
        }
        this.editButton.removeSelectionListener((SelectionListener)this);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean doPack = false;
        boolean testIsSet = false;
        if (object instanceof ITestInvocation) {
            this.testInvocation = (ITestInvocation)object;
            ITest test = this.testInvocation.getInvokedTest();
            doPack = true;
            this.editButton.setEnabled(true);
            if (this.synchronousButton != null) {
                this.synchronousButton.setSelection(this.testInvocation.isSynchronous());
                this.synchronousButton.setEnabled(true);
            }
            if (test != null) {
                testIsSet = true;
                ImageDescriptor imageDescriptor = null;
                if (test instanceof IAdaptable) {
                    IWorkbenchAdapter workbenchAdapter;
                    IAdaptable iAdaptable = (IAdaptable)test;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((workbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                        imageDescriptor = workbenchAdapter.getImageDescriptor((Object)test);
                    }
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (test.getName() != null) {
                    this.testLink.setText(test.getName());
                } else {
                    this.testLink.setText(ToolsUiPlugin.getString("W_TEST"));
                }
                this.testLink.setData((Object)test);
                String value = test.getType();
                if (value != null) {
                    IAssociationDescriptor descriptor = null;
                    if (test instanceof ITestSuite) {
                        descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    } else if (test instanceof ITestCase) {
                        descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    }
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)((EObject)test)));
            }
        } else {
            this.editButton.setEnabled(false);
        }
        if (!testIsSet) {
            doPack = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(this.getDeftaultLinkText());
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
            if (this.synchronousButton != null) {
                this.synchronousButton.setEnabled(false);
            }
        }
        if (doPack) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
        this.editButton.addSelectionListener((SelectionListener)this);
        if (this.synchronousButton != null) {
            this.synchronousButton.addSelectionListener((SelectionListener)this);
        }
    }

    public Object getInput() {
        return this.testInvocation;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isReadOnly()) {
            e.doit = false;
        } else if (e.widget == this.editButton) {
            ITestSuite testSuite = (ITestSuite)EcoreUtil.getRootContainer((EObject)((EObject)this.testInvocation));
            InvokedTestSelectionDialog selectionDialog = this.createInvokedTestSelectionDialog(testSuite);
            selectionDialog.setTest((ITest)this.testLink.getData());
            if (selectionDialog.open() == 0) {
                ITest test = (ITest)selectionDialog.getTests().iterator().next();
                ResourceSet resourceSet = ((EObject)testSuite).eResource().getResourceSet();
                test = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)test), (boolean)true);
                if (this.testInvocation.getInvokedTest() != test) {
                    this.testInvocation.setInvokedTest(test);
                    this.setInput(this.testInvocation);
                }
            }
        } else if (e.widget == this.synchronousButton) {
            this.testInvocation.setSynchronous(this.synchronousButton.getSelection());
            if (this.getEditorForm().getFormEditor() instanceof BaseEditorExtension) {
                ((BaseEditorExtension)this.getEditorForm().getFormEditor()).markDirty();
            }
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    public void verifyText(VerifyEvent e) {
    }

    private class TestCaseLinkListener
    implements IHyperlinkListener {
        TestCaseLinkListener() {
        }

        public void linkActivated(HyperlinkEvent event) {
            BaseEditorExtension baseEditor;
            IActionBars actionBars;
            IStatusLineManager manager;
            Object data = event.widget.getData();
            if (data != null) {
                EObject eObject = (EObject)data;
                IEditorPart editorPart = TestUIUtil.openEditor((Resource)eObject.eResource(), null, (boolean)false);
                if (editorPart instanceof ISelectionProvider) {
                    ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
                }
                return;
            }
            if (TestInvocationDetailForm.this.getEditorForm().getFormEditor() instanceof BaseEditorExtension && (manager = (actionBars = (baseEditor = (BaseEditorExtension)TestInvocationDetailForm.this.getEditorForm().getFormEditor()).getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars()).getStatusLineManager()) != null) {
                manager.setErrorMessage(ToolsUiPlugin.getString("MSG_UN_OPEN_OBJ"));
            }
        }

        public void linkEntered(HyperlinkEvent event) {
            BaseEditorExtension baseEditor;
            IActionBars actionBars;
            IStatusLineManager manager;
            if (TestInvocationDetailForm.this.getEditorForm().getFormEditor() instanceof BaseEditorExtension && (manager = (actionBars = (baseEditor = (BaseEditorExtension)TestInvocationDetailForm.this.getEditorForm().getFormEditor()).getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars()).getStatusLineManager()) != null) {
                manager.setMessage(((Hyperlink)event.widget).getText());
            }
        }

        public void linkExited(HyperlinkEvent event) {
            BaseEditorExtension baseEditor;
            IActionBars actionBars;
            IStatusLineManager manager;
            if (TestInvocationDetailForm.this.getEditorForm().getFormEditor() instanceof BaseEditorExtension && (manager = (actionBars = (baseEditor = (BaseEditorExtension)TestInvocationDetailForm.this.getEditorForm().getFormEditor()).getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars()).getStatusLineManager()) != null) {
                manager.setMessage("");
                manager.setErrorMessage("");
            }
        }
    }
}

