/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class TestSuiteForm
extends EditorForm {
    protected static final int HELP_FORM_CONTROL = 1;
    protected static final int HELP_TEST_CASE_CONTROL = 2;
    protected static final int HELP_TYPE_CONTROL = 3;
    protected static final int HELP_FILE_CASE_CONTROL = 4;
    private NamedElementSection namedElementSection;
    private NamedElementsSection testCaseElementsSection;
    private int testCasesPageIndex;
    static /* synthetic */ Class class$0;

    public TestSuiteForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory) {
        super(testSuiteEditorExtension, widgetFactory);
    }

    public void dispose() {
        this.namedElementSection.dispose();
        this.namedElementSection = null;
        this.testCaseElementsSection.dispose();
        this.testCaseElementsSection = null;
        super.dispose();
    }

    protected ITestSuite getTestSuite() {
        return ((IITestSuiteProvider)this.getBaseEditorExtension()).getTestSuite();
    }

    public void setTestCasePageIndex(int index) {
        this.testCasesPageIndex = index;
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        this.createLeftColumnControls(leftColumn);
        this.createRightColumnControls(rightColumn);
    }

    protected void createLeftColumnControls(Composite parent) {
        Control control = this.createGenericInformation(parent, ToolsUiPlugin.getString("EDT_GENERAL_INFO"), ToolsUiPlugin.getString("EDT_GENERAL_DSC"));
        control.setLayoutData((Object)new GridData(770));
        this.registerHelp(1, control);
    }

    protected void createRightColumnControls(Composite parent) {
        this.testCaseElementsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.testCasesPageIndex);
        this.registerSection((FormSection)this.testCaseElementsSection);
        Control control = this.createTestCaseElementsSectionControl(parent, this.testCaseElementsSection);
        this.registerHelp(2, control);
    }

    protected abstract Control createTestCaseElementsSectionControl(Composite var1, NamedElementsSection var2);

    protected Control createGenericInformation(Composite parent, String header, String description) {
        this.namedElementSection = new NamedElementSection(this){
            private StyledText typeText;
            private StyledText fileText;

            protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite detailComposite = TestSuiteForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                detailComposite.setLayout((Layout)gridLayout);
                detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                TestSuiteForm.this.getWidgetFactory().createLabel(detailComposite, ToolsUiPlugin.getString("L_TYPE"));
                this.typeText = TestSuiteForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
                this.typeText.setEnabled(false);
                this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                TestSuiteForm.this.getWidgetFactory().createLabel(detailComposite, ToolsUiPlugin.getString("L_FILE"));
                this.fileText = TestSuiteForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                TestSuiteForm.this.registerHelp(3, this.typeText);
                TestSuiteForm.this.registerHelp(3, this.fileText);
            }

            public void setInput(Object object) {
                super.setInput(object);
                String value = TestSuiteForm.this.getTestSuite().getType();
                if (value != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)((EObject)TestSuiteForm.this.getTestSuite())));
            }
        };
        this.registerSection((FormSection)this.namedElementSection);
        this.namedElementSection.setHeaderText(header);
        this.namedElementSection.setDescription(description);
        return this.namedElementSection.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
    }

    protected void registerHelp(int flag, Object object) {
    }

    public void load() {
        this.namedElementSection.setInput((Object)this.getTestSuite());
        this.testCaseElementsSection.initialize((EObject)this.getTestSuite(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), null);
    }

    public void updateTitle() {
        Object editorObject = this.getBaseEditorExtension().getHyadesEditorPart().getEditorObject();
        if (editorObject instanceof IAdaptable) {
            String title;
            IAdaptable iAdaptable = (IAdaptable)editorObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((title = ((IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)).getLabel(editorObject)) != null) {
                ((IHyadesEditorPartExtended)this.getBaseEditorExtension().getHyadesEditorPart()).setEditorTitle(title);
            }
        }
    }

    public boolean activated() {
        return true;
    }
}

