/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FormUtil {
    public static final float TEXT_AREA_PARENT_PROPORTION = 0.9f;
    public static final float TEXT_PARENT_PROPORTION = 0.931f;
    private static FormUtil instance;

    private FormUtil() {
    }

    public static FormUtil getInstance() {
        if (instance == null) {
            instance = new FormUtil();
        }
        return instance;
    }

    public static Composite addSouthControls(ITestSuite testSuite, Section parent, Composite sectionClient, FormToolkit toolkit) {
        FormUtil.createTypeFileControls(testSuite, parent, sectionClient, toolkit);
        return sectionClient;
    }

    public static Text[] createTypeFileControls(ITestSuite testSuite, Section parent, Composite sectionClient, FormToolkit toolkit) {
        String fileTextValue;
        String value;
        final Composite composite = toolkit.createComposite(sectionClient);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData compositeGridData = new GridData();
        compositeGridData.verticalAlignment = 1024;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)compositeGridData);
        GridData td = new GridData();
        toolkit.createLabel(composite, UiPlugin.getString((String)"L_TYPE"));
        final Text typeText = toolkit.createText(composite, "", 65540);
        typeText.setEditable(false);
        typeText.setLayoutData((Object)td);
        toolkit.createLabel(composite, UiPlugin.getString((String)"L_FILE"));
        final Text fileText = toolkit.createText(composite, "", 65540);
        fileText.setEditable(false);
        fileText.setLayoutData((Object)td);
        String string = value = testSuite == null ? null : testSuite.getType();
        if (value != null) {
            IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
            if (descriptor != null && descriptor.getName() != null) {
                value = descriptor.getName();
            }
            typeText.setText(value);
        }
        String string2 = fileTextValue = testSuite == null ? null : EMFUtil.getFilePath((EObject)((EObject)testSuite));
        if (fileTextValue != null) {
            fileText.setText(fileTextValue);
        }
        sectionClient.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int parentWidth = ((Composite)e.widget).getSize().x;
                GridData gridData = new GridData();
                gridData.widthHint = (int)((double)parentWidth * 0.8309999942779541);
                composite.setLayoutData((Object)gridData);
                composite.redraw();
            }
        });
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int parentWidth = ((Composite)e.widget).getSize().x;
                GridData gridData = new GridData();
                gridData.widthHint = (int)((double)parentWidth * 0.8309999942779541);
                typeText.setLayoutData((Object)gridData);
                typeText.redraw();
                fileText.setLayoutData((Object)gridData);
                fileText.redraw();
            }
        });
        toolkit.paintBordersFor(composite);
        return new Text[]{typeText, fileText};
    }

    public static void setSectionProperty(FormToolkit toolkit, Section section, Control sectionClient, String header, String desc) {
        section.setClient(sectionClient);
        toolkit.paintBordersFor((Composite)section);
        section.setText(header);
        toolkit.createCompositeSeparator((Composite)section);
        section.setDescription(desc);
    }

    public static Section createSection(FormToolkit toolkit, Composite parent, ScrolledForm form) {
        Section section = toolkit.createSection(parent, 194);
        GridData td = new GridData(4, 4, true, true);
        section.setLayoutData((Object)td);
        FormUtil formUtil = new FormUtil();
        formUtil.getClass();
        section.addExpansionListener((IExpansionListener)formUtil.new SectionExpanderAdapter(form));
        return section;
    }

    public static ITargetInvocation getTargetInvocation(ITestCase input) {
        IBlock block;
        ITargetInvocation targetInvocation = null;
        IImplementor implementor = input.getImplementor();
        IBlock iBlock = block = implementor == null ? null : implementor.getBlock();
        if (block != null) {
            Iterator i = block.getActions().iterator();
            while (i.hasNext()) {
                Object action = i.next();
                if (!(action instanceof ITargetInvocation)) continue;
                targetInvocation = (ITargetInvocation)action;
                break;
            }
        }
        return targetInvocation;
    }

    public static ITargetInvocation createTargetInvocation(ITestCase input) {
        if (input == null) {
            return null;
        }
        if (input.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)input, false);
        }
        ITargetInvocation targetInvocation = HyadesFactory.INSTANCE.createTargetInvocation(null);
        input.getImplementor().getBlock().getActions().add(targetInvocation);
        return targetInvocation;
    }

    public static String getTestSuiteVariable(ITest testSuite, String variableName) {
        IVariable var = FormUtil.findVariable(testSuite, variableName);
        if (var == null) {
            return null;
        }
        return var.getInitialValue();
    }

    public static void setTestSuiteVariable(ITest testSuite, String variableName, String variableValue) {
        IVariable var = FormUtil.findVariable(testSuite, variableName);
        if (var == null) {
            IVariable varToAdd = HyadesFactory.INSTANCE.createVariable();
            varToAdd.setName(variableName);
            varToAdd.setInitialValue(variableValue);
            testSuite.getVariables().add(varToAdd);
        } else {
            var.setInitialValue(variableValue);
        }
    }

    private static IVariable findVariable(ITest testSuite, String variableName) {
        List variables = testSuite.getVariables();
        int i = 0;
        int variableSize = variables.size();
        while (i < variableSize) {
            IVariable currentVariable = (IVariable)variables.get(i);
            if (currentVariable.getName() != null && currentVariable.getName().equals(variableName)) {
                return currentVariable;
            }
            ++i;
        }
        return null;
    }

    /* synthetic */ FormUtil(FormUtil formUtil) {
        this();
    }

    public class SectionExpanderAdapter
    extends ExpansionAdapter {
        private ScrolledForm form;

        public SectionExpanderAdapter(ScrolledForm form) {
            this.form = form;
        }

        public void expansionStateChanged(ExpansionEvent e) {
            this.form.reflow(true);
        }
    }

    public class FormModifyListener
    implements ModifyListener {
        private IEditorExtension editor;
        private Text nameText;
        private Text descText;
        private int mode;
        private Object input;

        public FormModifyListener(IEditorExtension editor, Text nameText, Text descText, int mode) {
            this.editor = editor;
            this.nameText = nameText;
            this.descText = descText;
            this.mode = mode;
        }

        public void modifyText(ModifyEvent e) {
            if (this.input == null) {
                return;
            }
            boolean isDirty = false;
            String oldfield = null;
            String newfield = null;
            newfield = e.widget == this.nameText ? this.nameText.getText() : this.descText.getText();
            switch (this.mode) {
                case 0: {
                    ITestSuite testSuite = (ITestSuite)this.input;
                    String string = oldfield = e.widget == this.nameText ? testSuite.getName() : testSuite.getDescription();
                    if (oldfield == null) {
                        oldfield = "";
                    }
                    if (!(this.input instanceof ITestSuite) || oldfield.equals(newfield)) break;
                    if (e.widget == this.nameText) {
                        testSuite.setName(newfield);
                    } else {
                        testSuite.setDescription(newfield);
                    }
                    isDirty = true;
                    break;
                }
                case 1: {
                    ITestCase testCase = (ITestCase)this.input;
                    String string = oldfield = e.widget == this.nameText ? testCase.getName() : testCase.getDescription();
                    if (oldfield == null) {
                        oldfield = "";
                    }
                    if (!(this.input instanceof ITestCase) || oldfield.equals(newfield)) break;
                    if (e.widget == this.nameText) {
                        testCase.setName(newfield);
                    } else {
                        testCase.setDescription(newfield);
                    }
                    isDirty = true;
                    break;
                }
                case 2: {
                    BVRInteractionFragment testBehavior = (BVRInteractionFragment)this.input;
                    String string = oldfield = e.widget == this.nameText ? testBehavior.getName() : testBehavior.getDescription();
                    if (oldfield == null) {
                        oldfield = "";
                    }
                    if (!(this.input instanceof BVRInteractionFragment) || oldfield.equals(newfield)) break;
                    if (e.widget == this.nameText) {
                        testBehavior.setName(newfield);
                    } else {
                        testBehavior.setDescription(newfield);
                    }
                    isDirty = true;
                }
            }
            if (isDirty && this.editor instanceof BaseEditorExtension) {
                ((BaseEditorExtension)this.editor).markDirty();
            }
        }

        public void setInput(Object input) {
            this.input = input;
        }
    }

    public class CommonSection {
        public static final byte OVERVIEW = 0;
        public static final byte TEST_CASES = 1;
        public static final byte BEHAVIOR = 2;
        private Composite composite;
        private Text nameText;
        private Text descriptionText;
        private Label namelbl;
        private Label desclbl;
        private byte mode;
        private FormModifyListener modifyListeners;
        private Object input;

        public CommonSection(byte mode) {
            this.mode = mode;
        }

        public Composite createControl(IEditorExtension editor, Section parent, FormToolkit toolkit, String name, String desc) {
            this.composite = toolkit.createComposite((Composite)parent);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 0;
            this.composite.setLayout((Layout)gridLayout);
            this.composite.setLayoutData((Object)new GridData());
            this.namelbl = toolkit.createLabel(this.composite, UiPlugin.getString((String)"LBL_NAME"));
            this.nameText = toolkit.createText(this.composite, name, 0x810800);
            GridData nameTextGD = new GridData();
            nameTextGD.widthHint = (int)((double)parent.getSize().x * 0.931);
            this.nameText.setLayoutData((Object)nameTextGD);
            this.nameText.setEnabled(false);
            this.nameText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(this){
                final /* synthetic */ CommonSection this$1;
                {
                    this.this$1 = commonSection;
                }

                public void getName(AccessibleEvent e) {
                    e.result = UiPlugin.getString((String)"W_NAME");
                }
            });
            this.desclbl = toolkit.createLabel(this.composite, UiPlugin.getString((String)"LBL_DESC"));
            this.descriptionText = toolkit.createText(this.composite, desc, 2816);
            GridData descriptionTextGD = new GridData();
            descriptionTextGD.widthHint = (int)((double)parent.getSize().x * 0.9);
            descriptionTextGD.heightHint = 15 * this.descriptionText.getLineHeight();
            this.descriptionText.setLayoutData((Object)descriptionTextGD);
            this.descriptionText.setEnabled(false);
            this.descriptionText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(this){
                final /* synthetic */ CommonSection this$1;
                {
                    this.this$1 = commonSection;
                }

                public void getName(AccessibleEvent e) {
                    e.result = UiPlugin.getString((String)"W_DESCRIPTION");
                }
            });
            FormUtil formUtil = new FormUtil(null);
            formUtil.getClass();
            this.modifyListeners = formUtil.new FormModifyListener(editor, this.nameText, this.descriptionText, this.mode);
            this.modifyListeners.setInput(this.input);
            this.nameText.addModifyListener((ModifyListener)this.modifyListeners);
            this.descriptionText.addModifyListener((ModifyListener)this.modifyListeners);
            this.composite.addControlListener(new ControlListener(this){
                final /* synthetic */ CommonSection this$1;
                {
                    this.this$1 = commonSection;
                }

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    int parentWidth = ((Composite)e.widget).getSize().x;
                    GridData descriptionTextGD = new GridData();
                    descriptionTextGD.widthHint = (int)((float)parentWidth * 0.9f);
                    descriptionTextGD.heightHint = 15 * CommonSection.access$0(this.this$1).getLineHeight();
                    CommonSection.access$0(this.this$1).setLayoutData((Object)descriptionTextGD);
                    CommonSection.access$0(this.this$1).redraw();
                    GridData nameTextGD = new GridData();
                    nameTextGD.widthHint = (int)((float)parentWidth * 0.931f);
                    CommonSection.access$1(this.this$1).setLayoutData((Object)nameTextGD);
                    CommonSection.access$1(this.this$1).redraw();
                }
            });
            return this.composite;
        }

        public void dispose() {
            this.composite.dispose();
            this.namelbl.dispose();
            this.desclbl.dispose();
            this.nameText.dispose();
            this.descriptionText.dispose();
            this.composite = null;
            this.namelbl = null;
            this.desclbl = null;
            this.nameText = null;
            this.descriptionText = null;
            this.modifyListeners = null;
            this.input = null;
        }

        public void setInput(Object input) {
            boolean controlsAreAvailable;
            String name = null;
            String desc = null;
            boolean bl = controlsAreAvailable = this.nameText != null && this.descriptionText != null;
            if (controlsAreAvailable && input == null) {
                this.nameText.setEnabled(false);
                this.descriptionText.setEnabled(false);
            } else if (controlsAreAvailable) {
                this.nameText.setEnabled(true);
                this.descriptionText.setEnabled(true);
            }
            if (this.modifyListeners != null) {
                this.modifyListeners.setInput(input);
            }
            switch (this.mode) {
                case 0: {
                    if (!(input instanceof ITestSuite)) break;
                    name = ((ITestSuite)input).getName();
                    desc = ((ITestSuite)input).getDescription();
                    this.input = input;
                    break;
                }
                case 1: {
                    if (!(input instanceof ITestCase)) break;
                    name = ((ITestCase)input).getName();
                    desc = ((ITestCase)input).getDescription();
                    this.input = input;
                    break;
                }
                case 2: {
                    if (!(input instanceof BVRInteractionFragment)) break;
                    name = ((BVRInteractionFragment)input).getName();
                    desc = ((BVRInteractionFragment)input).getDescription();
                    this.input = input;
                }
            }
            name = name == null ? "" : name;
            String string = desc = desc == null ? "" : desc;
            if (this.nameText != null && name != null) {
                this.nameText.setText(name);
            }
            if (this.descriptionText != null && desc != null) {
                this.descriptionText.setText(desc);
            }
        }

        static /* synthetic */ Text access$0(CommonSection commonSection) {
            return commonSection.descriptionText;
        }

        static /* synthetic */ Text access$1(CommonSection commonSection) {
            return commonSection.nameText;
        }
    }
}

