/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.util;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class TestCaseAdapter
extends AdapterImpl
implements IDisposable {
    private EStructuralFeature feature;
    private String statusLinePrefix;
    private Composite hyperlinksParent;
    private IEditorExtension editor;

    public TestCaseAdapter(Composite hyperlinkParent, EStructuralFeature feature, String statusLinePrefix, IEditorExtension formEditor) {
        this.feature = feature;
        this.statusLinePrefix = statusLinePrefix;
        this.editor = formEditor;
        this.setHyperLinkComposite(hyperlinkParent);
    }

    public void dispose() {
        this.feature = null;
        this.setTarget(null);
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeature() != this.feature) {
            return;
        }
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.refreshComposite((EObject)msg.getNotifier());
            }
        }
    }

    public void refreshComposite(EObject notifier) {
        FormToolkit toolkit = ((FormEditor)this.editor.getHyadesEditorPart()).getToolkit();
        this.disposeChildren(this.hyperlinksParent);
        EList namedElements = (EList)notifier.eGet(this.feature);
        Iterator i = namedElements.iterator();
        while (i.hasNext()) {
            CMNNamedElement element = (CMNNamedElement)i.next();
            if (element.eIsProxy()) continue;
            final Hyperlink link = toolkit.createHyperlink(this.hyperlinksParent, "", 64);
            link.setData((Object)element);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TestCaseAdapter.this.editor.setSelection((IStructuredSelection)new StructuredSelection(e.widget.getData()));
                }
            });
            link.setToolTipText(element.getName());
            link.setText(element.getName());
            GridData linkGD = GridDataUtil.createHorizontalFill();
            link.setLayoutData((Object)linkGD);
            AdapterImpl testCaseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 2: {
                            link.setText(msg.getNewStringValue());
                        }
                    }
                }
            };
            element.eAdapters().add((Object)testCaseAdapter);
            link.setData("testcase.element", (Object)element);
            link.setData("testcase.adapter", (Object)testCaseAdapter);
            IActionBars actionBars = this.editor.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            if (manager == null) continue;
            String status = this.statusLinePrefix != null ? String.valueOf(this.statusLinePrefix) + link.getText() : link.getText();
            manager.setMessage(status);
        }
        this.hyperlinksParent.redraw();
    }

    protected void disposeChildren(Composite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        int maxi = children.length;
        while (i < maxi) {
            Hyperlink link;
            Object elementObject;
            if (children[i] instanceof Hyperlink && (elementObject = (link = (Hyperlink)children[i]).getData("testcase.element")) != null) {
                CMNNamedElement element = (CMNNamedElement)elementObject;
                element.eAdapters().remove(link.getData("testcase.adapter"));
            }
            children[i].dispose();
            ++i;
        }
    }

    public void setHyperLinkComposite(Composite hyperLinkComposite) {
        this.hyperlinksParent = hyperLinkComposite;
    }

    public Composite getHyperLinkComposite() {
        return this.hyperlinksParent;
    }
}

