/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import java.io.File;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.CoreUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class EnvironmentVariableViewer
implements SelectionListener,
IDisposable {
    private static final String CLASSPATH = Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory().getName();
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private Button btnAdd;
    private Button btnRename;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private TPFTestSuite testSuite;
    private CFGArtifact testSuiteArtifact;

    public EnvironmentVariableViewer(TPFTest test) {
        if (test instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)test;
        } else if (test instanceof TPFTestCase) {
            this.testSuite = ((TPFTestCase)test).getTestSuite();
        }
    }

    public void dispose() {
        this.testSuite = null;
        this.testSuiteArtifact = null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTable(composite);
        WorkbenchHelp.setHelp((Control)composite, (String)(String.valueOf(UiPlugin.getID()) + ".envt0001"));
        WorkbenchHelp.setHelp((Control)this.btnAdd, (String)(String.valueOf(UiPlugin.getID()) + ".envt0002"));
        WorkbenchHelp.setHelp((Control)this.btnDown, (String)(String.valueOf(UiPlugin.getID()) + ".envt0005"));
        WorkbenchHelp.setHelp((Control)this.btnRemove, (String)(String.valueOf(UiPlugin.getID()) + ".envt0003"));
        WorkbenchHelp.setHelp((Control)this.btnRename, (String)(String.valueOf(UiPlugin.getID()) + ".envt0013"));
        WorkbenchHelp.setHelp((Control)this.btnUp, (String)(String.valueOf(UiPlugin.getID()) + ".envt0004"));
        WorkbenchHelp.setHelp((Control)this.tableViewer.getControl(), (String)(String.valueOf(UiPlugin.getID()) + ".envt0014"));
    }

    private void createButtons(Composite parent) {
        this.btnAdd = new Button(parent, 8);
        this.btnAdd.setText(UiPlugin.getString((String)"label.Add"));
        GridData data = GridDataUtil.createHorizontalFill();
        this.btnAdd.setLayoutData((Object)data);
        this.btnAdd.setEnabled(false);
        this.btnRename = new Button(parent, 8);
        this.btnRename.setText(UiPlugin.getString((String)"label.Update"));
        data = GridDataUtil.createHorizontalFill();
        this.btnRename.setLayoutData((Object)data);
        this.btnRename.setEnabled(false);
        this.btnRemove = new Button(parent, 8);
        this.btnRemove.setText(UiPlugin.getString((String)"label.Remove"));
        data = GridDataUtil.createHorizontalFill();
        this.btnRemove.setLayoutData((Object)data);
        this.btnRemove.setEnabled(false);
        this.btnUp = new Button(parent, 8);
        this.btnUp.setText(UiPlugin.getString((String)"LBL_UP"));
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.btnUp.setLayoutData((Object)data);
        this.btnUp.setEnabled(false);
        this.btnDown = new Button(parent, 8);
        this.btnDown.setText(UiPlugin.getString((String)"LBL_DOWN"));
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.btnDown.setLayoutData((Object)data);
        this.btnDown.setEnabled(false);
    }

    private Control createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createTableViewer(composite);
        Composite buttons = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data = new GridData(1040);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnDown.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridDataUtil.createFill();
        table.setLayoutData((Object)data);
        table.computeSize(-1, -1);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(UiPlugin.getString((String)"ENV_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(UiPlugin.getString((String)"ENV_VALUE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(230));
        cellEditors[1] = new TextCellEditor((Composite)table);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        int index;
        if (this.testSuiteArtifact == null) {
            return;
        }
        CFGPropertyGroup propertyGroup = ConfigurationUtil.searchPropertyGroupById((List)this.testSuiteArtifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
        if (propertyGroup == null) {
            return;
        }
        EList properties = propertyGroup.getProperties();
        if (event.widget == this.btnAdd) {
            EnvironmentDialog dlg = new EnvironmentDialog(this.btnAdd.getShell(), null);
            if (dlg.open() == 0) {
                BVRProperty property = dlg.getEnvironmentElement();
                CFGComparableProperty comparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
                comparableProperty.setName(property.getName());
                comparableProperty.setValue(property.getValue());
                comparableProperty.setDescription(property.getDescription());
                properties.add((Object)comparableProperty);
                this.tableViewer.add((Object)property);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)property));
            }
        } else if (event.widget == this.btnRemove) {
            int index2 = this.tableViewer.getTable().getSelectionIndex();
            if (index2 >= 0 && properties.remove(index2) != null) {
                this.tableViewer.getTable().remove(index2);
                int n = index2 = index2 < properties.size() ? index2 : properties.size() - 1;
                if (index2 >= 0) {
                    this.tableViewer.getTable().select(index2);
                }
            }
        } else if (event.widget == this.btnRename) {
            Object obj;
            IStructuredSelection structuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
            if (structuredSelection.size() > 0 && (obj = structuredSelection.getFirstElement()) instanceof BVRProperty) {
                EnvironmentDialog dlg = new EnvironmentDialog(this.btnRename.getShell(), (BVRProperty)obj);
                dlg.open();
                if (dlg.getReturnCode() == 0) {
                    this.tableViewer.update(obj, null);
                }
            }
        } else if (event.widget == this.btnUp) {
            int index3 = this.tableViewer.getTable().getSelectionIndex();
            if (index3 > 0) {
                CoreUtil.swap((List)properties, (int)index3, (int)(index3 - 1));
                this.tableViewer.refresh();
                this.tableViewer.getTable().select(index3 - 1);
            }
        } else if (event.widget == this.btnDown && (index = this.tableViewer.getTable().getSelectionIndex()) < properties.size() - 1) {
            CoreUtil.swap((List)properties, (int)index, (int)(index + 1));
            this.tableViewer.refresh();
            this.tableViewer.getTable().select(index + 1);
        }
        this.btnAdd.setEnabled(this.testSuiteArtifact != null);
        boolean enable = this.testSuiteArtifact != null && !this.tableViewer.getSelection().isEmpty();
        this.btnRemove.setEnabled(enable);
        this.btnRename.setEnabled(enable);
        this.btnUp.setEnabled(enable && this.tableViewer.getTable().getSelectionIndex() > 0);
        this.btnDown.setEnabled(enable && this.tableViewer.getTable().getSelectionIndex() < properties.size() - 1);
    }

    public void setInput(CFGArtifact artifact) {
        this.testSuiteArtifact = artifact;
        this.tableViewer.setInput((Object)this.testSuiteArtifact);
        this.btnAdd.setEnabled(this.testSuiteArtifact != null);
        boolean enable = this.testSuiteArtifact != null && !this.tableViewer.getSelection().isEmpty();
        this.btnDown.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
        this.btnRename.setEnabled(enable);
        this.btnUp.setEnabled(enable);
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            CFGPropertyGroup propertyGroup;
            if (element instanceof CFGArtifact && (propertyGroup = ConfigurationUtil.searchPropertyGroupById((List)((CFGArtifact)element).getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes")) != null) {
                return propertyGroup.getProperties().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BVRProperty) {
                BVRProperty myTableElement = (BVRProperty)element;
                if (columnIndex == 0) {
                    return myTableElement.getName();
                }
                if (columnIndex == 1) {
                    return myTableElement.getValue();
                }
            }
            return "";
        }
    }

    public static class EnvironmentDialog
    extends Dialog
    implements Listener {
        private BVRProperty element;
        private EnvironmentUI environmentUI;

        public EnvironmentDialog(Shell shell, BVRProperty element) {
            super(shell);
            this.element = element;
        }

        protected Control createDialogArea(Composite parent) {
            if (this.element == null) {
                this.getShell().setText(UiPlugin.getString((String)"ADD_ENV_DESC_DLG"));
            } else {
                this.getShell().setText(UiPlugin.getString((String)"EDIT_ENV_DESC_DLG"));
            }
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)GridDataUtil.createFill());
            result.setLayout((Layout)new GridLayout());
            this.environmentUI = new EnvironmentUI(this.getShell());
            Composite content = this.environmentUI.createControl(result);
            if (this.element != null) {
                this.environmentUI.setName(this.element.getName());
                this.environmentUI.setValue(this.element.getValue());
                this.environmentUI.setDescription(this.element.getDescription());
            }
            WorkbenchHelp.setHelp((Control)content, (String)(String.valueOf(UiPlugin.getID()) + ".envt0006"));
            return content;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.environmentUI.registerListener(this);
            if (this.element == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.element == null) {
                this.element = Common_Behavior_InteractionsFactory.eINSTANCE.createBVRProperty();
            }
            this.element.setName(this.environmentUI.getName());
            this.element.setValue(this.environmentUI.getValue());
            this.element.setDescription(this.environmentUI.getDescription());
            super.okPressed();
        }

        public BVRProperty getEnvironmentElement() {
            return this.element;
        }

        public void handleEvent(Event e) {
            this.getButton(0).setEnabled(!this.environmentUI.getName().equals("") && !this.environmentUI.getValue().equals(""));
        }
    }

    private static class EnvironmentUI
    implements SelectionListener,
    ModifyListener {
        private Text _name;
        private Text _classpath;
        private Text _description;
        private Button _browseClass;
        private Button _browseDirPath;
        private Button _browseJarPath;
        private Shell shell;
        private Listener _listener;

        public EnvironmentUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createArgumentsControl(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            label.setText(UiPlugin.getString((String)"ENV_VALUE"));
            label.setLayoutData((Object)gd);
            this._classpath = new Text(parent, 2882);
            gd = GridDataUtil.createFill();
            gd.heightHint = 100;
            gd.widthHint = 250;
            this._classpath.setLayoutData((Object)gd);
            Composite btnGroup = new Composite(parent, 0);
            gd = GridDataUtil.createVerticalFill();
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            btnGroup.setLayoutData((Object)gd);
            btnGroup.setLayout((Layout)layout);
            this._browseDirPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            this._browseDirPath.setLayoutData((Object)gd);
            this._browseDirPath.setText(UiPlugin.getString((String)"ADD_DIRECTORY"));
            this._browseJarPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this._browseJarPath.setLayoutData((Object)gd);
            this._browseJarPath.setText(UiPlugin.getString((String)"ADD_JAR"));
            this._browseDirPath.addSelectionListener((SelectionListener)this);
            this._browseJarPath.addSelectionListener((SelectionListener)this);
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(String.valueOf(UiPlugin.getID()) + ".envt0011"));
            WorkbenchHelp.setHelp((Control)this._browseDirPath, (String)(String.valueOf(UiPlugin.getID()) + ".envt0008"));
            WorkbenchHelp.setHelp((Control)this._browseJarPath, (String)(String.valueOf(UiPlugin.getID()) + ".envt0009"));
            return parent;
        }

        public Composite createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 5;
            content.setLayout((Layout)layout);
            GridData gd = GridDataUtil.createFill();
            gd.horizontalIndent = 5;
            content.setLayoutData((Object)gd);
            Label label = new Label(content, 0);
            label.setText(UiPlugin.getString((String)"ENV_NAME"));
            this._name = new Text(content, 2052);
            gd = GridDataUtil.createHorizontalFill();
            gd.horizontalSpan = 2;
            this._name.setLayoutData((Object)gd);
            this._name.setFocus();
            this._name.selectAll();
            this._name.addModifyListener((ModifyListener)this);
            this.createArgumentsControl(content);
            this._classpath.addModifyListener((ModifyListener)this);
            label = new Label(content, 0);
            label.setText(UiPlugin.getString((String)"ENV_DESCRIPTION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            label.setLayoutData((Object)gd);
            this._description = new Text(content, 2882);
            gd = GridDataUtil.createHorizontalFill();
            gd.heightHint = 100;
            this._description.setLayoutData((Object)gd);
            WorkbenchHelp.setHelp((Control)this._description, (String)(String.valueOf(UiPlugin.getID()) + ".envt0012"));
            WorkbenchHelp.setHelp((Control)this._name, (String)(String.valueOf(UiPlugin.getID()) + ".envt0010"));
            return content;
        }

        public String getValue() {
            return this._classpath.getText().trim();
        }

        public Control getBrowseJarButton() {
            return this._browseJarPath;
        }

        public Control getBrowseDirButton() {
            return this._browseDirPath;
        }

        public String getName() {
            return this._name.getText().trim();
        }

        public String getDescription() {
            return this._description.getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent e) {
            String osName = System.getProperty("os.name");
            if (e.widget == this._browseClass) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.class"});
                dlg.open();
                String fileName = dlg.getFileName();
                if (fileName != null && !fileName.equals("")) {
                    String oldClassPath;
                    if (fileName.endsWith(".class")) {
                        fileName = fileName.substring(0, fileName.length() - 6);
                    }
                    String classpath = dlg.getFilterPath();
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = String.valueOf(classpath) + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    this._classpath.setText(String.valueOf(oldClassPath) + classpath);
                }
            } else if (e.widget == this._browseDirPath) {
                DirectoryDialog dlg = new DirectoryDialog(this.shell);
                String classpath = dlg.open();
                if (classpath != null && !classpath.equals("")) {
                    String oldClassPath;
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = String.valueOf(classpath) + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    classpath = String.valueOf(oldClassPath) + classpath;
                    this._classpath.setText(classpath);
                    this._classpath.setFocus();
                }
            } else if (e.widget == this._browseJarPath) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
                dlg.open();
                String classpath = dlg.getFileName();
                if (classpath != null && !classpath.equals("")) {
                    classpath = String.valueOf(dlg.getFilterPath()) + File.separator + classpath;
                    String oldClassPath = this._classpath.getText().trim();
                    oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    classpath = String.valueOf(oldClassPath) + classpath;
                    this._classpath.setText(classpath);
                }
            }
        }

        public void modifyText(ModifyEvent e) {
            this.notifyListener();
        }

        public void setValue(String text) {
            if (text != null) {
                this._classpath.setText(text);
            } else {
                this._classpath.setText("");
            }
        }

        public void setName(String text) {
            if (text != null) {
                this._name.setText(text);
            } else {
                this._name.setText("");
            }
        }

        public void setDescription(String text) {
            if (text != null) {
                this._description.setText(text);
            } else {
                this._description.setText("");
            }
        }

        public void registerListener(Listener listener) {
            this._listener = listener;
        }

        public void notifyListener() {
            if (this._listener != null) {
                this._listener.handleEvent(null);
            }
        }
    }
}

