/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.RunWizard;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class RunDestinationPage
extends WizardPage
implements Listener {
    private ResourceAndContainerGroup containerSelectionGroup;
    private IContainer initialContainer;

    public RunDestinationPage() {
        super("location");
        this.setTitle(ToolsUiPlugin.getString("RUN_WTITLE"));
        this.setDescription(ToolsUiPlugin.getString("RUN_LDESC"));
    }

    public void setInitialDestination(IContainer initialContainer) {
        this.initialContainer = initialContainer;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData data = GridDataUtil.createFill();
        data.heightHint = 300;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.containerSelectionGroup = new ResourceAndContainerGroup(composite, (Listener)this, ToolsUiPlugin.getString("LOCATION_OUTPUT_LABEL"), "file", true, data.heightHint);
        this.containerSelectionGroup.setResource(((RunWizard)this.getWizard()).getExecutionResultInitialName());
        if (this.initialContainer != null) {
            this.containerSelectionGroup.setContainerFullPath(this.initialContainer.getFullPath());
        }
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addb0003"));
        WorkbenchHelp.setHelp((Control)composite, (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addb0004"));
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public String getExecutionResultName() {
        return this.containerSelectionGroup.getResource().trim();
    }

    public IPath getContainerPath() {
        return this.containerSelectionGroup.getContainerFullPath();
    }

    protected boolean validatePage() {
        IPath path = this.containerSelectionGroup.getContainerFullPath();
        if (path == null || path.segmentCount() == 0) {
            this.setErrorMessage(ToolsUiPlugin.getString("RUN_LOC_NOCONT"));
            return false;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(path.segment(0)) == null) {
            this.setErrorMessage(ToolsUiPlugin.getString("RUN_LOC_NOCONT"));
            return false;
        }
        String name = this.getExecutionResultName();
        if (name.length() == 0) {
            this.setErrorMessage(ToolsUiPlugin.getString("RUN_LOC_EMPTY_NAME"));
            return false;
        }
        if (name.indexOf("\\") >= 0 || name.indexOf("/") >= 0) {
            this.setErrorMessage(ToolsUiPlugin.getString("RUN_LOC_INVALID_NAME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

