/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.DeploymentUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.EnvironmentVariableViewer;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.RunWizard;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.EMFContentProvider;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RunLocationPage
extends WizardPage
implements Listener {
    protected AbstractTreeViewer hostViewer;
    private Button filterButton;
    private HostsContentProvider contentProvider;
    private URI initialLocationURI;
    private EnvironmentVariableViewer environmentVariableViewer;
    private boolean showEvironmentVariableViewer;
    private TPFTestSuite testSuite;
    private CFGArtifact testSuiteArtifact;
    private TPFDeployment deployment;

    public RunLocationPage(boolean showEvironmentVariableViewer) {
        super("node");
        this.setTitle(UiPlugin.getString((String)"RUN_WTITLE"));
        this.setDescription(UiPlugin.getString((String)"RUN_NODED"));
        this.showEvironmentVariableViewer = showEvironmentVariableViewer;
    }

    public void dispose() {
        if (this.showEvironmentVariableViewer) {
            this.environmentVariableViewer.dispose();
        }
        super.dispose();
    }

    public void setInitialLocationURI(URI initialLocationURI) {
        this.initialLocationURI = initialLocationURI;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 100;
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(UiPlugin.getString((String)"SHOW_FOLDERS"));
        this.filterButton.addListener(13, (Listener)this);
        this.createViewer(composite);
        TPFTest test = ((RunWizard)this.getWizard()).getTest();
        if (test instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)test;
        } else if (test instanceof TPFTestCase) {
            this.testSuite = ((TPFTestCase)test).getTestSuite();
        }
        if (this.showEvironmentVariableViewer) {
            Label label = new Label(composite, 0);
            label.setText(UiPlugin.getString((String)"LBL_ENV_SETS"));
            this.environmentVariableViewer = new EnvironmentVariableViewer((TPFTest)this.testSuite);
            this.environmentVariableViewer.createControl(composite);
        }
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addListener(13, (Listener)this);
        if (this.initialLocationURI == null) {
            ((TreeViewer)this.hostViewer).expandToLevel(2);
        } else {
            EObject eObject = null;
            try {
                eObject = this.getResourceSet().getEObject(this.initialLocationURI, true);
            }
            catch (Exception exception) {}
            if (eObject != null && eObject instanceof CFGLocation) {
                this.hostViewer.setSelection((ISelection)new StructuredSelection((Object)eObject));
                this.setDeployment();
            }
        }
        this.setControl((Control)composite);
        this.setPageComplete(this.deployment != null);
        WorkbenchHelp.setHelp((Control)composite, (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addb0005"));
        WorkbenchHelp.setHelp((Control)this.filterButton, (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addb0006"));
        WorkbenchHelp.setHelp((Control)this.hostViewer.getControl(), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".addb0007"));
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.filterButton) {
                this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
                ISelection selection = this.hostViewer.getSelection();
                this.hostViewer.refresh();
                if (!selection.isEmpty()) {
                    this.hostViewer.setSelection(selection, true);
                }
            }
            this.setDeployment();
        }
        this.setPageComplete(this.getDeployment() != null);
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new HostsContentProvider();
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new HostsLabelProvider(true));
        this.contentProvider.setFilter(2);
        ViewerSorter sorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(sorter);
        return this.hostViewer;
    }

    protected ITreeContentProvider initializeContentProvider() {
        EMFContentProvider contentProvider = new EMFContentProvider(this.getResourceSet());
        EMFContentProvider.ElementDescription elementDescription = new EMFContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFSUT());
        contentProvider.addElementDescription(elementDescription);
        return contentProvider;
    }

    public ResourceSet getResourceSet() {
        return ((RunWizard)this.getWizard()).getResourceSet();
    }

    public TPFDeployment getDeployment() {
        return this.deployment;
    }

    public CFGArtifact getTestSuiteArtifact() {
        if (this.testSuiteArtifact == null && this.testSuite != null && this.deployment != null) {
            this.testSuiteArtifact = DeploymentUtil.associateTestAsset((CFGClass)this.testSuite, (TPFDeployment)this.deployment).getArtifact();
        }
        return this.testSuiteArtifact;
    }

    public void setDeployment() {
        ISelection selection = this.hostViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel != null && sel instanceof TPFDeployment) {
                this.deployment = (TPFDeployment)sel;
            } else if (sel != null && sel instanceof CFGLocation) {
                Object child = sel;
                Object parent = null;
                while (!(parent instanceof TPFDeployment)) {
                    child = parent = this.contentProvider.getParent(child);
                }
                this.deployment = (TPFDeployment)parent;
                CFGLocation cfr_ignored_0 = (CFGLocation)sel;
            }
            if (this.deployment == null) {
                return;
            }
            this.testSuiteArtifact = DeploymentUtil.associateTestAsset((CFGClass)this.testSuite, (TPFDeployment)this.deployment).getArtifact();
        }
        if (this.environmentVariableViewer != null) {
            this.environmentVariableViewer.setInput(this.testSuiteArtifact);
        }
    }

    private class HostsContentProvider
    implements ITreeContentProvider {
        public static final int FILTER_FOLDERS = 2;
        public static final int SHOW_ALL = 4;
        private int filter;
        private ArrayList list = new ArrayList();

        public int getFilter() {
            return this.filter;
        }

        public void setFilter(int filter) {
            this.filter = filter;
        }

        public void dispose() {
            this.list.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (eObject instanceof CFGMachine) {
                    return eObject.eContainer();
                }
                if (eObject instanceof CFGMachineConstraint && RunLocationPage.this.hostViewer != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree() != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection() != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection().length > 0) {
                    TreeItem parentItem = ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection()[0].getParentItem();
                    if (parentItem == null) {
                        return null;
                    }
                    Object data = parentItem.getData();
                    if (data != null && data instanceof TPFDeployment) {
                        return data;
                    }
                }
                switch (this.filter) {
                    case 4: {
                        IFile file = EMFUtil.getWorkspaceFile((EObject)eObject);
                        if (file == null) break;
                        return file.getParent();
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkspaceRoot) {
                if (this.getFilter() == 2) {
                    this.list.clear();
                    IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
                    int idx = 0;
                    while (idx < projects.length) {
                        Object[] children = this.getChildren(projects[idx]);
                        int i = 0;
                        while (i < children.length) {
                            this.list.add(children[i]);
                            ++i;
                        }
                        ++idx;
                    }
                    return this.list.toArray();
                }
                return ((IWorkspaceRoot)inputElement).getProjects();
            }
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                UniqueEList children = new UniqueEList();
                IResource[] resources = null;
                try {
                    resources = ((IContainer)parentElement).members();
                }
                catch (CoreException e) {
                    UiPlugin.logError((Throwable)e);
                    return new Object[0];
                }
                int i = 0;
                int maxi = resources.length;
                while (i < maxi) {
                    if (resources[i].getType() != 1) {
                        if (this.filter == 2) {
                            Object[] tmpArray = this.getChildren(resources[i]);
                            int k = 0;
                            while (k < tmpArray.length) {
                                children.add(tmpArray[k]);
                                ++k;
                            }
                        } else {
                            children.add(resources[i]);
                        }
                    } else {
                        IFile file = (IFile)resources[i];
                        if ("deploy".equals(file.getFileExtension())) {
                            EObject[] eObjects = EMFUtil.load((ResourceSet)RunLocationPage.this.getResourceSet(), (IFile)((IFile)resources[i]));
                            int idx = 0;
                            while (idx < eObjects.length) {
                                EObject eObject = eObjects[idx];
                                if (eObject instanceof TPFDeployment) {
                                    children.add(eObject);
                                }
                                ++idx;
                            }
                        }
                    }
                    ++i;
                }
                return children.toArray();
            }
            if (parentElement instanceof Resource) {
                return ((Resource)parentElement).getContents().toArray();
            }
            if (parentElement instanceof TPFDeployment) {
                UniqueEList children = new UniqueEList();
                if (((TPFDeployment)parentElement).getLocations().size() == 0) {
                    children.addAll(((TPFDeployment)parentElement).getRefLocations());
                } else {
                    children.addAll(((TPFDeployment)parentElement).getLocations());
                }
                return children.toArray();
            }
            return new Object[0];
        }
    }

    private class HostsLabelProvider
    extends LabelProvider {
        private Hashtable ovelayCache;
        private boolean useImages;
        static /* synthetic */ Class class$0;

        public HostsLabelProvider(boolean useImages) {
            this.useImages = useImages;
            this.ovelayCache = new Hashtable();
        }

        public Image getImage(Object element) {
            if (!this.useImages || element == null) {
                return null;
            }
            if (element instanceof TPFDeployment) {
                return TestUIImages.INSTANCE.getImage("deployment_obj.gif");
            }
            if (element instanceof CFGMachineConstraint) {
                return HyadesUIImages.INSTANCE.getImage("node_obj.gif");
            }
            if (element instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (element instanceof IAdaptable) {
                IWorkbenchAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    return adapter.getImageDescriptor(element).createImage();
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            String text = null;
            if (element instanceof TPFDeployment) {
                text = ((TPFDeployment)element).getName();
            } else if (element instanceof CFGLocation) {
                text = ((CFGLocation)element).getName();
            } else if (element instanceof IAdaptable) {
                IWorkbenchAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    text = adapter.getLabel(element);
                }
            }
            if (text == null) {
                text = element.toString();
            }
            return text;
        }

        public void dispose() {
            if (this.ovelayCache != null) {
                Iterator i = this.ovelayCache.values().iterator();
                while (i.hasNext()) {
                    Image image = (Image)i.next();
                    image.dispose();
                }
                this.ovelayCache.clear();
            }
            super.dispose();
        }
    }
}

