/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.RunDestinationPage;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.RunLocationPage;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class RunWizard
extends Wizard
implements IWorkbenchWizard {
    protected static final String SET_DESTINATION = "SET_DESTINATION";
    protected static final String SET_LOCATION = "SET_LOCATION";
    protected RunDestinationPage destinationPage;
    protected RunLocationPage locationPage;
    protected IStructuredSelection selection;
    protected ResourceSet resourceSet;
    protected TPFTest test;

    public RunWizard() {
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("run_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("RunWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("RunWizard");
        }
        this.setDialogSettings(settings);
    }

    public void dispose() {
        this.test = null;
        if (this.resourceSet != null) {
            this.resourceSet.getResources().clear();
            this.resourceSet = null;
        }
        super.dispose();
    }

    public void createPageControls(Composite pageContainer) {
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 450;
        pageContainer.setLayoutData((Object)gridData);
        super.createPageControls(pageContainer);
    }

    public void addPages() {
        String settings;
        this.setWindowTitle(UiPlugin.getString((String)"RUN_WTITLE"));
        this.destinationPage = this.createDestionationPage();
        if (this.destinationPage != null) {
            this.addPage((IWizardPage)this.destinationPage);
            settings = this.getDialogSettings().get(SET_DESTINATION + this.getTest().getId());
            if (settings == null) {
                IFile file = EMFUtil.getWorkspaceFile((EObject)this.getTest());
                if (file != null) {
                    this.destinationPage.setInitialDestination(file.getParent());
                }
            } else {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(settings);
                if (resource != null) {
                    if (resource instanceof IContainer) {
                        this.destinationPage.setInitialDestination((IContainer)resource);
                    } else {
                        this.destinationPage.setInitialDestination(resource.getParent());
                    }
                }
            }
        }
        this.locationPage = this.createLocationPage();
        if (this.locationPage != null) {
            this.addPage((IWizardPage)this.locationPage);
            settings = this.getDialogSettings().get(SET_LOCATION);
            if (settings != null) {
                this.locationPage.setInitialLocationURI(URI.createURI((String)settings));
            }
        }
    }

    protected String getExecutionResultInitialName() {
        StringBuffer name = new StringBuffer(this.getTest().getName()).append("_");
        name.append(DateFormat.getDateTimeInstance(2, 2).format(new Date()));
        return name.toString();
    }

    protected RunDestinationPage createDestionationPage() {
        return new RunDestinationPage();
    }

    protected RunLocationPage createLocationPage() {
        return new RunLocationPage(true);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public TPFTest getTest() {
        return this.test;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object object;
        this.selection = selection;
        if (selection != null && !selection.isEmpty() && (object = selection.getFirstElement()) instanceof TPFTest) {
            this.resourceSet = new ResourceSetImpl();
            this.test = (TPFTest)EMFUtil.getEObject((ResourceSet)this.resourceSet, (EObject)((TPFTest)object), (boolean)true);
            this.getTest().eResource().setTrackingModification(true);
        }
    }

    public String getExecutionResultName() {
        if (this.destinationPage == null) {
            return null;
        }
        return this.destinationPage.getExecutionResultName();
    }

    public IPath getContainerPath() {
        if (this.destinationPage == null) {
            return null;
        }
        return this.destinationPage.getContainerPath();
    }

    public TPFDeployment getDeployment() {
        if (this.locationPage == null) {
            return null;
        }
        return this.locationPage.getDeployment();
    }

    public BVRProperty[] getEnvironmentVariables() {
        CFGArtifact artifact;
        if (this.locationPage != null && (artifact = this.locationPage.getTestSuiteArtifact()) != null) {
            CFGPropertyGroup propertyGroup = ConfigurationUtil.searchPropertyGroupById((List)artifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
            Object environmentVariables = propertyGroup.getProperties();
            environmentVariables = EcoreUtil.copyAll((Collection)environmentVariables);
            return environmentVariables.toArray(new BVRProperty[environmentVariables.size()]);
        }
        return new BVRProperty[0];
    }

    protected void saveSettings() {
        IPath destinationPath = this.getContainerPath();
        if (destinationPath != null) {
            this.getDialogSettings().put(SET_DESTINATION + this.getTest().getId(), this.getContainerPath().toString());
        }
        TPFDeployment deployment = this.getDeployment();
        CFGArtifactLocationPair pair = (CFGArtifactLocationPair)deployment.getArtifactLocations().get(0);
        CFGLocation location = null;
        if (pair != null) {
            location = pair.getLocation();
        }
        if (location != null) {
            URI uri = EcoreUtil.getURI((EObject)location);
            this.getDialogSettings().put(SET_LOCATION, uri.toString());
        }
    }

    public final boolean performFinish() {
        ITestSuite testSuite = null;
        if (this.getTest() instanceof ITestSuite) {
            testSuite = (ITestSuite)this.getTest();
        } else if (this.getTest() instanceof ITestCase) {
            testSuite = ((ITestCase)this.getTest()).getOwner();
        }
        if (this.locationPage != null && this.locationPage.getTestSuiteArtifact() != null) {
            List environmentVariableProperties = ((IDeployableComponent)testSuite).getEnvironmentVariables().getProperties();
            environmentVariableProperties.clear();
            environmentVariableProperties.addAll(Arrays.asList(this.getEnvironmentVariables()));
        }
        if (!this.doPerformFinish()) {
            return false;
        }
        this.saveSettings();
        SaveManager.getInstance().start(TestCorePlugin.getDefault().getPluginPreferences().getLong("saveInterval"));
        return true;
    }

    protected abstract boolean doPerformFinish();
}

