/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.JavaUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public abstract class TestSuiteNewWizard
extends HyadesNewWizard {
    protected abstract String getType();

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getLocationPage());
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        this.createObject(resource);
        Iterator i = resource.getResourceSet().getResources().iterator();
        while (i.hasNext()) {
            EMFUtil.save((Resource)((Resource)i.next()));
        }
        return true;
    }

    protected void createObject(Resource resource) {
        ITestSuite testSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        testSuite.setType(this.getType());
        testSuite.setName(this.getLocationPage().getItemName());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            testSuite.setDescription(description);
        }
        if (testSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)testSuite, false);
        }
        this.registerResource(testSuite);
    }

    protected void registerResource(ITestSuite testSuite) {
        String clsName = JavaUtil.getValidClassName((String)testSuite.getName(), (boolean)true);
        if (clsName == null) {
            clsName = "Test";
        }
        testSuite.getImplementor().setResource("test." + clsName);
    }

    protected Resource createResource(IFile file) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        return resourceSet.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        if (UiPlugin.getDefault().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart", (boolean)false);
        }
    }
}

