/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.codegen;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.http.runner.HttpHeader;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.ImportManager;
import org.eclipse.hyades.test.tools.ui.http.internal.codegen.GenTestSuite;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;

class GenTestSuite {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "\t\t" + this.NL;
    protected final String TEXT_2 = String.valueOf(this.NL) + "package ";
    protected final String TEXT_3 = ";" + this.NL;
    protected final String TEXT_4 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * Generated code for the test suite <b>";
    protected final String TEXT_5 = "</b> located at" + this.NL + " * <i>";
    protected final String TEXT_6 = "</i>";
    protected final String TEXT_7 = ".";
    protected final String TEXT_8 = String.valueOf(this.NL) + " *" + this.NL + " * ";
    protected final String TEXT_9 = String.valueOf(this.NL) + " */" + this.NL + "public class ";
    protected final String TEXT_10 = String.valueOf(this.NL) + "extends ";
    protected final String TEXT_11 = String.valueOf(this.NL) + "{" + this.NL + "\t/**" + this.NL + "\t * Constructor for ";
    protected final String TEXT_12 = "." + this.NL + "\t * @param name" + this.NL + "\t */" + this.NL + "\tpublic ";
    protected final String TEXT_13 = "(String name)" + this.NL + "\t{" + this.NL + "\t\tsuper(name);" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Returns the JUnit test suite that implements the <b>";
    protected final String TEXT_14 = "</b>" + this.NL + "\t * definition." + this.NL + "\t */" + this.NL + "\tpublic static Test suite()" + this.NL + "\t{";
    protected final String TEXT_15 = "\t\t";
    protected final String TEXT_16 = " ";
    protected final String TEXT_17 = " = new ";
    protected final String TEXT_18 = "(\"";
    protected final String TEXT_19 = "\");" + this.NL + "\t\t";
    protected final String TEXT_20 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
    protected final String TEXT_21 = "\");" + this.NL + "\t\t";
    protected final String TEXT_22 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_23 = String.valueOf(this.NL) + this.NL + "\t\treturn ";
    protected final String TEXT_24 = ";" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * @see junit.framework.TestCase#setUp()" + this.NL + "\t */" + this.NL + "\tprotected void setUp()" + this.NL + "\tthrows ";
    protected final String TEXT_25 = String.valueOf(this.NL) + "\t{" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * @see junit.framework.TestCase#tearDown()" + this.NL + "\t */" + this.NL + "\tprotected void tearDown()" + this.NL + "\tthrows ";
    protected final String TEXT_26 = String.valueOf(this.NL) + "\t{" + this.NL + "\t}\t";
    protected final String TEXT_27 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * ";
    protected final String TEXT_28 = String.valueOf(this.NL) + " *" + this.NL + " * ";
    protected final String TEXT_29 = String.valueOf(this.NL) + " * ";
    protected final String TEXT_30 = String.valueOf(this.NL) + " * @throws ";
    protected final String TEXT_31 = String.valueOf(this.NL) + " */" + this.NL + "\tpublic void ";
    protected final String TEXT_32 = "()" + this.NL + "\tthrows ";
    protected final String TEXT_33 = String.valueOf(this.NL) + "\t{" + this.NL + "\t\t";
    protected final String TEXT_34 = String.valueOf(this.NL) + "\t}";
    protected final String TEXT_35 = this.NL;
    protected final String TEXT_36 = "\t/*********************" + this.NL + "\t *  Member variables *" + this.NL + "\t *********************/" + this.NL + "\tstatic protected ";
    protected final String TEXT_37 = "[] m_httpCookieCache;" + this.NL + "\tstatic protected ";
    protected final String TEXT_38 = "[] m_httpExecutor;" + this.NL + "\tprotected ";
    protected final String TEXT_39 = " rand = new Random();" + this.NL + "\t" + this.NL + "\t/*********************" + this.NL + "\t *    Extra Methods  *" + this.NL + "\t *********************/" + this.NL + "\tpublic void populateCookieCache(";
    protected final String TEXT_40 = " cookies)" + this.NL + "\t{" + this.NL + "\t\t//By default, the cookie cache is created empty.  To add new cookies, use the following" + this.NL + "\t\t//cookies.AddCookie(name, value, domain, path, expires, bSecure);" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\tprotected void executeRequest(";
    protected final String TEXT_41 = " request)" + this.NL + "\tthrows ";
    protected final String TEXT_42 = String.valueOf(this.NL) + "\t{" + this.NL + "\t\tif (m_httpExecutor == null || m_httpCookieCache == null)" + this.NL + "\t\t\tinitializeTest();" + this.NL + this.NL + "\t\tint nUser = ";
    protected final String TEXT_43 = ".getCurrentUser(this);" + this.NL + "\t\tm_httpCookieCache[nUser].DynamicGetCookie(request);" + this.NL + "\t\t";
    protected final String TEXT_44 = " response = m_httpExecutor[nUser].execute(request);" + this.NL + "\t\t" + this.NL + "\t\tString text = \"rc=\" + Integer.toString(response.getCode());" + this.NL + "\t\tif(response.getDetail() != null)" + this.NL + "\t\t\ttext = \"\\n\\n\" + response.getDetail();" + this.NL + this.NL + "\t\t//If (response.getCode() < 0) then there was an error when executing the request" + this.NL + "\t\tif(response.getCode() < 0)" + this.NL + "\t\t\tthrow new ";
    protected final String TEXT_45 = "(text);" + this.NL + this.NL + "       try {" + this.NL + "\t         m_httpCookieCache[nUser].DynamicSetCookie(request, response);" + this.NL + "\t       }" + this.NL + "\t   catch(Exception e)" + this.NL + "\t       {" + this.NL + "\t       }" + this.NL + "\t\t" + this.NL + "\t\t//If (response.getCode() < 400) then the request has failed." + this.NL + "\t\tassertTrue(text, response.getCode() < 400 && response.getCode() > 0);" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\tsynchronized protected void initializeTest() " + this.NL + "\t{" + this.NL + "\t\tint nTotal = ";
    protected final String TEXT_46 = ".getTotalUsers(this);" + this.NL + "\t\tif (m_httpCookieCache == null)" + this.NL + "\t\t{" + this.NL + "\t\t\tm_httpCookieCache = new ";
    protected final String TEXT_47 = "[nTotal];" + this.NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + this.NL + "\t\t\t{ " + this.NL + "\t\t\t\tm_httpCookieCache[i] = new ";
    protected final String TEXT_48 = "();" + this.NL + "\t\t\t\tpopulateCookieCache(m_httpCookieCache[i]);" + this.NL + "\t\t\t}" + this.NL + "\t\t\t " + this.NL + "\t\t}" + this.NL + "\t\tif (m_httpExecutor == null)" + this.NL + "\t\t{\t" + this.NL + "\t\t\tm_httpExecutor = new ";
    protected final String TEXT_49 = "[nTotal];" + this.NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + this.NL + "\t\t\t{" + this.NL + "\t\t\t\tm_httpExecutor[i] = new ";
    protected final String TEXT_50 = "();" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + "\t}\t" + this.NL + "\t" + this.NL + "\tprotected long calcThinkTime(long think, int var) " + this.NL + "\t{" + this.NL + "\t\tif (var > 0 && var <= 99) {" + this.NL + "\t\t\tlong delta = think * var / 100;" + this.NL + "\t\t\tif (delta <= 0)" + this.NL + "\t\t\t\tdelta = 1;\t\t\t" + this.NL + "\t\t\tthink += (rand.nextInt((int) delta * 2) - delta);" + this.NL + "\t\t}" + this.NL + "\t\treturn think;" + this.NL + "\t}" + this.NL + "\t}";

    GenTestSuite() {
    }

    public String generate(ITestSuite testSuite, Helper helper) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        String packageName = helper.getPackageName((Object)testSuite);
        String className = helper.retrieveClassName((INamedElement)testSuite);
        String description = testSuite.getDescription();
        description = description != null ? StringUtil.replace((String)description.trim(), (String)this.NL, (String)(String.valueOf(this.NL) + " * ")) : "";
        helper.setImportManager(new ImportManager(packageName));
        helper.getImportedName(String.valueOf(packageName) + "." + className);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_3);
        helper.addImport("junit.framework.Test");
        helper.addImport("org.eclipse.hyades.test.common.junit.DefaultTestArbiter");
        helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestCase");
        helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
        helper.markImportLocation(stringBuffer);
        String hyadesTestSuiteClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
        String hyadesTestCaseClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestCase");
        String exceptionClassName = helper.getImportedName("java.lang.Exception");
        String filePath = helper.getFilePath((Object)testSuite);
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(TestUIUtil.getLabel((Object)testSuite));
        if (filePath != null) {
            stringBuffer.append(this.TEXT_5);
            stringBuffer.append(filePath);
            stringBuffer.append("</i>");
        }
        stringBuffer.append(".");
        if (description.length() > 0) {
            stringBuffer.append(this.TEXT_8);
            stringBuffer.append(description);
        }
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(hyadesTestCaseClassName);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(TestUIUtil.getLabel((Object)testSuite));
        stringBuffer.append(this.TEXT_14);
        String javaElement = helper.retrieveIdentifierName((INamedElement)testSuite, (Object)"SUITE");
        class InvocationGenerator {
            private String hyadesTestSuiteClassName;
            final /* synthetic */ GenTestSuite this$0;
            private final /* synthetic */ Helper val$helper;

            public InvocationGenerator(GenTestSuite genTestSuite, String hyadesTestSuiteClassName, Helper helper) {
                this.this$0 = genTestSuite;
                this.val$helper = helper;
                this.hyadesTestSuiteClassName = hyadesTestSuiteClassName;
            }

            public StringBuffer generate(String owner, List actions) {
                StringBuffer code = new StringBuffer();
                StringBuffer sb = new StringBuffer();
                Iterator<E> i = actions.iterator();
                while (i.hasNext()) {
                    IAction action = (IAction)i.next();
                    if (action instanceof ITestInvocation) {
                        sb = this.generate(owner, (ITestInvocation)action);
                    } else {
                        if (!(action instanceof ILoop)) continue;
                        sb = this.generate(owner, (ILoop)action);
                    }
                    if (sb == null) {
                        code.append(this.this$0.NL).append("//ERROR: No definition found for test element: ").append(action.getName()).append(this.this$0.NL).append(this.this$0.NL);
                        continue;
                    }
                    if (sb.length() == 0) continue;
                    if (code.length() > 0) {
                        code.append(this.this$0.NL).append(this.this$0.NL);
                    }
                    code.append(sb.toString());
                }
                return code;
            }

            private StringBuffer generate(String owner, ITestInvocation testInvocation) {
                StringBuffer sb = new StringBuffer(owner).append(".addTest(");
                ITest invokedTest = testInvocation.getInvokedTest();
                if (invokedTest == null) {
                    return null;
                }
                if (invokedTest instanceof ITestSuite) {
                    sb.append("((").append(this.hyadesTestSuiteClassName).append(")").append(this.val$helper.getImportedName(invokedTest.getImplementor().getResource())).append(".suite())");
                } else {
                    ITestCase testCase = (ITestCase)invokedTest;
                    String identifier = testCase.getImplementor().getResource();
                    if (identifier == null) {
                        identifier = this.val$helper.retrieveIdentifierName((INamedElement)testCase, (Object)"METHOD");
                    }
                    sb.append("new ").append(this.val$helper.getImportedName(testCase.getOwner().getImplementor().getResource())).append("(\"").append(identifier).append("\")");
                    sb.append(".setId(\"").append(invokedTest.getId()).append("\")");
                }
                sb.append(".setTestInvocationId(\"").append(testInvocation.getId()).append("\")");
                if (!testInvocation.isSynchronous()) {
                    sb.append(".setSynchronous(false)");
                }
                return sb.append(");");
            }

            private StringBuffer generate(String owner, ILoop loop) {
                List actions;
                String identifier = this.val$helper.retrieveIdentifierName((INamedElement)loop, (Object)"METHOD");
                String name = loop.getName();
                name = name == null ? "" : "\"" + name + "\"";
                StringBuffer sb = new StringBuffer(this.hyadesTestSuiteClassName).append(" ").append(identifier);
                sb.append(" = new ").append(this.hyadesTestSuiteClassName).append("(").append(name).append(");").append(this.this$0.NL);
                sb.append(owner).append(".addTest(new ").append(this.val$helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(identifier).append(", ").append(loop.getCondition().getConstraint()).append("));").append(this.this$0.NL);
                sb.append(identifier).append(".setId(\"").append(loop.getId()).append("\")");
                if (!loop.isSynchronous()) {
                    sb.append(".setSynchronous(false)");
                }
                sb.append(";");
                IProperty prop = loop.getActionProperties().getPropertyByName("HTTPPAGE");
                if (prop != null && (actions = loop.getBlock().getActions()).size() >= 1) {
                    ITest test;
                    if (actions.size() == 1 && actions.get(0) instanceof ITestInvocation && (test = ((ITestInvocation)actions.get(0)).getInvokedTest()) != null) {
                        IVariable var = HyadesFactory.INSTANCE.createVariable();
                        var.setInitialValue("PAGE_ONLY");
                        var.setName("pageOrder");
                        test.getVariables().add(var);
                    }
                    int nCount = 0;
                    while (nCount < actions.size()) {
                        ITest itest;
                        E o = actions.get(nCount);
                        if (o instanceof ITestInvocation && (itest = ((ITestInvocation)o).getInvokedTest()) != null) {
                            IVariable var = HyadesFactory.INSTANCE.createVariable();
                            if (nCount == 0) {
                                var.setInitialValue("PAGE_START");
                            } else if (nCount == actions.size() - 1) {
                                var.setInitialValue("PAGE_END");
                            } else {
                                var.setInitialValue("PAGE_MID");
                            }
                            var.setName("pageOrder");
                            itest.getVariables().add(var);
                        }
                        ++nCount;
                    }
                }
                return sb.append(this.this$0.NL).append(this.this$0.NL).append(this.generate(identifier, loop.getBlock().getActions()).toString());
            }
        }
        String code = new InvocationGenerator(this, hyadesTestSuiteClassName, helper).generate(javaElement, testSuite.getImplementor().getBlock().getActions()).toString();
        stringBuffer.append("\t\t");
        stringBuffer.append(hyadesTestSuiteClassName);
        stringBuffer.append(" ");
        stringBuffer.append(javaElement);
        stringBuffer.append(" = new ");
        stringBuffer.append(hyadesTestSuiteClassName);
        stringBuffer.append("(\"");
        stringBuffer.append(TestUIUtil.getLabel((Object)testSuite));
        stringBuffer.append(this.TEXT_19);
        stringBuffer.append(javaElement);
        stringBuffer.append(".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"");
        stringBuffer.append(testSuite.getId());
        stringBuffer.append(this.TEXT_21);
        stringBuffer.append(this.TEXT_22);
        stringBuffer.append(code);
        stringBuffer.append(this.TEXT_23);
        stringBuffer.append(javaElement);
        stringBuffer.append(this.TEXT_24);
        stringBuffer.append(exceptionClassName);
        stringBuffer.append(this.TEXT_25);
        stringBuffer.append(exceptionClassName);
        stringBuffer.append(this.TEXT_26);
        class MethodBodyGenerator {
            int think_time;
            int variance;
            final /* synthetic */ GenTestSuite this$0;
            private final /* synthetic */ Helper val$helper;

            MethodBodyGenerator(GenTestSuite genTestSuite, Helper helper) {
                this.this$0 = genTestSuite;
                this.val$helper = helper;
                this.think_time = Integer.parseInt(HttpPreferenceUtil.getInstance().getDefaultThinkTime());
                this.variance = this.think_time > 0 ? Integer.parseInt(HttpPreferenceUtil.getInstance().getDefaultVariance()) : 0;
            }

            public StringBuffer generate(ITestCase testCase) {
                StringBuffer sb = this.generateHttp(testCase);
                if (sb == null) {
                    sb = this.generateDefault();
                }
                return sb;
            }

            protected StringBuffer generateHttp(ITestCase testCase) {
                RequestHelper requestHelper = new RequestHelper();
                requestHelper.setTestCase(testCase);
                HttpRequest request = requestHelper.createHttpRequest();
                if (request == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append(" request = new ").append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append("();");
                String value = null;
                value = request.getMethod();
                if (value != null) {
                    sb.append(this.this$0.NL).append("request.setMethod(\"").append(this.adjustString(value)).append("\");");
                }
                if (this.think_time > 0) {
                    long thinkTime = request.getThinkTime();
                    if (thinkTime == -1L) {
                        thinkTime = this.think_time;
                    }
                    if (thinkTime > 0L) {
                        sb.append("\n").append("request.setThinkTime( calcThinkTime( ").append(thinkTime).append(",").append(this.variance).append(" ));");
                    }
                }
                if ((value = request.getVersion()) != null) {
                    sb.append(this.this$0.NL).append("request.setVersion(\"").append(this.adjustString(value)).append("\");");
                }
                if ((value = request.getHost()) != null) {
                    sb.append(this.this$0.NL).append("request.setHost(\"").append(this.adjustString(value)).append("\");");
                }
                if (request.getPort() > 0) {
                    sb.append(this.this$0.NL).append("request.setPort(").append(request.getPort()).append(");");
                }
                if ((value = request.getAbsolutePath()) != null) {
                    sb.append(this.this$0.NL).append("request.setAbsolutePath(\"").append(this.adjustString(value)).append("\");");
                }
                if ((value = request.getBody()) != null) {
                    sb.append(this.this$0.NL).append("request.setBody(\"").append(this.adjustString(value)).append("\");");
                }
                if (request.getPageNumber() >= 0) {
                    sb.append(this.this$0.NL).append("request.setPageNumber(").append(request.getPageNumber()).append(");");
                }
                String pageEnum = String.valueOf(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")) + ".PAGE_UNDEFINED";
                IVariable pageOrder = null;
                Iterator<E> it = testCase.getVariables().iterator();
                if (it.hasNext()) {
                    IVariable var = (IVariable)it.next();
                    if (var.getName().equals("pageOrder")) {
                        // empty if block
                    }
                    pageOrder = var;
                }
                if (pageOrder != null) {
                    if (pageOrder.getInitialValue().equals("PAGE_ONLY")) {
                        pageEnum = String.valueOf(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")) + ".PAGE_ONLY";
                    } else if (pageOrder.getInitialValue().equals("PAGE_START")) {
                        pageEnum = String.valueOf(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")) + ".PAGE_START";
                    } else if (pageOrder.getInitialValue().equals("PAGE_MID")) {
                        pageEnum = String.valueOf(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")) + ".PAGE_MID";
                    } else if (pageOrder.getInitialValue().equals("PAGE_END")) {
                        pageEnum = String.valueOf(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")) + ".PAGE_END";
                    }
                }
                sb.append(this.this$0.NL).append("request.setPageOrder(").append(pageEnum).append(");");
                sb.append(this.this$0.NL).append("request.setSecure(").append(request.getSecure()).append(");");
                HttpHeader[] headers = request.getHeaders();
                if (headers.length > 0) {
                    int i = 0;
                    int maxi = headers.length;
                    while (i < maxi) {
                        value = headers[i].getName();
                        if (value != null) {
                            sb.append(this.this$0.NL).append(this.this$0.NL);
                            if (i == 0) {
                                sb.append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append(" header;").append(this.this$0.NL);
                            }
                            sb.append("header = new ").append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append("();");
                            sb.append(this.this$0.NL).append("header.setName(\"").append(this.adjustString(value)).append("\");");
                            value = headers[i].getValue();
                            if (value != null) {
                                sb.append(this.this$0.NL).append("header.setValue(\"").append(this.adjustString(value)).append("\");");
                            }
                            sb.append(this.this$0.NL).append("request.addHeader(header);");
                        }
                        ++i;
                    }
                }
                sb.append(this.this$0.NL);
                sb.append(this.this$0.NL).append("executeRequest(request);");
                return sb;
            }

            protected StringBuffer generateDefault() {
                StringBuffer sb = new StringBuffer();
                sb.append("// Enter your code here");
                return sb;
            }

            protected String adjustString(String string) {
                string = StringUtil.replace((String)string, (String)"\"", (String)"\\\"");
                return string;
            }
        }
        MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator(this, helper);
        Iterator i = testSuite.getITestCases().iterator();
        while (i.hasNext()) {
            ITestCase testCase = (ITestCase)i.next();
            code = methodBodyGenerator.generate(testCase).toString();
            String identifier = testCase.getImplementor().getResource();
            if (identifier == null) {
                identifier = helper.retrieveIdentifierName((INamedElement)testCase, (Object)"METHOD");
            }
            if (identifier == null) continue;
            description = testCase.getDescription();
            description = StringUtil.replace((String)description, (String)this.NL, (String)(String.valueOf(this.NL) + " * "));
            stringBuffer.append(this.TEXT_27);
            stringBuffer.append(TestUIUtil.getLabel((Object)testCase));
            if (description != null) {
                stringBuffer.append(this.TEXT_28);
                stringBuffer.append(description);
                stringBuffer.append(this.TEXT_29);
            }
            stringBuffer.append(this.TEXT_30);
            stringBuffer.append(exceptionClassName);
            stringBuffer.append(this.TEXT_31);
            stringBuffer.append(identifier);
            stringBuffer.append(this.TEXT_32);
            stringBuffer.append(exceptionClassName);
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(code);
            stringBuffer.append(this.TEXT_34);
        }
        stringBuffer.append(this.TEXT_35);
        stringBuffer.append(this.TEXT_36);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_37);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_38);
        stringBuffer.append(helper.getImportedName("java.util.Random"));
        stringBuffer.append(this.TEXT_39);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_40);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest"));
        stringBuffer.append(this.TEXT_41);
        stringBuffer.append(exceptionClassName);
        stringBuffer.append(this.TEXT_42);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
        stringBuffer.append(this.TEXT_43);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpResponse"));
        stringBuffer.append(this.TEXT_44);
        stringBuffer.append(exceptionClassName);
        stringBuffer.append(this.TEXT_45);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
        stringBuffer.append(this.TEXT_46);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_47);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_48);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_49);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_50);
        helper.emitSortedImports();
        return stringBuffer.toString();
    }
}

