/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.importWizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.JavaUtil;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HttpRequestFromXML
implements IDisposable {
    private String testSuiteBaseName;
    private String scriptFile;
    private IPath outputFolder;
    private List resources;
    private RequestHelper requestHelper;
    private int resourceNameIndex;
    private int requestCounter;

    public void dispose() {
        if (this.requestHelper != null) {
            this.requestHelper.dispose();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    public IPath getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(IPath outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getTestSuiteBaseName() {
        return this.testSuiteBaseName;
    }

    public void setTestSuiteBaseName(String testSuiteBaseName) {
        this.testSuiteBaseName = testSuiteBaseName;
    }

    public boolean load() {
        Element element = null;
        try {
            element = XMLUtil.loadDom((InputStream)new FileInputStream(new File(this.scriptFile)), (String)"pageSet");
        }
        catch (FileNotFoundException e) {
            this.openErrorMessage(ToolsUiPlugin.getString("import.error.UnableToParse"), CoreUtil.getStackTrace((Throwable)e));
            return false;
        }
        if (element == null) {
            this.openErrorMessage(ToolsUiPlugin.getString("import.error.UnableToParse"), null);
            return false;
        }
        return this.loadPageSet(element);
    }

    protected boolean loadPageSet(Element pageSet) {
        if ("5.0.0".equals(XMLUtil.getValue((Element)pageSet, (String)"version"))) {
            return this.loadPageSet500(pageSet);
        }
        this.openErrorMessage(ToolsUiPlugin.getString("import.error.UnableToParse"), ToolsUiPlugin.getString("import.error.UnableToParseDetail2"));
        return false;
    }

    protected boolean loadPageSet500(Element pageSet) {
        NodeList pages = XMLUtil.getChildrenByName((Element)pageSet, (String)"page");
        if (pages == null || pages.getLength() == 0) {
            this.openErrorMessage(ToolsUiPlugin.getString("import.error.UnableToParse"), ToolsUiPlugin.getString("import.error.UnableToParseDetail3"));
            return false;
        }
        this.requestHelper = new RequestHelper();
        boolean eachPageIsTestSuite = HttpPreferenceUtil.getInstance().getImportAsSeparate();
        ITestSuite testSuite = null;
        int pageCount = 0;
        int i = 0;
        int max = pages.getLength();
        while (i < max) {
            if (eachPageIsTestSuite || testSuite == null) {
                testSuite = this.createTestSuite();
                pageCount = 1;
            } else {
                ++pageCount;
            }
            this.parsePage(testSuite, (Element)pages.item(i), pageCount);
            ++i;
        }
        this.requestHelper.dispose();
        this.saveResources();
        return true;
    }

    protected void parsePage(ITestSuite testSuite, Element page, int pageCount) {
        NodeList requests = XMLUtil.getChildrenByName((Element)page, (String)"request");
        if (requests != null) {
            ILoop loop = HyadesFactory.INSTANCE.createLoop();
            loop.setName(String.valueOf(ToolsUiPlugin.getString("W_LOOP")) + " " + pageCount);
            loop.getCondition().setConstraint("1");
            testSuite.getImplementor().getBlock().getActions().add(loop);
            int i = 0;
            int max = requests.getLength();
            while (i < max) {
                ITestCase testCase = this.createTestCase(testSuite, loop);
                this.parseRequest((Element)requests.item(i), testCase);
                ++i;
            }
        }
    }

    protected void parseRequest(Element request, ITestCase testCase) {
        this.requestHelper.setTestCase(testCase);
        this.requestHelper.setAttribute(5, XMLUtil.getValue((Element)request, (String)"method"));
        this.requestHelper.setAttribute(1, XMLUtil.getValue((Element)request, (String)"host"));
        this.requestHelper.setAttribute(2, XMLUtil.getValue((Element)request, (String)"port"));
        this.requestHelper.setAttribute(3, XMLUtil.getValue((Element)request, (String)"abs_path"));
        this.requestHelper.setAttribute(4, XMLUtil.getValue((Element)request, (String)"body"));
        this.requestHelper.setAttribute(6, XMLUtil.getValue((Element)request, (String)"version"));
        NodeList headers = XMLUtil.getChildrenByName((Element)request, (String)"header");
        if (headers != null) {
            int i = 0;
            int max = headers.getLength();
            while (i < max) {
                Element header = (Element)headers.item(i);
                this.requestHelper.setHeader(XMLUtil.getValue((Element)header, (String)"name"), XMLUtil.getValue((Element)header, (String)"value"));
                ++i;
            }
        }
    }

    protected void openErrorMessage(String text, String detail) {
        if (detail != null) {
            text = String.valueOf(text) + " \n\n" + detail;
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ToolsUiPlugin.getString("W_ERROR"), (String)text);
    }

    protected ITestSuite createTestSuite() {
        String clsName;
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        IPath file = null;
        do {
            file = this.outputFolder.append(String.valueOf(this.testSuiteBaseName) + ++this.resourceNameIndex).addFileExtension("testsuite");
        } while (ResourcesPlugin.getWorkspace().getRoot().getFile(file).exists());
        URI uri = URI.createPlatformResourceURI((String)file.toString());
        Resource resource = EMFUtil.getResourceFactory((String)"testsuite").createResource(uri);
        this.resources.add(resource);
        ITestSuite testSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        testSuite.setType("org.eclipse.hyades.test.http.junit.testSuite");
        testSuite.setName(String.valueOf(this.testSuiteBaseName) + " " + this.resourceNameIndex);
        if (testSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)testSuite, false);
        }
        if ((clsName = JavaUtil.getValidClassName((String)testSuite.getName(), (boolean)true)) == null) {
            clsName = "Test";
        }
        testSuite.getImplementor().setResource("test." + clsName);
        return testSuite;
    }

    protected ITestCase createTestCase(ITestSuite testSuite, ILoop loop) {
        ITestCase testCase = TestCommonUtil.createTestCase((ITestSuite)testSuite, (String)"org.eclipse.hyades.test.http.junit.testCase", (boolean)false, (String)(String.valueOf(ToolsUiPlugin.getString("W_HTTP_REQUEST").toLowerCase()) + " " + ++this.requestCounter));
        ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation((ITest)testCase);
        loop.getBlock().getActions().add(testInvocation);
        String baseName = ToolsUiPlugin.getString("W_LWR_INV");
        String testName = testCase.getName();
        if (testName == null) {
            testInvocation.setName(TestCommonUtil.getUniqueName((String)baseName, (List)loop.getBlock().getActions()));
        } else {
            testInvocation.setName(TestCorePlugin.getString((String)"NME_CONCAT_SEP", (String[])new String[]{testName, baseName}));
        }
        return testCase;
    }

    protected void saveResources() {
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            try {
                EMFUtil.save((Resource)((Resource)i.next()));
            }
            catch (Exception e) {
                ToolsUiPlugin.logError(e);
            }
        }
    }

    public List getResources() {
        if (this.resources == null) {
            return Collections.EMPTY_LIST;
        }
        return this.resources;
    }
}

