/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class HttpHeaderViewer
implements SelectionListener,
IDisposable {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private Button btnAdd;
    private Button btnRename;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private RequestHelper requestHelper;
    private boolean readOnly;

    public void dispose() {
        this.requestHelper = null;
    }

    public void createControl(Composite parent, WidgetFactory widgetFactory) {
        Composite composite = widgetFactory.createComposite(parent, 0);
        GridData gd = GridDataUtil.createFill();
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        widgetFactory.createLabel(composite, ToolsUiPlugin.getString("Headers_Label"));
        this.createTable(composite, widgetFactory);
    }

    private void createButtons(Composite parent, WidgetFactory widgetFactory) {
        this.btnAdd = widgetFactory.createButton(parent, ToolsUiPlugin.getString("label.Add"), 8);
        this.btnAdd.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnAdd.setEnabled(false);
        this.btnRename = widgetFactory.createButton(parent, ToolsUiPlugin.getString("label.Update"), 8);
        this.btnRename.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRename.setEnabled(false);
        this.btnRemove = widgetFactory.createButton(parent, ToolsUiPlugin.getString("label.Remove"), 8);
        this.btnRemove.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRemove.setEnabled(false);
        this.btnUp = widgetFactory.createButton(parent, ToolsUiPlugin.getString("LBL_UP"), 8);
        GridData data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.btnUp.setLayoutData((Object)data);
        this.btnUp.setEnabled(false);
        this.btnDown = widgetFactory.createButton(parent, ToolsUiPlugin.getString("LBL_DOWN"), 8);
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.btnDown.setLayoutData((Object)data);
        this.btnDown.setEnabled(false);
    }

    private Control createTable(Composite parent, WidgetFactory widgetFactory) {
        Composite composite = widgetFactory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createTableViewer(composite, widgetFactory);
        Composite buttons = widgetFactory.createComposite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data = new GridData(1040);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons, widgetFactory);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnDown.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void createTableViewer(Composite parent, WidgetFactory widgetFactory) {
        Table table = widgetFactory.createTable(parent, 65540);
        this.tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)GridDataUtil.createFill());
        table.computeSize(-1, -1);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn nameColumn = new TableColumn(table, 0x804000);
        nameColumn.setText(ToolsUiPlugin.getString("ENV_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(ToolsUiPlugin.getString("ENV_VALUE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditors[1] = new TextCellEditor((Composite)table);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new HeaderContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HeaderLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        if (!this.isReadOnly() && this.requestHelper != null) {
            int index;
            if (event.widget == this.btnAdd) {
                HeaderDialog dlg = new HeaderDialog(this.btnAdd.getShell(), null);
                if (dlg.open() == 0) {
                    BVRProperty property = dlg.getProperty();
                    this.requestHelper.addHeader((IProperty)property);
                    this.tableViewer.add((Object)property);
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)property));
                }
            } else if (event.widget == this.btnRemove) {
                int index2 = this.tableViewer.getTable().getSelectionIndex();
                if (index2 >= 0) {
                    IProperty property = (IProperty)this.tableViewer.getTable().getItem(index2).getData();
                    this.requestHelper.removeHeader(property);
                    this.tableViewer.getTable().remove(index2);
                    int n = index2 = index2 < this.tableViewer.getTable().getItemCount() ? index2 : this.tableViewer.getTable().getItemCount() - 1;
                    if (index2 >= 0) {
                        this.tableViewer.getTable().select(index2);
                    }
                }
            } else if (event.widget == this.btnRename) {
                Object obj;
                IStructuredSelection structuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
                if (structuredSelection.size() > 0 && (obj = structuredSelection.getFirstElement()) instanceof BVRProperty) {
                    HeaderDialog dlg = new HeaderDialog(this.btnRename.getShell(), (BVRProperty)obj);
                    dlg.open();
                    if (dlg.getReturnCode() == 0) {
                        this.tableViewer.update(obj, null);
                    }
                }
            } else if (event.widget == this.btnUp) {
                int index3 = this.tableViewer.getTable().getSelectionIndex();
                if (index3 > 0) {
                    IProperty property1 = (IProperty)this.tableViewer.getTable().getItem(index3).getData();
                    IProperty property2 = (IProperty)this.tableViewer.getTable().getItem(index3 - 1).getData();
                    this.requestHelper.swapHeaders(property1, property2);
                    this.tableViewer.refresh();
                    this.tableViewer.getTable().select(index3 - 1);
                }
            } else if (event.widget == this.btnDown && (index = this.tableViewer.getTable().getSelectionIndex()) < this.tableViewer.getTable().getItemCount() - 1) {
                IProperty property1 = (IProperty)this.tableViewer.getTable().getItem(index).getData();
                IProperty property2 = (IProperty)this.tableViewer.getTable().getItem(index + 1).getData();
                this.requestHelper.swapHeaders(property1, property2);
                this.tableViewer.refresh();
                this.tableViewer.getTable().select(index + 1);
            }
        }
        this.btnAdd.setEnabled(this.requestHelper != null);
        boolean enable = this.requestHelper != null && !this.tableViewer.getSelection().isEmpty();
        this.btnRemove.setEnabled(enable);
        this.btnRename.setEnabled(enable);
        this.btnUp.setEnabled(enable && this.tableViewer.getTable().getSelectionIndex() > 0);
        this.btnDown.setEnabled(enable && this.tableViewer.getTable().getSelectionIndex() < this.tableViewer.getTable().getItemCount() - 1);
    }

    public void setInput(RequestHelper requestHelper) {
        this.requestHelper = requestHelper;
        this.setEnabled(requestHelper != null);
        this.tableViewer.setInput((Object)requestHelper);
        this.btnAdd.setEnabled(requestHelper != null);
        boolean enable = requestHelper != null && !this.tableViewer.getSelection().isEmpty();
        this.btnDown.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
        this.btnRename.setEnabled(enable);
        this.btnUp.setEnabled(enable);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setEnabled(boolean enabled) {
        this.btnAdd.setEnabled(enabled);
        this.btnDown.setEnabled(enabled);
        this.btnRemove.setEnabled(enabled);
        this.btnRename.setEnabled(enabled);
        this.btnUp.setEnabled(enabled);
    }

    public void clearTable() {
        this.tableViewer.getTable().removeAll();
    }

    protected static class HeaderContentProvider
    implements IStructuredContentProvider {
        protected HeaderContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof RequestHelper) {
                return ((RequestHelper)element).getHeaders();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class HeaderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected HeaderLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BVRProperty) {
                BVRProperty myTableElement = (BVRProperty)element;
                if (columnIndex == 0) {
                    return myTableElement.getName();
                }
                if (columnIndex == 1) {
                    return myTableElement.getValue();
                }
            }
            return "";
        }
    }

    protected static class HeaderDialog
    extends Dialog
    implements Listener {
        private BVRProperty property;
        private HeaderUI propertyUI;

        public HeaderDialog(Shell shell, BVRProperty element) {
            super(shell);
            this.property = element;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(ToolsUiPlugin.getString("Headers_Label"));
            Composite result = new Composite(parent, 0);
            GridData gridData = GridDataUtil.createFill();
            gridData.heightHint = 250;
            gridData.widthHint = 400;
            result.setLayoutData((Object)gridData);
            result.setLayout((Layout)new GridLayout());
            this.propertyUI = new HeaderUI(this.getShell());
            Composite content = this.propertyUI.createControl(result);
            if (this.property != null) {
                this.propertyUI.setName(this.property.getName());
                this.propertyUI.setValue(this.property.getValue());
            }
            return content;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.propertyUI.registerListener(this);
            if (this.property == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.property == null) {
                this.property = Common_Behavior_InteractionsFactory.eINSTANCE.createBVRProperty();
            }
            this.property.setName(this.propertyUI.getName());
            this.property.setValue(this.propertyUI.getValue());
            super.okPressed();
        }

        public BVRProperty getProperty() {
            return this.property;
        }

        public void handleEvent(Event e) {
            this.getButton(0).setEnabled(!this.propertyUI.getName().equals(""));
        }
    }

    protected static class HeaderUI
    implements ModifyListener {
        private CCombo nameCombo;
        private Text valueText;
        private Shell shell;
        private Listener listener;

        public HeaderUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 5;
            content.setLayout((Layout)layout);
            GridData gd = GridDataUtil.createFill();
            gd.horizontalIndent = 5;
            content.setLayoutData((Object)gd);
            Label label = new Label(content, 0);
            label.setText(ToolsUiPlugin.getString("ENV_NAME"));
            this.nameCombo = new CCombo(content, 0x800800);
            this.nameCombo.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            this.nameCombo.setItems(HttpConstants.getAllHeaders());
            this.nameCombo.setFocus();
            this.nameCombo.addModifyListener((ModifyListener)this);
            label = new Label(content, 0);
            label.setText(ToolsUiPlugin.getString("ENV_VALUE"));
            this.valueText = new Text(content, 2882);
            this.valueText.setLayoutData((Object)GridDataUtil.createFill());
            this.valueText.addModifyListener((ModifyListener)this);
            return content;
        }

        public String getValue() {
            return this.valueText.getText().trim();
        }

        public String getName() {
            return this.nameCombo.getText().trim();
        }

        public void modifyText(ModifyEvent e) {
            this.notifyListener();
        }

        public void setValue(String text) {
            if (text != null) {
                this.valueText.setText(text);
            } else {
                this.valueText.setText("");
            }
        }

        public void setName(String text) {
            if (text != null) {
                this.nameCombo.setText(text);
            } else {
                this.nameCombo.setText("");
            }
        }

        public void registerListener(Listener listener) {
            this.listener = listener;
        }

        public void notifyListener() {
            if (this.listener != null) {
                this.listener.handleEvent(null);
            }
        }
    }
}

