/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.http.runner.HttpExecutor;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResponse;
import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpEditorExtension;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpTestCaseDetailPage;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpTestCasesForm;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpTestCasesForm
extends TestCasesForm {
    private StaticDetailPageProvider detailPageProvider;
    static /* synthetic */ Class class$0;

    public HttpTestCasesForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory) {
        super(httpEditorExtension, widgetFactory);
        this.setHeadingText(ToolsUiPlugin.getString("URL_EDT_GENERAL_INFO"));
    }

    protected void createLeftColumn(Composite parent) {
        this.createTestCaseSection(parent);
        this.createNamedElementSection(parent);
    }

    protected void createRightColumn(Composite parent) {
        this.createDetailSection(parent);
    }

    protected IAction getAddTestCaseAction() {
        return new AddTestCase(this, "org.eclipse.hyades.test.http.junit.testCase", ToolsUiPlugin.getString("W_HTTP_REQUEST").toLowerCase()){

            protected void adjusTestCase(ITestCase testCase) {
                RequestHelper requestHelper = new RequestHelper();
                requestHelper.setTestCase(testCase);
                requestHelper.setAttribute(1, HttpPreferenceUtil.getInstance().getDefaultHostName());
                requestHelper.setAttribute(2, HttpPreferenceUtil.getInstance().getDefaultHostPort());
                requestHelper.setAttribute(3, HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
                requestHelper.setAttribute(5, HttpConstants.SUPPORTED_REQUEST_METHODS[0]);
                requestHelper.setAttribute(6, "1.1");
                requestHelper.setAttribute(7, HttpPreferenceUtil.getInstance().getDefaultThinkTime());
            }
        };
    }

    protected String getTestCasesSectionHeaderText() {
        return ToolsUiPlugin.getString("W_REQUESTS");
    }

    protected void registerHelp(int flag, Object object) {
        switch (flag) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void addDetails(StaticDetailPageProvider detailPageProvider) {
        this.detailPageProvider = detailPageProvider;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.models.common.facades.behavioral.ITestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        detailPageProvider.addDetailPage((Class)clazz, (IDetailPage)new HttpTestCaseDetailPage());
    }

    protected void createDetailSection(Composite parent) {
        super.createDetailSection(parent);
        DetailSection detailSection = this.getDetailSection();
        if (detailSection != null && this.detailPageProvider != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.models.common.facades.behavioral.ITestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDetailPage detailPage = this.detailPageProvider.getDetailPage((Object)clazz);
            Composite client = detailSection.getClient();
            if (!(client.getLayout() instanceof GridLayout)) {
                client.setLayout((Layout)new GridLayout());
            }
            Control pageControl = detailPage.createControl(client, (FormWidgetFactory)this.getWidgetFactory(), (IDetailPageContext)detailSection);
            pageControl.setLayoutData((Object)GridDataUtil.createFill());
            this.getDetailSection().addControlWithDetailPage(detailPage, pageControl);
        }
    }

    protected EObjectTreeSection createTestCasesSection() {
        return new EObjectTreeSection(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), this.getAddTestCaseAction()){
            private CheckTestCaseAction checkTestCaseAction;

            protected void createActions() {
                super.createActions();
                this.checkTestCaseAction = new CheckTestCaseAction();
            }

            protected void fillContextMenu(IMenuManager menuManager) {
                super.fillContextMenu(menuManager);
                menuManager.add((IContributionItem)new Separator());
                menuManager.add((IAction)this.checkTestCaseAction);
                this.checkTestCaseAction.setStructuredSelection(this.getStructuredSelection());
            }
        };
    }

    protected static class CheckTestCaseDialog
    extends Dialog
    implements Listener {
        protected HttpRequest request;
        private Text resultText;
        private Cursor cursor;
        private boolean started;

        public CheckTestCaseDialog(HttpRequest request) {
            super(Display.getCurrent().getActiveShell());
            this.request = request;
            this.started = false;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(ToolsUiPlugin.getString("W_TEST"));
            Composite result = new Composite(parent, 0);
            GridData gridData = GridDataUtil.createFill();
            gridData.heightHint = 250;
            gridData.widthHint = 400;
            result.setLayoutData((Object)gridData);
            result.setLayout((Layout)new GridLayout());
            this.resultText = new Text(result, 2818);
            this.resultText.setLayoutData((Object)GridDataUtil.createFill());
            this.resultText.setEditable(false);
            this.getShell().addListener(26, (Listener)this);
            return result;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        }

        public void handleEvent(Event event) {
            this.execute();
        }

        protected void execute() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.cursor = new Cursor((Device)Display.getDefault(), 1);
            this.getShell().setCursor(this.cursor);
            this.resultText.setText(ToolsUiPlugin.getString("test.WaitMessage"));
            Thread thread = new Thread(this, "HyadesHttpRequestTester"){
                final /* synthetic */ CheckTestCaseDialog this$1;
                {
                    this.this$1 = checkTestCaseDialog;
                }

                public void run() {
                    String checkerReturn = null;
                    try {
                        HttpResponse response = new HttpExecutor().execute(this.this$1.request);
                        checkerReturn = ToolsUiPlugin.getString("test.Response", new String[]{String.valueOf(response.getCode()), response.getContentType(), "" + response.getContentLength()});
                        if (response.getDetail() != null) {
                            checkerReturn = String.valueOf(checkerReturn) + "\n\n" + response.getDetail();
                        }
                        if (response.getBody() != null) {
                            checkerReturn = String.valueOf(checkerReturn) + "\n\n" + response.getBody();
                        }
                    }
                    catch (Throwable t) {
                        checkerReturn = String.valueOf(ToolsUiPlugin.getString("test.Exception")) + "\n" + CoreUtil.getStackTrace((Throwable)t);
                    }
                    String cr = checkerReturn;
                    Display.getDefault().asyncExec(new Runnable(this, cr){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ String val$cr;
                        {
                            this.this$2 = var1_1;
                            this.val$cr = string;
                        }

                        public void run() {
                            1.access$0(this.this$2).testFinished(this.val$cr);
                        }
                    });
                }

                static /* synthetic */ CheckTestCaseDialog access$0(1 var0) {
                    return var0.this$1;
                }
            };
            thread.start();
        }

        protected void testFinished(String text) {
            if (this.getShell() == null || this.resultText.isDisposed()) {
                return;
            }
            this.resultText.setText(text);
            this.getButton(1).setText(IDialogConstants.OK_LABEL);
            this.getShell().setCursor(null);
            this.cursor.dispose();
        }
    }

    protected static class CheckTestCaseAction
    extends Action
    implements IDisposable {
        private RequestHelper requestHelper;

        public CheckTestCaseAction() {
            super(ToolsUiPlugin.getString("W_TEST"), TestHttpImages.INSTANCE.getImageDescriptor("http_check.gif"));
        }

        public void dispose() {
            if (this.requestHelper != null) {
                this.requestHelper.dispose();
                this.requestHelper = null;
            }
        }

        public boolean isAvailable() {
            return this.requestHelper != null && this.requestHelper.getTestCase() != null;
        }

        public void setStructuredSelection(IStructuredSelection structuredSelection) {
            Object object;
            if (this.requestHelper != null) {
                this.requestHelper.dispose();
            }
            if (structuredSelection != null && !structuredSelection.isEmpty() && (object = structuredSelection.getFirstElement()) instanceof ITestCase) {
                this.setTestCase((ITestCase)object);
            }
            this.setEnabled(this.isAvailable());
        }

        public void setTestCase(ITestCase testCase) {
            if (this.requestHelper == null) {
                this.requestHelper = new RequestHelper();
            } else {
                this.requestHelper.dispose();
            }
            this.requestHelper.setTestCase(testCase);
        }

        public ITestCase getTestCase() {
            if (this.requestHelper == null) {
                return null;
            }
            return this.requestHelper.getTestCase();
        }

        public void run() {
            if (this.requestHelper == null) {
                return;
            }
            String value = this.requestHelper.getAttribute(1);
            if (value == null) {
                this.openErrorMessage(ToolsUiPlugin.getString("Host_Is_Blank"), null);
                return;
            }
            value = this.requestHelper.getAttribute(3);
            if (value == null || !value.startsWith("/")) {
                this.openErrorMessage(ToolsUiPlugin.getString("Path_Needs_Slash"), null);
                return;
            }
            HttpRequest request = this.requestHelper.createHttpRequest();
            if (request == null) {
                this.openErrorMessage(ToolsUiPlugin.getString("TEST_ERR_MSG"), null);
                return;
            }
            CheckTestCaseDialog dialog = new CheckTestCaseDialog(request);
            dialog.open();
        }

        protected void openErrorMessage(String text, String detail) {
            if (detail != null) {
                text = String.valueOf(text) + " \n\n" + detail;
            }
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ToolsUiPlugin.getString("W_ERROR"), (String)text);
        }
    }
}

