/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;

public class HttpTestSuiteNewWizard
extends TestSuiteNewWizard {
    public HttpTestSuiteNewWizard() {
        this.setWindowTitle(ToolsUiPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
        this.setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor("http_newhsuite_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("HttpTestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("HttpTestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.test.http.junit.testSuite";
    }

    public void addPages() {
        this.getLocationPage().setTitle(ToolsUiPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
        this.getLocationPage().setDescription(ToolsUiPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
        this.getAttributeWizardPage().setTitle(ToolsUiPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
        this.getAttributeWizardPage().setDescription(ToolsUiPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
        super.addPages();
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.adjustSeletion();
        LocationPage locationPage = new LocationPage("location", structuredSelection){

            protected boolean validatePage() {
                IPath path;
                this.setMessage(null);
                if (!super.validatePage()) {
                    return false;
                }
                if (!this.allowOverwrite() && (path = this.getContainerFullPath()) != null) {
                    String name;
                    String fileName = this.getFileName();
                    if (fileName.length() == 0) {
                        this.setErrorMessage(null);
                        return false;
                    }
                    String invalidChar = UIUtil.validateJavaFileName((String)fileName);
                    if (invalidChar != null) {
                        if (Character.isDigit(invalidChar.charAt(0))) {
                            String[] errors = new String[]{UiPlugin.getString((String)"LOGICAL_NAME"), UiPlugin.getString((String)"NUMERIC_VALUE")};
                            this.setErrorMessage(UiPlugin.getString((String)"_ERROR_NAME_EXT", (String[])errors));
                            return false;
                        }
                        String[] errors = new String[]{UiPlugin.getString((String)"LOGICAL_NAME"), invalidChar};
                        this.setErrorMessage(UiPlugin.getString((String)"_ERROR_NAME_SPECIAL_CHAR", (String[])errors));
                        return false;
                    }
                    int lastIndexOfExtension = fileName.lastIndexOf(this.getFileExtension());
                    if (lastIndexOfExtension > 0 && (name = fileName.substring(0, lastIndexOfExtension - 1)).endsWith("." + this.getFileExtension())) {
                        this.setMessage(UiPlugin.getString((String)"_WARNING_FILE_NAME", (String)fileName), 2);
                        return true;
                    }
                }
                return true;
            }
        };
        this.setLocationPage(locationPage);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            locationPage.setFileExtension(fileExtension);
            locationPage.setFileName("");
        }
        this.setAttributeWizardPage(new AttributeWizardPage("nameDescription"));
    }

    protected void registerResource(ITestSuite testSuite) {
        super.registerResource(testSuite);
        TPFTestSuite tpfTestSuite = (TPFTestSuite)testSuite;
        ((CFGInstance)tpfTestSuite.getInstances().get(0)).setMaxCount(1);
    }
}

