/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.preferences;

import java.util.Vector;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class HttpPreferenceUtil {
    private static HttpPreferenceUtil instance;
    private static String MAXSAVEDIMPORTINFILEPREF;
    private static String MAXSAVEDIMPORTTARGETPREF;
    private static String MAXTHREADSPREF;
    private static String IMPORTASSEPARATEPREF;
    private static String SAVEDIMPORTINFILEROOTPREF;
    private static String SAVEDIMPORTTARGETROOTPREF;
    private static String SAVEDIMPORTTARGETBASENAME;
    private static String DEFAULTHOSTNAME;
    private static String DEFAULTHOSTPORT;
    private static String DEFAULTABSOLUTEPATH;
    private static String DEFAULTTHINKTIME;
    private static String DEFAULTVARIANCE;
    private IPreferenceStore preferenceStore = ToolsUiPlugin.getDefault().getPreferenceStore();

    static {
        MAXSAVEDIMPORTINFILEPREF = "MaxSavedImportInfile";
        MAXSAVEDIMPORTTARGETPREF = "MaxSavedImportTarget";
        MAXTHREADSPREF = "MaximumThreadsInGeneratedCode";
        IMPORTASSEPARATEPREF = "ImportAsSeparate";
        SAVEDIMPORTINFILEROOTPREF = "SavedImportInfile";
        SAVEDIMPORTTARGETROOTPREF = "SavedImportTarget";
        SAVEDIMPORTTARGETBASENAME = "SavedImportTCBaseName";
        DEFAULTHOSTNAME = "DefaultHostName";
        DEFAULTHOSTPORT = "DefaultHostPort";
        DEFAULTABSOLUTEPATH = "DefaultAbsolutePath";
        DEFAULTTHINKTIME = "DefaultThinkTime";
        DEFAULTVARIANCE = "DefaultVariance";
    }

    private HttpPreferenceUtil() {
        this.setDefaultValues();
    }

    public static HttpPreferenceUtil getInstance() {
        if (instance == null) {
            instance = new HttpPreferenceUtil();
        }
        return instance;
    }

    private void setDefaultValues() {
        this.preferenceStore.setDefault(MAXTHREADSPREF, 10);
        this.preferenceStore.setDefault(MAXSAVEDIMPORTINFILEPREF, 5);
        this.preferenceStore.setDefault(MAXSAVEDIMPORTTARGETPREF, 5);
        this.preferenceStore.setDefault(DEFAULTHOSTNAME, "");
        this.preferenceStore.setDefault(DEFAULTHOSTPORT, "80");
        this.preferenceStore.setDefault(DEFAULTABSOLUTEPATH, "/");
        this.preferenceStore.setDefault(DEFAULTTHINKTIME, 200L);
        this.preferenceStore.setDefault(DEFAULTVARIANCE, "10");
        this.preferenceStore.setDefault(IMPORTASSEPARATEPREF, false);
        this.preferenceStore.setDefault(SAVEDIMPORTTARGETBASENAME, ToolsUiPlugin.getString("preference.TestcaseBaseName"));
    }

    public int getMaxThreads() {
        return this.getMaxThreads(false);
    }

    public int getMaxThreads(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultInt(MAXTHREADSPREF);
        }
        return this.preferenceStore.getInt(MAXTHREADSPREF);
    }

    public void setMaxThreads(int newValue) {
        this.preferenceStore.setValue(MAXTHREADSPREF, newValue);
    }

    public String getImportTestcaseBaseName() {
        return this.getImportTestcaseBaseName(false);
    }

    public String getImportTestcaseBaseName(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(SAVEDIMPORTTARGETBASENAME);
        }
        return this.preferenceStore.getString(SAVEDIMPORTTARGETBASENAME);
    }

    public void setImportTestcaseBaseName(String newValue) {
        this.preferenceStore.setValue(SAVEDIMPORTTARGETBASENAME, newValue);
    }

    public boolean getImportAsSeparate() {
        return this.getImportAsSeparate(false);
    }

    public boolean getImportAsSeparate(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultBoolean(IMPORTASSEPARATEPREF);
        }
        return this.preferenceStore.getBoolean(IMPORTASSEPARATEPREF);
    }

    public void setImportAsSeparate(boolean newValue) {
        this.preferenceStore.setValue(IMPORTASSEPARATEPREF, newValue);
    }

    public int getSavedInfileHistorySize() {
        return this.getSavedInfileHistorySize(false);
    }

    public int getSavedInfileHistorySize(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultInt(MAXSAVEDIMPORTINFILEPREF);
        }
        return this.preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
    }

    public void setSavedInfileHistorySize(int newValue) {
        this.preferenceStore.setValue(MAXSAVEDIMPORTINFILEPREF, newValue);
    }

    public String[] getInfileHistory() {
        int maxEntries = this.getSavedInfileHistorySize();
        Vector<String> V = new Vector<String>();
        int i = 1;
        while (i <= maxEntries) {
            String tempString = this.preferenceStore.getString(String.valueOf(SAVEDIMPORTINFILEROOTPREF) + "." + i);
            if (tempString != null && !tempString.equals("")) {
                V.addElement(tempString);
            }
            ++i;
        }
        String[] res = new String[V.size()];
        i = 0;
        while (i < res.length) {
            res[i] = (String)V.elementAt(i);
            ++i;
        }
        return res;
    }

    public void addToInfileHistory(String fileName) {
        int numEntries;
        String[] tempHistory = this.getInfileHistory();
        int y = 0;
        while (y < tempHistory.length) {
            if (tempHistory[y].equals(fileName)) {
                return;
            }
            ++y;
        }
        int maxEntries = this.preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
        if (maxEntries < 1) {
            maxEntries = this.getSavedInfileHistorySize(true);
        }
        if ((numEntries = tempHistory.length) < maxEntries) {
            this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTINFILEROOTPREF) + "." + (numEntries + 1), fileName);
        } else {
            int offsetAdjust = numEntries - maxEntries;
            int t = 1;
            while (t < maxEntries) {
                this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTINFILEROOTPREF) + "." + t, tempHistory[t + offsetAdjust]);
                ++t;
            }
            this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTINFILEROOTPREF) + "." + maxEntries, fileName);
        }
    }

    public int getSavedTargetHistorySize() {
        return this.getSavedTargetHistorySize(false);
    }

    public int getSavedTargetHistorySize(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultInt(MAXSAVEDIMPORTTARGETPREF);
        }
        return this.preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
    }

    public void setSavedTargetHistorySize(int newValue) {
        this.preferenceStore.setValue(MAXSAVEDIMPORTTARGETPREF, newValue);
    }

    public String[] getTargetHistory() {
        int maxEntries = this.getSavedTargetHistorySize();
        Vector<String> V = new Vector<String>();
        int i = 1;
        while (i <= maxEntries) {
            String tempString = this.preferenceStore.getString(String.valueOf(SAVEDIMPORTTARGETROOTPREF) + "." + i);
            if (tempString != null && !tempString.equals("")) {
                V.addElement(tempString);
            }
            ++i;
        }
        String[] res = new String[V.size()];
        i = 0;
        while (i < res.length) {
            res[i] = (String)V.elementAt(i);
            ++i;
        }
        return res;
    }

    public void addToTargetHistory(String fileName) {
        int numEntries;
        String[] tempHistory = this.getTargetHistory();
        int y = 0;
        while (y < tempHistory.length) {
            if (tempHistory[y].equals(fileName)) {
                return;
            }
            ++y;
        }
        int maxEntries = this.preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
        if (maxEntries < 1) {
            maxEntries = this.getSavedTargetHistorySize(true);
        }
        if ((numEntries = tempHistory.length) < maxEntries) {
            this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTTARGETROOTPREF) + "." + (numEntries + 1), fileName);
        } else {
            int offsetAdjust = numEntries - maxEntries;
            int t = 1;
            while (t < maxEntries) {
                this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTTARGETROOTPREF) + "." + t, tempHistory[t + offsetAdjust]);
                ++t;
            }
            this.preferenceStore.setValue(String.valueOf(SAVEDIMPORTTARGETROOTPREF) + "." + maxEntries, fileName);
        }
    }

    public String getDefaultHostName() {
        return this.getDefaultHostName(false);
    }

    public String getDefaultHostName(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTNAME);
        }
        return this.preferenceStore.getString(DEFAULTHOSTNAME);
    }

    public void setDefaultHostName(String value) {
        this.preferenceStore.setValue(DEFAULTHOSTNAME, value);
    }

    public String getDefaultHostPort() {
        return this.getDefaultHostPort(false);
    }

    public String getDefaultHostPort(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTPORT);
        }
        return this.preferenceStore.getString(DEFAULTHOSTPORT);
    }

    public void setDefaultHostPort(String value) {
        this.preferenceStore.setValue(DEFAULTHOSTPORT, value);
    }

    public String getDefaultThinkTime() {
        return this.getDefaultThinkTime(false);
    }

    public String getDefaultThinkTime(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTTHINKTIME);
        }
        return this.preferenceStore.getString(DEFAULTTHINKTIME);
    }

    public void setDefaultThinkTime(String value) {
        this.preferenceStore.setValue(DEFAULTTHINKTIME, value);
    }

    public String getDefaultVariance() {
        return this.getDefaultVariance(false);
    }

    public String getDefaultVariance(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTVARIANCE);
        }
        return this.preferenceStore.getString(DEFAULTVARIANCE);
    }

    public void setDefaultVariance(String value) {
        this.preferenceStore.setValue(DEFAULTVARIANCE, value);
    }

    public String getDefaultAbsolutePath() {
        return this.getDefaultAbsolutePath(false);
    }

    public String getDefaultAbsolutePath(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTABSOLUTEPATH);
        }
        return this.preferenceStore.getString(DEFAULTABSOLUTEPATH);
    }

    public void setDefaultAbsolutePath(String value) {
        this.preferenceStore.setValue(DEFAULTABSOLUTEPATH, value);
    }
}

