/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.http.internal.launch.HttpTestLaunchConfigurationFacade;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LoadTestUserTab
extends AbstractLaunchConfigurationTab {
    private String title = ToolsUiPlugin.getString("LoadTestUserTab.Title");
    private Text _numUsers = null;
    private Listener modifyListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.widget == LoadTestUserTab.this._numUsers) {
                LoadTestUserTab.this.updateLaunchConfigurationDialog();
            }
        }
    };

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.horizontalSpacing = 25;
        gl.verticalSpacing = 25;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label users = new Label(composite, 0);
        users.setText(ToolsUiPlugin.getString("LoadTestUserTab.Users"));
        this._numUsers = new Text(composite, 2048);
        this._numUsers.addListener(24, this.modifyListener);
        this._numUsers.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        HttpTestLaunchConfigurationFacade.setNumberOfUsers(configuration, 1);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int n = HttpTestLaunchConfigurationFacade.getNumberOfUsers(configuration);
            String text = n == -1 ? "" : Integer.toString(n);
            if (this._numUsers != null) {
                this._numUsers.removeListener(24, this.modifyListener);
                this._numUsers.setText(text);
                this._numUsers.addListener(24, this.modifyListener);
            }
        }
        catch (CoreException e) {
            ToolsUiPlugin.logError(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        HttpTestLaunchConfigurationFacade.setNumberOfUsers(configuration, this.get_nUsers());
    }

    public String getName() {
        return this.title;
    }

    public int get_nUsers() {
        try {
            int n = Integer.parseInt(this._numUsers.getText());
            if (n > 0) {
                return n;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void set_nUsers(int users) {
    }

    public Image getImage() {
        return TestHttpImages.INSTANCE.getImage("http_request.gif");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.get_nUsers() < 1) {
            this.setErrorMessage(ToolsUiPlugin.getString("LoadTestUserTab.InvalidUsers"));
            return false;
        }
        return true;
    }
}

