/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.fragments.impl.Common_Behavior_FragmentsFactoryImpl;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitEditorExtension;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SourceInfoViewer
implements ModifyListener,
SelectionListener {
    private static final String ADVANCED_MODE_SYSTEM_PROPERTY = "TPTP_TESTTOOLS_JUNIT_ADVANCED_EDITOR";
    private StyledText sourceFolderText;
    private StyledText packageText;
    private StyledText classNameText;
    private Button sourceFolderButton;
    private Button packageButton;
    private Button updateFromCodeButton;
    private IImplementor implementor;
    private VerifyKeyListener verifyKeyListener;
    private Button externalBehavior;
    private EditorForm editorForm;
    private IBlock preservedBlock;
    private boolean showExternalBehavior;
    private boolean advanced = System.getProperty("TPTP_TESTTOOLS_JUNIT_ADVANCED_EDITOR") != null;

    public SourceInfoViewer(EditorForm editorForm) {
        this.editorForm = editorForm;
        this.showExternalBehavior = editorForm.getBaseEditorExtension() instanceof JUnitEditorExtension;
    }

    public SourceInfoViewer() {
    }

    public void dispose() {
        this.implementor = null;
        this.preservedBlock = null;
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected IImplementor getImplementor() {
        return this.implementor;
    }

    public Composite createClient(Composite parent, VerifyKeyListener verifyKeyListener, WidgetFactory widgetFactory) {
        Label label;
        this.verifyKeyListener = verifyKeyListener;
        Composite composite = null;
        composite = widgetFactory != null ? widgetFactory.createComposite(parent) : new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)GridDataUtil.createFill());
        if (this.showExternalBehavior) {
            if (widgetFactory != null) {
                this.externalBehavior = widgetFactory.createButton(composite, ToolsUiPlugin.getString("STR_TBC_CHECK"), 32);
            } else {
                this.externalBehavior = new Button(composite, 32);
                this.externalBehavior.setText(ToolsUiPlugin.getString("STR_TBC_CHECK"));
            }
            this.externalBehavior.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPlugin.getString("STR_WB_SRCFOLD"));
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPlugin.getString("STR_WB_SRCFOLD"));
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.sourceFolderText = widgetFactory != null ? widgetFactory.createStyledText(composite, 65540, ToolsUiPlugin.getString("STR_WB_SRCFOLD")) : new StyledText(composite, 67588);
        this.sourceFolderText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.sourceFolderText.setEditable(false);
        if (widgetFactory != null) {
            this.sourceFolderButton = widgetFactory.createButton(composite, ToolsUiPlugin.getString("STR_WB_SRCFOLD_BTN"), 8);
        } else {
            this.sourceFolderButton = new Button(composite, 8);
            this.sourceFolderButton.setText(ToolsUiPlugin.getString("STR_WB_SRCFOLD_BTN"));
        }
        this.sourceFolderButton.setLayoutData((Object)new GridData(128));
        this.sourceFolderButton.addSelectionListener((SelectionListener)this);
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPlugin.getString("STR_WB_PACK"));
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPlugin.getString("STR_WB_PACK"));
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.packageText = widgetFactory != null ? widgetFactory.createStyledText(composite, 65540, ToolsUiPlugin.getString("STR_WB_PACK")) : new StyledText(composite, 67588);
        this.packageText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.packageText.setEditable(false);
        if (widgetFactory != null) {
            this.packageButton = widgetFactory.createButton(composite, ToolsUiPlugin.getString("STR_WB_PACK_BTN"), 8);
        } else {
            this.packageButton = new Button(composite, 8);
            this.packageButton.setText(ToolsUiPlugin.getString("STR_WB_PACK_BTN"));
        }
        this.packageButton.setLayoutData((Object)new GridData(128));
        this.packageButton.addSelectionListener((SelectionListener)this);
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPlugin.getString("STR_WB_CLASS"));
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPlugin.getString("STR_WB_CLASS"));
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.classNameText = widgetFactory != null ? widgetFactory.createStyledText(composite, 65540, ToolsUiPlugin.getString("STR_WB_CLASS")) : new StyledText(composite, 67588);
        this.classNameText.setEditable(false);
        this.classNameText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        if (this.advanced && this.showExternalBehavior) {
            this.updateFromCodeButton = widgetFactory.createButton(composite, "Refresh test methods from code", 8);
            this.updateFromCodeButton.setLayoutData((Object)new GridData(0x1000008, 1, false, false, 2, 1));
            this.updateFromCodeButton.addSelectionListener((SelectionListener)this);
        }
        if (widgetFactory != null) {
            widgetFactory.paintBordersFor(composite);
        }
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.implementor = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof ITest) {
            object = ((ITest)object).getImplementor();
        }
        if (object != null && object instanceof IImplementor) {
            this.implementor = (IImplementor)object;
            this.adjustTexts();
            this.sourceFolderText.setEditable(true);
            this.packageText.setEditable(true);
            this.classNameText.setEditable(true);
        } else {
            this.sourceFolderText.setText("");
            this.packageText.setText("");
            this.classNameText.setText("");
            this.sourceFolderText.setEditable(false);
            this.packageText.setEditable(false);
            this.classNameText.setEditable(false);
        }
    }

    protected void adjustTexts() {
        String sourceFolderName;
        if (this.verifyKeyListener != null) {
            this.sourceFolderText.removeVerifyKeyListener(this.verifyKeyListener);
            this.packageText.removeVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.removeVerifyKeyListener(this.verifyKeyListener);
        }
        this.sourceFolderText.removeModifyListener((ModifyListener)this);
        this.packageText.removeModifyListener((ModifyListener)this);
        this.classNameText.removeModifyListener((ModifyListener)this);
        if (this.externalBehavior != null) {
            this.externalBehavior.removeSelectionListener((SelectionListener)this);
        }
        if ((sourceFolderName = this.getImplementor().getLocation()) == null) {
            sourceFolderName = "";
        }
        String className = "";
        String packageName = "";
        String value = this.getImplementor().getResource();
        if (value != null) {
            int index = value.lastIndexOf(46);
            if (index >= 0) {
                packageName = value.substring(0, index);
            } else {
                index = -1;
            }
            if (index != value.length() - 1) {
                className = value.substring(index + 1);
            }
        }
        boolean isExternal = this.getImplementor().isExternalImplementor();
        this.sourceFolderText.setText(sourceFolderName);
        this.packageText.setText(packageName);
        this.classNameText.setText(className);
        if (this.externalBehavior != null) {
            this.externalBehavior.setSelection(isExternal);
        }
        if (this.verifyKeyListener != null) {
            this.sourceFolderText.addVerifyKeyListener(this.verifyKeyListener);
            this.packageText.addVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.addVerifyKeyListener(this.verifyKeyListener);
        }
        this.sourceFolderText.addModifyListener((ModifyListener)this);
        this.packageText.addModifyListener((ModifyListener)this);
        this.classNameText.addModifyListener((ModifyListener)this);
        if (this.externalBehavior != null) {
            this.externalBehavior.addSelectionListener((SelectionListener)this);
        }
    }

    public Object getInput() {
        return this.implementor;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getImplementor() == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.getImplementor());
    }

    public void selectReveal(ISelection selection) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.sourceFolderText) {
            String srcFolder = this.getSourceFolder();
            this.getImplementor().setLocation(srcFolder);
        } else if (e.widget == this.classNameText || e.widget == this.packageText) {
            String pack = this.getPackage();
            String cls = this.getClassName();
            if (pack.length() > 0 && cls.length() > 0) {
                this.getImplementor().setResource(String.valueOf(pack) + "." + cls);
            } else {
                this.getImplementor().setResource(String.valueOf(pack) + cls);
            }
            this.markDirty();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isReadOnly()) {
            e.doit = false;
        } else if (e.widget == this.sourceFolderButton) {
            ElementTreeSelectionDialog dialog = TestJavaUtil.createSourceFolderDialog(this.sourceFolderButton.getShell(), null);
            dialog.setTitle(ToolsUiPlugin.getString("TITLE_SRC_SELECT"));
            dialog.setMessage(ToolsUiPlugin.getString("STR_SRC_SELECT"));
            dialog.setEmptyListMessage(ToolsUiPlugin.getString("NO_SRC"));
            if (dialog.open() == 0) {
                Object result = dialog.getFirstResult();
                String text = "";
                if (result != null && (result instanceof IJavaProject || result instanceof IPackageFragmentRoot)) {
                    try {
                        text = ((IJavaElement)result).getCorrespondingResource().getFullPath().toString();
                    }
                    catch (JavaModelException e1) {
                        ToolsUiPlugin.logError(e1);
                    }
                }
                this.sourceFolderText.setText(text);
                this.markDirty();
            }
        } else if (e.widget == this.packageButton) {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getImplementor().getLocation());
            if (res == null) {
                e.doit = false;
            } else {
                IJavaElement element = JavaCore.create((IResource)res);
                try {
                    IPackageFragmentRoot srcFolder = null;
                    String initialPackageName = this.packageText.getText();
                    if (element instanceof IJavaProject) {
                        srcFolder = ((IJavaProject)element).findPackageFragmentRoot(res.getFullPath());
                    } else if (element instanceof IPackageFragmentRoot) {
                        srcFolder = (IPackageFragmentRoot)element;
                    }
                    if (srcFolder != null) {
                        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this.packageButton.getShell(), (IPackageFragmentRoot)srcFolder);
                        IPackageFragment initialPackage = null;
                        if (initialPackageName != null) {
                            initialPackage = srcFolder.getPackageFragment(initialPackageName);
                        }
                        if (initialPackage != null && initialPackage.exists()) {
                            dialog.setInitialSelections(new Object[]{initialPackage});
                        }
                        dialog.setTitle(ToolsUiPlugin.getString("TITLE_PACK_SELECT"));
                        dialog.setMessage(ToolsUiPlugin.getString("STR_PACK_SELECT"));
                        if (dialog.open() == 0) {
                            IPackageFragment packageFragment = (IPackageFragment)dialog.getResult()[0];
                            this.packageText.setText(packageFragment.getElementName());
                            this.markDirty();
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    e.doit = false;
                }
            }
        } else if (e.widget == this.externalBehavior) {
            if (this.externalBehavior.getSelection()) {
                this.preservedBlock = this.getImplementor().getBlock();
                JUnitModelUpdater.setImplementorBlock((IImplementor)this.implementor, null);
            } else if (this.preservedBlock != null) {
                JUnitModelUpdater.setImplementorBlock((IImplementor)this.getImplementor(), (IBlock)this.preservedBlock);
            } else {
                SourceInfoViewer.createBlock(this.getImplementor());
            }
            if (this.editorForm != null) {
                ((JUnitEditorExtension)this.editorForm.getBaseEditorExtension()).setBehaviorFormState(!this.externalBehavior.getSelection());
            }
            this.markDirty();
        } else if (e.widget == this.updateFromCodeButton) {
            try {
                if (JUnitModelUpdater.updateTestSuiteFromCode((ITestSuite)((ITestSuite)this.getImplementor().getOwner()))) {
                    this.markDirty();
                }
            }
            catch (CoreException e1) {
                CorePlugin.logError((Throwable)e1);
            }
        }
    }

    static IBlock createBlock(IImplementor implementor) {
        if (!(implementor instanceof TPFBehavior)) {
            return null;
        }
        TPFBehavior testBehavior = (TPFBehavior)implementor;
        TPFTest test = testBehavior.getTest();
        if (!(test instanceof CFGClass)) {
            return null;
        }
        CFGClass theClass = (CFGClass)test;
        String implementedTestName = test.getName();
        if (implementedTestName == null) {
            implementedTestName = "";
        }
        CFGInstanceImpl instance = null;
        Iterator iter = theClass.getInstances().iterator();
        while (iter.hasNext()) {
            CFGInstanceImpl tempInstance = (CFGInstanceImpl)iter.next();
            if (!theClass.equals(tempInstance.getClassType())) continue;
            instance = tempInstance;
            break;
        }
        if (instance == null) {
            instance = (CFGInstanceImpl)Common_ConfigurationFactoryImpl.eINSTANCE.createCFGInstance();
            instance.setClassType(theClass);
            theClass.getInstances().add((Object)instance);
        }
        BVRLifelineImpl selfLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
        selfLifeline.setName(String.valueOf(implementedTestName) + "_selfLifeline");
        BVRInteractionImpl testInteraction = (BVRInteractionImpl)Common_Behavior_FragmentsFactoryImpl.eINSTANCE.createBVRInteraction();
        testInteraction.setName(String.valueOf(implementedTestName) + "_interaction");
        testBehavior.setInteraction((BVRInteraction)testInteraction);
        testInteraction.getLifelines().add((Object)selfLifeline);
        instance.setLifeline((BVRLifeline)selfLifeline);
        return testInteraction;
    }

    public String getSourceFolder() {
        return this.sourceFolderText.getText().trim();
    }

    public String getPackage() {
        return this.packageText.getText().trim();
    }

    public String getClassName() {
        return this.classNameText.getText().trim();
    }

    public void setInitialFocus() {
        if (this.packageText != null) {
            this.packageText.setFocus();
        }
    }

    protected void markDirty() {
        if (this.editorForm != null) {
            this.editorForm.getBaseEditorExtension().markDirty();
        }
    }
}

