/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JUnitTypeProviderProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.jdt.core.JavaCore;

public class JUnitTypeProvider
implements ITypeProvider,
IResourceChangeListener {
    private IFileProxyManager fileProxyManager;
    private IProxyNodeListener refresher;
    private Map projectToProxyMap = new HashMap();

    public JUnitTypeProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public ITypeProviderProxyNode get(IProject project, String type) {
        if (!JavaCore.create((IProject)project).exists()) {
            return null;
        }
        if (this.projectToProxyMap.containsKey(project)) {
            return (JUnitTypeProviderProxyNode)this.projectToProxyMap.get(project);
        }
        JUnitTypeProviderProxyNode node = JUnitTypeProviderProxyNode.create(project, type, this.fileProxyManager, project);
        if (node != null) {
            this.projectToProxyMap.put(project, node);
        }
        return node;
    }

    public void init(ITypeProviderContext context) {
        this.fileProxyManager = context.getFileProxyManager();
        this.refresher = context.getProxyNodeListener();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] affectedChildren = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            IProxyNode lowestChange;
            IProject project = (IProject)affectedChildren[i].getResource();
            IResourceChangeListenerProxyNode node = (IResourceChangeListenerProxyNode)this.projectToProxyMap.get(project);
            if (node != null && (lowestChange = node.resourceChanged(affectedChildren[i])) != null) {
                this.refresher.nodeChanged((Object)lowestChange);
            }
            ++i;
        }
    }
}

