/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Generator;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.AdjustSourceInfoPage;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.ProjectAndSourcePage;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class GenerateWizard
extends HyadesWizard
implements IRunnableWithProgress {
    public static final String PLUGIN_ID_JUNIT = "org.junit";
    public static final String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core";
    public static final String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote";
    private ITestSuite testSuite;
    private AdjustSourceInfoPage adjustSourceInfoPage;
    private ProjectAndSourcePage projectAndSourcePage;
    private Generator generator;

    public GenerateWizard() {
        this.setWindowTitle(ToolsUiPlugin.getString("JAVA_GEN_WTITLE"));
        this.setDefaultPageImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("generate_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("junit.GenerateWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("junit.GenerateWizard");
        }
        this.setDialogSettings(settings);
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.getSelection();
        if (structuredSelection.size() == 1) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof ITestSuite) {
                this.testSuite = (ITestSuite)selection;
            } else if (selection instanceof ITestSuiteProxyNode) {
                ITestSuiteProxyNode tsProxy = (ITestSuiteProxyNode)selection;
                this.testSuite = tsProxy.getTestSuite();
            }
        }
        IImplementor implementor = this.getTestSuite().getImplementor();
        this.generator = this.createGenerator();
        if (this.generator.validate(this.testSuite).getSeverity() == 0) {
            IJavaProject[] javaProjects = TestJavaUtil.getJavaProjects();
            this.projectAndSourcePage = new ProjectAndSourcePage(implementor, javaProjects);
        } else {
            this.adjustSourceInfoPage = new AdjustSourceInfoPage(implementor);
        }
    }

    public void addPages() {
        if (this.adjustSourceInfoPage != null) {
            this.addPage((IWizardPage)this.adjustSourceInfoPage);
        } else if (this.projectAndSourcePage != null) {
            this.addPage((IWizardPage)this.projectAndSourcePage);
        }
    }

    public void run(IProgressMonitor mon) throws InterruptedException, InvocationTargetException {
        if (this.projectAndSourcePage != null) {
            this.getDialogSettings().put("PROJECT_NAME", this.getJavaProject().getElementName());
            this.getDialogSettings().put("SOURCE_FOLDER_NAME", this.getSourceFolder());
        }
        if (this.getTestSuite() != null) {
            MessageDialog dialog;
            Generator generator;
            Resource resource = ((EObject)this.getTestSuite()).eResource();
            boolean isTrackingModification = resource.isTrackingModification();
            resource.setTrackingModification(true);
            if (this.projectAndSourcePage != null) {
                String sLocation;
                IProject location = this.getJavaProject().getProject();
                if (this.getSourceFolder() != null && this.getSourceFolder().length() > 0) {
                    location = location.getFolder((IPath)new Path(this.getSourceFolder()));
                }
                if (!(sLocation = location.getFullPath().toString()).equals(this.getTestSuite().getImplementor().getLocation())) {
                    this.getTestSuite().getImplementor().setLocation(sLocation);
                }
            } else {
                resource.setModified(this.adjustSourceInfoPage != null);
            }
            if ((generator = this.createGenerator()).getFileHandle(this.getTestSuite()).exists() && (dialog = new MessageDialog(this.getShell(), ToolsUiPlugin.getString("W_QUESTION"), null, ToolsUiPlugin.getString("Q_OVR_FILE"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                mon.setCanceled(true);
                throw new InterruptedException();
            }
            this.addRequiredLibraries(generator);
            try {
                generator.generate(this.getTestSuite(), mon);
            }
            catch (Exception e) {
                ToolsUiPlugin.logError(e);
                throw new InvocationTargetException(e);
            }
            if (resource.isModified()) {
                try {
                    EMFUtil.save((Resource)resource);
                }
                catch (Exception e) {
                    ToolsUiPlugin.logError(e);
                }
            }
            resource.setTrackingModification(isTrackingModification);
        }
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ToolsUiPlugin.getString("W_ERROR"), (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public IJavaProject getJavaProject() {
        return this.projectAndSourcePage.getJavaProject();
    }

    public String getSourceFolder() {
        return this.projectAndSourcePage.getSourceFolder();
    }

    protected Generator createGenerator() {
        return new JUnitGenerator();
    }

    protected void addRequiredLibraries(Generator generator) {
        JUnitGenerator junitGenerator = (JUnitGenerator)generator;
        junitGenerator.addAllLibraries(PLUGIN_ID_JUNIT);
        junitGenerator.addRequiredLibrary(CorePlugin.getID(), "common.runner.jar");
        junitGenerator.addRequiredLibrary(CorePlugin.getID(), "java.runner.jar");
    }
}

