/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.SourcePage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class JUnitTestSuiteNewWizard
extends TestSuiteNewWizard {
    private SourcePage sourcePage;
    private ITestSuite generatedTestSuite;

    public JUnitTestSuiteNewWizard() {
        this.setWindowTitle(ToolsUiPlugin.getString("WIZ_JUNIT_TST_SUITE_TTL"));
        this.setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor("java_newjunit_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("JUnitTestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("JUnitTestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.test.java.junit.testSuite";
    }

    public void addPages() {
        this.sourcePage.setTitle(ToolsUiPlugin.getString("JUnitTestSuiteNewWizard.sourcePageTitle"));
        this.addPage((IWizardPage)this.sourcePage);
        this.getLocationPage().setTitle(ToolsUiPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
        this.getLocationPage().setDescription(ToolsUiPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
        this.getAttributeWizardPage().setTitle(ToolsUiPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
        this.getAttributeWizardPage().setDescription(ToolsUiPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_ATT_DSC"));
        super.addPages();
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.adjustSeletion();
        this.initLocationPage(structuredSelection);
        this.initSourcePage(structuredSelection, this.getLocationPage());
        this.setAttributeWizardPage(new AttributeWizardPage("nameDescription"));
    }

    protected void initLocationPage(IStructuredSelection structuredSelection) {
        LocationPage locationPage = new LocationPage("location", structuredSelection){

            protected boolean validatePage() {
                IPath path;
                this.setMessage(null);
                if (!super.validatePage()) {
                    return false;
                }
                if (!this.allowOverwrite() && (path = this.getContainerFullPath()) != null) {
                    String name;
                    String fileName = this.getFileName();
                    if (fileName.length() == 0) {
                        this.setErrorMessage(null);
                        return false;
                    }
                    String invalidChar = UIUtil.validateJavaFileName((String)fileName);
                    if (invalidChar != null) {
                        if (Character.isDigit(invalidChar.charAt(0))) {
                            String[] errors = new String[]{UiPlugin.getString((String)"LOGICAL_NAME"), UiPlugin.getString((String)"NUMERIC_VALUE")};
                            this.setErrorMessage(UiPlugin.getString((String)"_ERROR_NAME_EXT", (String[])errors));
                            return false;
                        }
                        String[] errors = new String[]{UiPlugin.getString((String)"LOGICAL_NAME"), invalidChar};
                        this.setErrorMessage(UiPlugin.getString((String)"_ERROR_NAME_SPECIAL_CHAR", (String[])errors));
                        return false;
                    }
                    int lastIndexOfExtension = fileName.lastIndexOf(this.getFileExtension());
                    if (lastIndexOfExtension > 0 && (name = fileName.substring(0, lastIndexOfExtension - 1)).endsWith("." + this.getFileExtension())) {
                        this.setMessage(UiPlugin.getString((String)"_WARNING_FILE_NAME", (String)fileName), 2);
                        return true;
                    }
                }
                return true;
            }
        };
        this.setLocationPage(locationPage);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            locationPage.setFileExtension(fileExtension);
            locationPage.setFileName("");
        }
    }

    protected void initSourcePage(IStructuredSelection structuredSelection, LocationPage locationPage) {
        SourcePage sourcePage_ = new SourcePage();
        this.setSourcePage(sourcePage_);
        sourcePage_.setWizard((IWizard)this);
        sourcePage_.init(structuredSelection, locationPage);
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            if (this.generatedTestSuite != null) {
                try {
                    this.generateCode(this.generatedTestSuite, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    ToolsUiPlugin.logError(e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void registerResource(ITestSuite testSuite) {
        IResource resource;
        String qualifiedName = this.sourcePage.getQualifiedTypeName();
        testSuite.getImplementor().setResource(qualifiedName);
        try {
            resource = this.sourcePage.getPackageFragmentRoot().getCorrespondingResource();
        }
        catch (JavaModelException e) {
            resource = null;
            ToolsUiPlugin.logError(e);
        }
        if (resource != null) {
            testSuite.getImplementor().setLocation(resource.getFullPath().toString());
        }
        if (!this.sourcePage.isModelBehavior()) {
            JUnitModelUpdater.setImplementorBlock((IImplementor)testSuite.getImplementor(), null);
        }
        this.generatedTestSuite = testSuite;
    }

    protected SourcePage getSourcePage() {
        return this.sourcePage;
    }

    protected ITestSuite getGeneratedTestSuite() {
        return this.generatedTestSuite;
    }

    protected JUnitGenerator createGenerator() {
        return new JUnitGenerator(this.getSourcePage().getSuperClass());
    }

    private void generateCode(ITestSuite testSuite, IProgressMonitor monitor) throws Exception {
        JUnitGenerator generator = this.createGenerator();
        generator.addAllLibraries("org.junit");
        generator.addRequiredLibrary(CorePlugin.getID(), "common.runner.jar");
        generator.addRequiredLibrary(CorePlugin.getID(), "java.runner.jar");
        generator.generate(this.getGeneratedTestSuite(), monitor);
    }

    protected void setSourcePage(SourcePage page) {
        this.sourcePage = page;
    }
}

