/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.JUnitTestSuiteNewWizard;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SourcePage
extends NewTypeWizardPage
implements SelectionListener {
    protected static final String BEHAVIOR = "behavior";
    private Button modelBehaviorRadio;
    private Button codeBehaviorRadio;
    private boolean isModelBehavior;
    private boolean dontAskMissingLibsAgain;
    private LocationPage nextPage;

    public SourcePage() {
        super(true, "ProjectAndSourcePage");
        this.setTitle(ToolsUiPlugin.getString("JAVA_GEN_WTITLE"));
        this.setDescription(ToolsUiPlugin.getString("JAVA_GEN_LDESC"));
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IStructuredSelection selection, LocationPage locationPage) {
        this.nextPage = locationPage;
        IJavaElement element = this.getInitialJavaElement(selection);
        this.setModelBehavior(true);
        this.initContainerPage(element);
        this.initTypePage(element);
        this.setDefautSuperClass();
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(nColumns, false));
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createBehaviorControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(ToolsUiPlugin.getID()) + ".itdg0001"));
    }

    protected void createBehaviorControls(Composite composite, int numColumns) {
        Label label = new Label(composite, 0);
        label.setText(ToolsUiPlugin.getString("SourcePage.behaviorModePrompt"));
        GridData gridData = new GridData(1, 1, false, false, numColumns, 1);
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        Composite radioGroup = new Composite(composite, 1);
        GridLayout radioLayout = new GridLayout();
        radioGroup.setLayout((Layout)radioLayout);
        gridData = new GridData(4, 1, true, false, numColumns - 2, 1);
        radioGroup.setLayoutData((Object)gridData);
        this.modelBehaviorRadio = new Button(radioGroup, 16);
        this.modelBehaviorRadio.setText(ToolsUiPlugin.getString("SourcePage.modelBehaviorChoice"));
        this.modelBehaviorRadio.addSelectionListener((SelectionListener)this);
        this.codeBehaviorRadio = new Button(radioGroup, 16);
        this.codeBehaviorRadio.setText(ToolsUiPlugin.getString("SourcePage.codeBehaviorChoice"));
        if (this.isModelBehavior()) {
            this.modelBehaviorRadio.setSelection(true);
        } else {
            this.codeBehaviorRadio.setSelection(true);
        }
        label = new Label(composite, 0);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.modelBehaviorRadio) {
            this.setModelBehavior(this.modelBehaviorRadio.getSelection());
            this.handleFieldChanged(BEHAVIOR);
        }
    }

    public void setModelBehavior(boolean state) {
        this.isModelBehavior = state;
    }

    public boolean isModelBehavior() {
        return this.isModelBehavior;
    }

    protected void setDefautSuperClass() {
        if (this.isModelBehavior()) {
            this.setSuperClass("org.eclipse.hyades.test.common.junit.HyadesTestCase", false);
        } else {
            this.setSuperClass("junit.framework.TestCase", true);
        }
    }

    protected void behaviorChanged() {
        this.setDefautSuperClass();
        this.fContainerStatus = this.containerChanged();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (BEHAVIOR.equals(fieldName)) {
            this.behaviorChanged();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus};
        this.updateStatus(status);
        if (this.nextPage != null) {
            this.nextPage.setFileName(this.getTypeName());
            IResource res = this.getModifiedResource();
            if (res != null) {
                this.nextPage.setContainerFullPath(res.getParent().getFullPath());
            }
        }
    }

    public String getQualifiedTypeName() {
        String pack = this.getPackageText();
        String classname = this.getTypeName();
        if (!pack.equals("")) {
            return pack + "." + classname;
        }
        return classname;
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] superInterfaces = typeHier.getAllInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            if (superInterfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IStatus superClassChanged() {
        IStatus status;
        block6: {
            status = super.superClassChanged();
            if (status.getSeverity() != 0) {
                return status;
            }
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            if (root != null && root.exists()) {
                try {
                    IType type = root.getJavaProject().findType(this.getSuperClass());
                    if (type != null) {
                        if (!SourcePage.isTestImplementor(type)) {
                            return new Status(4, ToolsUiPlugin.getID(), 1, ToolsUiPlugin.getString("SourcePage.invalidSuperClassError"), null);
                        }
                        break block6;
                    }
                    return new Status(2, ToolsUiPlugin.getID(), 1, ToolsUiPlugin.getString("SourcePage.superClassNotFound"), null);
                }
                catch (JavaModelException e) {
                    ToolsUiPlugin.logError(e);
                }
            }
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus projectStatus;
        IStatus containerStatus = super.containerChanged();
        this.dontAskMissingLibsAgain = false;
        if (!containerStatus.matches(4) && !(projectStatus = this.validateProjectClasspath()).isOK()) {
            return projectStatus;
        }
        return containerStatus;
    }

    protected IStatus validateProjectClasspath() {
        Status status = new Status(0, ToolsUiPlugin.getID(), 1, "", null);
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        IJavaProject jp = root.getJavaProject();
        ArrayList<RequiredLibrary> missingLibraries = new ArrayList<RequiredLibrary>(3);
        List requiredLibraries = this.getRequiredLibraries();
        Iterator it = requiredLibraries.iterator();
        while (it.hasNext()) {
            RequiredLibrary lib = (RequiredLibrary)it.next();
            try {
                if (jp.findType(lib.testClass) != null) continue;
                missingLibraries.add(lib);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (missingLibraries.isEmpty()) {
            return status;
        }
        StringBuffer librariesAsText = new StringBuffer();
        it = missingLibraries.iterator();
        while (it.hasNext()) {
            RequiredLibrary lib = (RequiredLibrary)it.next();
            if (librariesAsText.length() > 0) {
                librariesAsText.append(", ");
            }
            librariesAsText.append(lib.jarName);
        }
        if (!this.dontAskMissingLibsAgain) {
            String message = missingLibraries.size() == 1 ? ToolsUiPlugin.getString("SourcePage.jar_not_on_buildpath.message", librariesAsText.toString()) : ToolsUiPlugin.getString("SourcePage.jars_not_on_buildpath.message", librariesAsText.toString());
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ToolsUiPlugin.getString("SourcePage.not_on_buildpath.title"), (String)message)) {
                IWizard theWizard = this.getWizard();
                JUnitGenerator generator = theWizard instanceof JUnitTestSuiteNewWizard ? ((JUnitTestSuiteNewWizard)theWizard).createGenerator() : new JUnitGenerator();
                it = missingLibraries.iterator();
                while (it.hasNext()) {
                    RequiredLibrary lib = (RequiredLibrary)it.next();
                    generator.addRequiredLibrary(lib.plugin, lib.jarName);
                }
                generator.adjustProjectClasspath(jp.getProject(), (IProgressMonitor)new NullProgressMonitor());
                return status;
            }
            this.dontAskMissingLibsAgain = true;
        }
        if (missingLibraries.size() == 1) {
            return new Status(2, ToolsUiPlugin.getID(), 1, ToolsUiPlugin.getString("SourcePage.error.jarNotOnbuildpath", librariesAsText.toString()), null);
        }
        return new Status(2, ToolsUiPlugin.getID(), 1, ToolsUiPlugin.getString("SourcePage.error.jarsNotOnbuildpath", librariesAsText.toString()), null);
    }

    protected List getRequiredLibraries() {
        ArrayList<RequiredLibrary> result = new ArrayList<RequiredLibrary>(3);
        if (this.isModelBehavior()) {
            result.add(new RequiredLibrary("org.eclipse.hyades.test.common.junit.HyadesTestSuite", CorePlugin.getID(), "common.runner.jar"));
            result.add(new RequiredLibrary("org.eclipse.hyades.test.java.runner.HyadesJUnitRunner", CorePlugin.getID(), "java.runner.jar"));
        }
        result.add(new RequiredLibrary("junit.framework.Test", "org.junit", "junit.jar"));
        return result;
    }

    protected class RequiredLibrary {
        public String testClass;
        public String plugin;
        public String jarName;

        public RequiredLibrary(String testClass, String plugin, String jarName) {
            this.testClass = testClass;
            this.plugin = plugin;
            this.jarName = jarName;
        }
    }
}

