/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestJavaUtil {
    public static InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite, boolean singleSelection) {
        return new InvokedTestSelectionDialog(Display.getCurrent().getActiveShell(), testSuite, ToolsUiPlugin.getString("DLG_INV_TST_TTL"), ToolsUiPlugin.getString("DLG_LOCAL_TESTS_LBL"), ToolsUiPlugin.getString("DLG_ALL_TESTS_LBL"), singleSelection){

            protected void registerHelp(int flag, Object object) {
                switch (flag) {
                    case 1: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".itdg0001"));
                        break;
                    }
                    case 2: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".itdg0002"));
                        break;
                    }
                    case 3: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(String.valueOf(ToolsUiPlugin.getID()) + ".itdg0003"));
                    }
                }
            }
        };
    }

    public static ElementTreeSelectionDialog createPackageDialog(Shell parent, final boolean defaultPackageIsValid) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    return true;
                }
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                    if (packageFragmentRoot.isArchive()) {
                        return false;
                    }
                    return !packageFragmentRoot.isExternal();
                }
                if (!defaultPackageIsValid && element instanceof IPackageFragment) {
                    return !((IPackageFragment)element).isDefaultPackage();
                }
                return false;
            }
        };
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider(){
            private StructuredViewer structuredViewer;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (viewer != this.structuredViewer) {
                    this.structuredViewer = null;
                    if (viewer instanceof StructuredViewer) {
                        this.structuredViewer = (StructuredViewer)viewer;
                    }
                }
                super.inputChanged(viewer, oldInput, newInput);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IPackageFragment) {
                    return false;
                }
                try {
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getChildren().length > 1;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return super.hasChildren(element);
            }

            public Object[] getChildren(Object parentElement) {
                try {
                    if (parentElement instanceof IJavaModel) {
                        return 3.concatenate((Object[])this.getJavaProjects((IJavaModel)parentElement), (Object[])this.getNonJavaProjects((IJavaModel)parentElement));
                    }
                    return super.getChildren(parentElement);
                }
                catch (JavaModelException e) {
                    ToolsUiPlugin.logError(e);
                    return new Object[0];
                }
            }

            private Object[] getNonJavaProjects(IJavaModel model) throws JavaModelException {
                return model.getNonJavaResources();
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IPackageFragment) {
                    return new Status(0, ToolsUiPlugin.getID(), 0, "", null);
                }
                return new Status(4, ToolsUiPlugin.getID(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)contentProvider);
        dialog.addFilter(viewerFilter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setValidator(validator);
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        return dialog;
    }

    public static ElementTreeSelectionDialog createSourceFolderDialog(Shell parent, IJavaProject javaProject) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    return true;
                }
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                    if (packageFragmentRoot.isArchive()) {
                        return false;
                    }
                    return !packageFragmentRoot.isExternal();
                }
                return false;
            }
        };
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider(){
            private StructuredViewer structuredViewer;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (viewer != this.structuredViewer) {
                    this.structuredViewer = null;
                    if (viewer instanceof StructuredViewer) {
                        this.structuredViewer = (StructuredViewer)viewer;
                    }
                }
                super.inputChanged(viewer, oldInput, newInput);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IJavaProject) {
                    return TestJavaUtil.hasSourceFolders((IJavaProject)element);
                }
                return super.hasChildren(element);
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof IPackageFragmentRoot) {
                        return new Status(0, ToolsUiPlugin.getID(), 0, "", null);
                    }
                    if (selection[0] instanceof IJavaProject && !TestJavaUtil.hasSourceFolders((IJavaProject)selection[0])) {
                        return new Status(0, ToolsUiPlugin.getID(), 0, "", null);
                    }
                }
                return new Status(4, ToolsUiPlugin.getID(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)contentProvider);
        dialog.addFilter(viewerFilter);
        dialog.setValidator(validator);
        if (javaProject != null) {
            dialog.setInput((Object)javaProject);
        } else {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        }
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        return dialog;
    }

    public static IJavaProject[] getJavaProjects() {
        try {
            return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (Exception exception) {
            return new IJavaProject[0];
        }
    }

    public static boolean hasSourceFolders(IJavaProject javaProject) {
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        int maxi = entries.length;
        while (i < maxi) {
            if (entries[i].getEntryKind() == 3 && !javaProject.getPath().equals((Object)entries[i].getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getSourceFolders(IJavaProject javaProject) {
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IResource> sourceFolders = new ArrayList<IResource>();
        int i = 0;
        int maxi = entries.length;
        while (i < maxi) {
            IResource resource;
            if (entries[i].getEntryKind() == 3 && !javaProject.getPath().equals((Object)entries[i].getPath()) && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entries[i].getPath())) != null && resource.exists() && resource.getType() == 2) {
                sourceFolders.add(resource);
            }
            ++i;
        }
        return sourceFolders;
    }
}

