/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.plugin.internal.junit.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.test.tools.core.internal.plugin.util.WorkbenchLocationUtil;
import org.eclipse.hyades.test.tools.ui.plugin.internal.PluginMessages;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class WorkbenchPropertyGroupForm
extends EditorForm
implements IPropertyGroupForm {
    private CFGPropertyGroup propertyGroup;
    private EditorSection generalSection;
    private EditorSection workspaceSection;
    private EditorSection programSection;
    private EditorSection commandLineSection;
    private EditorSection configurationSection;
    private EditorSection pluginsSection;
    private String name;
    private String description;

    public void setExtension(IConfigurationElement extension) {
        this.name = extension.getAttribute("name");
        this.description = extension.getAttribute("description");
    }

    public String getName() {
        return this.notNull(this.name);
    }

    public String getDescription() {
        return this.notNull(this.description);
    }

    public CFGPropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public void load() {
        this.generalSection.setInput((Object)this.propertyGroup);
        this.workspaceSection.setInput((Object)this.propertyGroup);
        this.programSection.setInput((Object)this.propertyGroup);
        this.commandLineSection.setInput((Object)this.propertyGroup);
        this.configurationSection.setInput((Object)this.propertyGroup);
        this.pluginsSection.setInput((Object)this.propertyGroup);
    }

    public IStructuredSelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void selectReveal(ISelection selection) {
        CFGComparableProperty p;
        String name;
        StructuredSelection sel;
        Object elem;
        if (selection instanceof StructuredSelection && (elem = (sel = (StructuredSelection)selection).getFirstElement()) != null && elem instanceof CFGComparableProperty && (name = (p = (CFGComparableProperty)elem).getName()) != null) {
            Iterator it = this.sections.iterator();
            while (it.hasNext()) {
                PropertyGroupSection section;
                Object obj = it.next();
                if (!(obj instanceof PropertyGroupSection) || (section = (PropertyGroupSection)((Object)obj)).getControl(name) == null) continue;
                section.setFocus();
                section.selectReveal(selection);
                return;
            }
        }
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        ((GridData)leftColumn.getLayoutData()).widthHint = 320;
        ((GridData)rightColumn.getLayoutData()).widthHint = 320;
        this.generalSection = this.createGeneralSection(leftColumn);
        this.registerSection((FormSection)this.generalSection);
        this.workspaceSection = this.createWorkspaceSection(leftColumn);
        this.registerSection((FormSection)this.workspaceSection);
        this.programSection = this.createProgramSection(leftColumn);
        this.registerSection((FormSection)this.programSection);
        this.commandLineSection = this.createCommandLineSection(leftColumn);
        this.registerSection((FormSection)this.commandLineSection);
        this.configurationSection = this.createConfigurationSection(leftColumn);
        this.registerSection((FormSection)this.configurationSection);
        this.pluginsSection = this.createPluginsSection(rightColumn);
        this.registerSection((FormSection)this.pluginsSection);
        this.pluginsSection.setHeightHint(leftColumn.computeSize((int)320, (int)-1).y);
        this.setHeadingText(this.name);
    }

    private EditorSection createGeneralSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Text eclipseLocation;
            private Button allowReuse;
            private ModifyListener eclipseLocListener = new ModifyListener(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setEclipseLocation((CFGPropertyGroup)this.this$1.getGroup(), (String)1.access$0(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener allowReuseListener = new SelectionListener(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchLocationUtil.setAllowReuse((CFGPropertyGroup)this.this$1.getGroup(), (boolean)1.access$1(this.this$1).getSelection());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                composite.setLayout((Layout)gridLayout);
                Label label = WorkbenchPropertyGroupForm.this.getWidgetFactory().createLabel(composite, PluginMessages.WBENCH_FORM_ECLIPSE_LOCATION);
                label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                this.eclipseLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText(composite, "", 0);
                this.eclipseLocation.setLayoutData((Object)new GridData(4, 1, true, false));
                this.allowReuse = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_ALLOW_REUSE, 32);
                GridData data = new GridData(1, 1, false, false);
                data.horizontalSpan = 2;
                this.allowReuse.setLayoutData((Object)data);
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            protected void enableListeners(boolean state) {
                if (state) {
                    this.eclipseLocation.addModifyListener(this.eclipseLocListener);
                    this.allowReuse.addSelectionListener(this.allowReuseListener);
                } else {
                    this.eclipseLocation.removeModifyListener(this.eclipseLocListener);
                    this.allowReuse.removeSelectionListener(this.allowReuseListener);
                }
            }

            protected void initializeFields() {
                this.enableListeners(false);
                if (this.getGroup() != null) {
                    this.eclipseLocation.setText(WorkbenchPropertyGroupForm.this.notNull(WorkbenchLocationUtil.getEclipseLocation((CFGPropertyGroup)this.getGroup())));
                    this.eclipseLocation.setEnabled(true);
                    this.allowReuse.setSelection(WorkbenchLocationUtil.getAllowReuse((CFGPropertyGroup)this.getGroup()));
                    this.allowReuse.setEnabled(true);
                } else {
                    this.eclipseLocation.setEnabled(false);
                    this.allowReuse.setEnabled(false);
                }
                this.enableListeners(true);
            }

            public Control getControl(String propertyName) {
                if ("eclipseLocation".equals(propertyName)) {
                    return this.eclipseLocation;
                }
                if ("allowReuse".equals(propertyName)) {
                    return this.allowReuse;
                }
                return null;
            }

            static /* synthetic */ Text access$0(1 var0) {
                return var0.eclipseLocation;
            }

            static /* synthetic */ Button access$1(1 var0) {
                return var0.allowReuse;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_GENERAL_SECTION);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    private EditorSection createWorkspaceSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Button useTemporaryLocation;
            private Text workspaceLocation;
            private Button clearWorkspace;
            private SelectionListener useTempLocationListener = new SelectionListener(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean state = 4.access$0(this.this$1).getSelection();
                    4.access$1(this.this$1).setEnabled(!state);
                    4.access$2(this.this$1).setEnabled(!state);
                    if (state) {
                        WorkbenchLocationUtil.setWorkspaceDirectory((CFGPropertyGroup)this.this$1.getGroup(), null);
                    } else {
                        WorkbenchLocationUtil.setWorkspaceDirectory((CFGPropertyGroup)this.this$1.getGroup(), (String)4.access$1(this.this$1).getText());
                    }
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private ModifyListener workspaceLocationListener = new ModifyListener(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setWorkspaceDirectory((CFGPropertyGroup)this.this$1.getGroup(), (String)4.access$1(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener clearWorkspaceListener = new SelectionListener(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchLocationUtil.setClearWorkspaceDirectory((CFGPropertyGroup)this.this$1.getGroup(), (boolean)4.access$2(this.this$1).getSelection());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                composite.setLayout((Layout)gridLayout);
                this.useTemporaryLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_USE_TEMP_WORKSPACE, 32);
                GridData data = new GridData(1, 1, true, false);
                data.horizontalSpan = 2;
                this.useTemporaryLocation.setLayoutData((Object)data);
                Label label = WorkbenchPropertyGroupForm.this.getWidgetFactory().createLabel(composite, PluginMessages.WBENCH_FORM_WORKSPACE_LOCATION);
                label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                this.workspaceLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText(composite, "", 0);
                this.workspaceLocation.setLayoutData((Object)new GridData(4, 1, true, false));
                this.clearWorkspace = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_CLEAR_WORKSPACE, 32);
                data = new GridData(1, 1, true, false);
                data.horizontalSpan = 2;
                this.clearWorkspace.setLayoutData((Object)data);
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            protected void enableListeners(boolean state) {
                if (state) {
                    this.useTemporaryLocation.addSelectionListener(this.useTempLocationListener);
                    this.workspaceLocation.addModifyListener(this.workspaceLocationListener);
                    this.clearWorkspace.addSelectionListener(this.clearWorkspaceListener);
                } else {
                    this.useTemporaryLocation.removeSelectionListener(this.useTempLocationListener);
                    this.workspaceLocation.removeModifyListener(this.workspaceLocationListener);
                    this.clearWorkspace.removeSelectionListener(this.clearWorkspaceListener);
                }
            }

            protected void initializeFields() {
                this.enableListeners(false);
                if (this.getGroup() != null) {
                    String location = WorkbenchLocationUtil.getWorkspaceDirectory((CFGPropertyGroup)this.getGroup());
                    this.useTemporaryLocation.setEnabled(true);
                    if (location == null) {
                        this.useTemporaryLocation.setSelection(true);
                        this.workspaceLocation.setEnabled(false);
                        this.clearWorkspace.setEnabled(false);
                    } else {
                        this.useTemporaryLocation.setSelection(false);
                        this.workspaceLocation.setText(location);
                        this.workspaceLocation.setEnabled(true);
                        this.clearWorkspace.setSelection(WorkbenchLocationUtil.getClearWorkspaceDirectory((CFGPropertyGroup)this.getGroup()));
                        this.clearWorkspace.setEnabled(true);
                    }
                } else {
                    this.useTemporaryLocation.setEnabled(false);
                    this.workspaceLocation.setEnabled(false);
                    this.clearWorkspace.setEnabled(false);
                }
                this.enableListeners(true);
            }

            public Control getControl(String propertyName) {
                if ("workspaceDirectory".equals(propertyName)) {
                    return this.workspaceLocation;
                }
                if ("clearWorkspaceDir".equals(propertyName)) {
                    return this.clearWorkspace;
                }
                return null;
            }

            static /* synthetic */ Button access$0(4 var0) {
                return var0.useTemporaryLocation;
            }

            static /* synthetic */ Text access$1(4 var0) {
                return var0.workspaceLocation;
            }

            static /* synthetic */ Button access$2(4 var0) {
                return var0.clearWorkspace;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_WORKSPACE_SECTION);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    private EditorSection createProgramSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Button headlessMode;
            private Button useApplication;
            private Button useProduct;
            private Combo applicationName;
            private Combo productName;
            private Button uiThread;
            private SelectionListener headlessModeListener = new SelectionListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean state = 8.access$0(this.this$1).getSelection();
                    WorkbenchLocationUtil.setHeadless((CFGPropertyGroup)this.this$1.getGroup(), (boolean)state);
                    WorkbenchLocationUtil.setApplicationName((CFGPropertyGroup)this.this$1.getGroup(), null);
                    WorkbenchLocationUtil.setProductName((CFGPropertyGroup)this.this$1.getGroup(), null);
                    8.access$1(this.this$1).setEnabled(!state);
                    if (!state) {
                        8.access$1(this.this$1).setSelection(WorkbenchLocationUtil.getRunInUIThread((CFGPropertyGroup)this.this$1.getGroup()));
                    }
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener useApplicationListener = new SelectionListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    8.access$2(this.this$1).setEnabled(8.access$3(this.this$1).getSelection());
                    if (8.access$3(this.this$1).getSelection()) {
                        WorkbenchLocationUtil.setApplicationName((CFGPropertyGroup)this.this$1.getGroup(), (String)8.access$2(this.this$1).getText());
                    } else {
                        WorkbenchLocationUtil.setApplicationName((CFGPropertyGroup)this.this$1.getGroup(), null);
                    }
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener useProductListener = new SelectionListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    8.access$4(this.this$1).setEnabled(8.access$5(this.this$1).getSelection());
                    if (8.access$5(this.this$1).getSelection()) {
                        WorkbenchLocationUtil.setProductName((CFGPropertyGroup)this.this$1.getGroup(), (String)8.access$4(this.this$1).getText());
                    } else {
                        WorkbenchLocationUtil.setProductName((CFGPropertyGroup)this.this$1.getGroup(), null);
                    }
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private ModifyListener applicationNameListener = new ModifyListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setApplicationName((CFGPropertyGroup)this.this$1.getGroup(), (String)8.access$2(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private ModifyListener productNameListener = new ModifyListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setProductName((CFGPropertyGroup)this.this$1.getGroup(), (String)8.access$2(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener uiThreadListener = new SelectionListener(this){
                final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchLocationUtil.setRunInUIThread((CFGPropertyGroup)this.this$1.getGroup(), (boolean)8.access$1(this.this$1).getSelection());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                composite.setLayout((Layout)gridLayout);
                this.headlessMode = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, "Run in headless mode", 16);
                this.headlessMode.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
                this.useApplication = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_RUN_APPLICATION, 16);
                this.useApplication.setLayoutData((Object)new GridData(1, 1, false, false));
                this.applicationName = new Combo(composite, 8);
                this.applicationName.setLayoutData((Object)new GridData(4, 1, true, false));
                this.applicationName.setItems(WorkbenchLocationUtil.getAvailableApplicationNames((CFGPropertyGroup)this.getGroup()));
                this.applicationName.setText(WorkbenchLocationUtil.getDefaultApplicationName((CFGPropertyGroup)this.getGroup()));
                this.useProduct = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_RUN_PRODUCT, 16);
                this.useProduct.setLayoutData((Object)new GridData(1, 1, false, false));
                this.productName = new Combo(composite, 8);
                this.productName.setLayoutData((Object)new GridData(4, 1, true, false));
                this.productName.setItems(WorkbenchLocationUtil.getAvailableProductNames((CFGPropertyGroup)this.getGroup()));
                this.productName.setText(WorkbenchLocationUtil.getDefaultProductname((CFGPropertyGroup)this.getGroup()));
                this.uiThread = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, "Run tests in UI thread", 32);
                this.uiThread.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            protected void enableListeners(boolean state) {
                if (state) {
                    this.headlessMode.addSelectionListener(this.headlessModeListener);
                    this.useApplication.addSelectionListener(this.useApplicationListener);
                    this.applicationName.addModifyListener(this.applicationNameListener);
                    this.useProduct.addSelectionListener(this.useProductListener);
                    this.productName.addModifyListener(this.productNameListener);
                    this.uiThread.addSelectionListener(this.uiThreadListener);
                } else {
                    this.headlessMode.removeSelectionListener(this.headlessModeListener);
                    this.useApplication.removeSelectionListener(this.useApplicationListener);
                    this.applicationName.removeModifyListener(this.applicationNameListener);
                    this.useProduct.removeSelectionListener(this.useProductListener);
                    this.productName.removeModifyListener(this.productNameListener);
                    this.uiThread.removeSelectionListener(this.uiThreadListener);
                }
            }

            protected void initializeFields() {
                this.enableListeners(false);
                if (this.getGroup() != null) {
                    this.setEnabled(true);
                    if (WorkbenchLocationUtil.getHeadless((CFGPropertyGroup)this.getGroup())) {
                        this.headlessMode.setSelection(WorkbenchLocationUtil.getHeadless((CFGPropertyGroup)this.getGroup()));
                        this.applicationName.setEnabled(false);
                        this.productName.setEnabled(false);
                        this.uiThread.setEnabled(false);
                    } else {
                        String appName = WorkbenchLocationUtil.getApplicationName((CFGPropertyGroup)this.getGroup());
                        String prodName = WorkbenchLocationUtil.getProductName((CFGPropertyGroup)this.getGroup());
                        if (appName != null) {
                            this.useApplication.setSelection(true);
                            this.applicationName.setText(appName);
                            this.useProduct.setSelection(false);
                            this.productName.setEnabled(false);
                            this.uiThread.setSelection(WorkbenchLocationUtil.getRunInUIThread((CFGPropertyGroup)this.getGroup()));
                            this.uiThread.setEnabled(true);
                        } else if (prodName != null) {
                            this.useApplication.setSelection(false);
                            this.useProduct.setSelection(true);
                            this.productName.setText(prodName);
                            this.applicationName.setEnabled(false);
                            this.uiThread.setSelection(WorkbenchLocationUtil.getRunInUIThread((CFGPropertyGroup)this.getGroup()));
                            this.uiThread.setEnabled(true);
                        } else {
                            this.useApplication.setSelection(true);
                            this.applicationName.setEnabled(true);
                            this.applicationName.setText("");
                            this.useProduct.setSelection(false);
                            this.productName.setEnabled(false);
                        }
                    }
                } else {
                    this.setEnabled(false);
                }
                this.enableListeners(true);
            }

            private void setEnabled(boolean state) {
                this.headlessMode.setEnabled(state);
                this.useApplication.setEnabled(state);
                this.applicationName.setEnabled(state);
                this.useProduct.setEnabled(state);
                this.productName.setEnabled(state);
                this.uiThread.setEnabled(state);
            }

            public Control getControl(String propertyName) {
                if ("headless".equals(propertyName)) {
                    return this.headlessMode;
                }
                if ("applicationName".equals(propertyName)) {
                    return this.applicationName;
                }
                if ("productName".equals(propertyName)) {
                    return this.productName;
                }
                if ("uiThread".equals(propertyName)) {
                    return this.uiThread;
                }
                return null;
            }

            static /* synthetic */ Button access$0(8 var0) {
                return var0.headlessMode;
            }

            static /* synthetic */ Button access$1(8 var0) {
                return var0.uiThread;
            }

            static /* synthetic */ Combo access$2(8 var0) {
                return var0.applicationName;
            }

            static /* synthetic */ Button access$3(8 var0) {
                return var0.useApplication;
            }

            static /* synthetic */ Combo access$4(8 var0) {
                return var0.productName;
            }

            static /* synthetic */ Button access$5(8 var0) {
                return var0.useProduct;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_PROGRAM_SECTION);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    private EditorSection createCommandLineSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Text programArgs;
            private Text vmArgs;
            private ModifyListener programArgsListener = new ModifyListener(this){
                final /* synthetic */ 15 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setProgramArguments((CFGPropertyGroup)this.this$1.getGroup(), (String)15.access$0(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private ModifyListener vmArgsListener = new ModifyListener(this){
                final /* synthetic */ 15 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setVMArguments((CFGPropertyGroup)this.this$1.getGroup(), (String)15.access$1(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                composite.setLayout((Layout)gridLayout);
                Label label = WorkbenchPropertyGroupForm.this.getWidgetFactory().createLabel(composite, PluginMessages.WBENCH_FORM_PROGRAM_ARGUMENTS);
                label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                this.programArgs = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText(composite, "", 0);
                this.programArgs.setLayoutData((Object)new GridData(4, 1, true, false));
                label = WorkbenchPropertyGroupForm.this.getWidgetFactory().createLabel(composite, PluginMessages.WBENCH_FORM_VM_ARGUMENTS);
                label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                this.vmArgs = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText(composite, "", 0);
                this.vmArgs.setLayoutData((Object)new GridData(4, 1, true, false));
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            protected void enableListeners(boolean state) {
                if (state) {
                    this.programArgs.addModifyListener(this.programArgsListener);
                    this.vmArgs.addModifyListener(this.vmArgsListener);
                } else {
                    this.programArgs.removeModifyListener(this.programArgsListener);
                    this.vmArgs.removeModifyListener(this.vmArgsListener);
                }
            }

            protected void initializeFields() {
                this.enableListeners(false);
                if (this.getGroup() != null) {
                    this.programArgs.setText(WorkbenchLocationUtil.getProgramArguments((CFGPropertyGroup)this.getGroup()));
                    this.programArgs.setEnabled(true);
                    this.vmArgs.setText(WorkbenchLocationUtil.getVMArguments((CFGPropertyGroup)this.getGroup()));
                    this.vmArgs.setEnabled(true);
                } else {
                    this.programArgs.setEnabled(false);
                    this.vmArgs.setEnabled(false);
                }
                this.enableListeners(true);
            }

            public Control getControl(String propertyName) {
                if ("programArguments".equals(propertyName)) {
                    return this.programArgs;
                }
                if ("vmArguments".equals(propertyName)) {
                    return this.vmArgs;
                }
                return null;
            }

            static /* synthetic */ Text access$0(15 var0) {
                return var0.programArgs;
            }

            static /* synthetic */ Text access$1(15 var0) {
                return var0.vmArgs;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_COMMAND_LINE_SECTION);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    private EditorSection createConfigurationSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Button useDefaultLocation;
            private Text configLocation;
            private Button clearConfig;
            private Button generateConfigIni;
            private Button useTemplateIni;
            private Text templateIniLocation;
            private SelectionListener useDefaultLocListener = new SelectionListener(this){
                final /* synthetic */ 18 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean state = 18.access$0(this.this$1).getSelection();
                    18.access$1(this.this$1).setEnabled(!state);
                    18.access$2(this.this$1).setEnabled(!state);
                    if (state) {
                        WorkbenchLocationUtil.setConfigurationDirectory((CFGPropertyGroup)this.this$1.getGroup(), null);
                    } else {
                        WorkbenchLocationUtil.setConfigurationDirectory((CFGPropertyGroup)this.this$1.getGroup(), (String)18.access$1(this.this$1).getText());
                    }
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                    18.access$5(this.this$1).getWidgetFactory().paintBordersFor(18.access$1(this.this$1).getParent());
                }
            };
            private ModifyListener configLocationListener = new ModifyListener(this){
                final /* synthetic */ 18 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setConfigurationDirectory((CFGPropertyGroup)this.this$1.getGroup(), (String)18.access$1(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener clearConfigListener = new SelectionListener(this){
                final /* synthetic */ 18 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchLocationUtil.setClearConfigurationDirectory((CFGPropertyGroup)this.this$1.getGroup(), (boolean)18.access$2(this.this$1).getSelection());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private SelectionListener useTemplateIniListener = new SelectionListener(this){
                final /* synthetic */ 18 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean state = 18.access$3(this.this$1).getSelection();
                    18.access$4(this.this$1).setEnabled(state);
                    18.access$5(this.this$1).getWidgetFactory().paintBordersFor(18.access$4(this.this$1).getParent());
                    WorkbenchLocationUtil.setGenerateDefaultConfigIni((CFGPropertyGroup)this.this$1.getGroup(), (!state ? 1 : 0) != 0);
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };
            private ModifyListener templateIniLocationListener = new ModifyListener(this){
                final /* synthetic */ 18 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void modifyText(ModifyEvent e) {
                    WorkbenchLocationUtil.setConfigIniTemplateLocation((CFGPropertyGroup)this.this$1.getGroup(), (String)18.access$4(this.this$1).getText());
                    this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                }
            };

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                composite.setLayout((Layout)gridLayout);
                this.useDefaultLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_USE_TEMP_CONFIG_DIR, 32);
                GridData data = new GridData(1, 1, true, false);
                data.horizontalSpan = 2;
                this.useDefaultLocation.setLayoutData((Object)data);
                Label label = WorkbenchPropertyGroupForm.this.getWidgetFactory().createLabel(composite, PluginMessages.WBENCH_FORM_CONFIG_LOCATION);
                label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                this.configLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText(composite, "", 0);
                this.configLocation.setLayoutData((Object)new GridData(4, 1, true, false));
                this.clearConfig = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_CLEAR_CONFIG_AREA, 32);
                data = new GridData(1, 1, true, false);
                data.horizontalSpan = 2;
                this.clearConfig.setLayoutData((Object)data);
                Composite configIniGroup = this.createConfigIniGroup(composite);
                data = new GridData(4, 1, true, false);
                data.horizontalSpan = 2;
                configIniGroup.setLayoutData((Object)data);
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            private Composite createConfigIniGroup(Composite parent) {
                Group group = new Group(parent, 0x800000);
                GridLayout layout = new GridLayout(1, true);
                group.setLayout((Layout)layout);
                group.setBackground(parent.getBackground());
                group.setText(PluginMessages.WBENCH_FORM_CONFIG_INI_GROUP);
                this.generateConfigIni = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton((Composite)group, PluginMessages.WBENCH_FORM_GENERATE_DEFAULT_CONFIG_INI, 16);
                this.generateConfigIni.setLayoutData((Object)new GridData(1, 1, false, false));
                this.useTemplateIni = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton((Composite)group, PluginMessages.WBENCH_FORM_USE_TEMPLATE_CONFIG_INI, 16);
                this.useTemplateIni.setLayoutData((Object)new GridData(1, 1, false, false));
                this.templateIniLocation = WorkbenchPropertyGroupForm.this.getWidgetFactory().createText((Composite)group, "");
                GridData data = new GridData(4, 1, true, false);
                data.horizontalIndent = 20;
                this.templateIniLocation.setLayoutData((Object)data);
                return group;
            }

            protected void enableListeners(boolean state) {
                if (state) {
                    this.useDefaultLocation.addSelectionListener(this.useDefaultLocListener);
                    this.configLocation.addModifyListener(this.configLocationListener);
                    this.clearConfig.addSelectionListener(this.clearConfigListener);
                    this.useTemplateIni.addSelectionListener(this.useTemplateIniListener);
                    this.templateIniLocation.addModifyListener(this.templateIniLocationListener);
                } else {
                    this.useDefaultLocation.removeSelectionListener(this.useDefaultLocListener);
                    this.configLocation.removeModifyListener(this.configLocationListener);
                    this.clearConfig.removeSelectionListener(this.clearConfigListener);
                    this.useTemplateIni.removeSelectionListener(this.useTemplateIniListener);
                    this.templateIniLocation.removeModifyListener(this.templateIniLocationListener);
                }
            }

            protected void initializeFields() {
                this.enableListeners(false);
                if (this.getGroup() != null) {
                    String location = WorkbenchLocationUtil.getConfigurationDirectory((CFGPropertyGroup)this.getGroup());
                    this.useDefaultLocation.setEnabled(true);
                    if (location == null) {
                        this.useDefaultLocation.setSelection(true);
                        this.configLocation.setEnabled(false);
                        this.clearConfig.setEnabled(false);
                    } else {
                        this.useDefaultLocation.setSelection(false);
                        this.configLocation.setText(location);
                        this.configLocation.setEnabled(true);
                        this.clearConfig.setSelection(WorkbenchLocationUtil.getClearConfigurationDirectory((CFGPropertyGroup)this.getGroup()));
                        this.clearConfig.setEnabled(true);
                    }
                    this.generateConfigIni.setEnabled(true);
                    this.useTemplateIni.setEnabled(true);
                    if (WorkbenchLocationUtil.getGenerateDefaultConfigIni((CFGPropertyGroup)this.getGroup())) {
                        this.generateConfigIni.setSelection(true);
                        this.useTemplateIni.setSelection(false);
                        this.templateIniLocation.setEnabled(false);
                    } else {
                        this.generateConfigIni.setSelection(false);
                        this.useTemplateIni.setSelection(true);
                        this.templateIniLocation.setEnabled(true);
                    }
                    this.templateIniLocation.setText(WorkbenchPropertyGroupForm.this.notNull(WorkbenchLocationUtil.getConfigIniTemplateLocation((CFGPropertyGroup)this.getGroup())));
                } else {
                    this.useDefaultLocation.setEnabled(false);
                    this.configLocation.setEnabled(false);
                    this.clearConfig.setEnabled(false);
                    this.generateConfigIni.setEnabled(false);
                    this.useTemplateIni.setEnabled(false);
                    this.templateIniLocation.setEnabled(false);
                }
                this.enableListeners(true);
            }

            public Control getControl(String propertyName) {
                if ("configDir".equals(propertyName)) {
                    return this.useDefaultLocation;
                }
                if ("clearConfigDir".equals(propertyName)) {
                    return this.clearConfig;
                }
                if ("defaultConfigIni".equals(propertyName)) {
                    return this.generateConfigIni;
                }
                if ("configIniTemplateLocation".equals(propertyName)) {
                    return this.templateIniLocation;
                }
                return null;
            }

            static /* synthetic */ Button access$0(18 var0) {
                return var0.useDefaultLocation;
            }

            static /* synthetic */ Text access$1(18 var0) {
                return var0.configLocation;
            }

            static /* synthetic */ Button access$2(18 var0) {
                return var0.clearConfig;
            }

            static /* synthetic */ Button access$3(18 var0) {
                return var0.useTemplateIni;
            }

            static /* synthetic */ Text access$4(18 var0) {
                return var0.templateIniLocation;
            }

            static /* synthetic */ WorkbenchPropertyGroupForm access$5(18 var0) {
                return var0.WorkbenchPropertyGroupForm.this;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_CONFIGURATION_SECTION);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    private String notNull(String string) {
        return string == null ? "" : string;
    }

    private EditorSection createPluginsSection(Composite parent) {
        PropertyGroupSection section = new PropertyGroupSection(this){
            private Button useDefaultPlugins;
            private Button choosePlugins;
            private CheckboxTableViewer externalPlugins;

            public void setHeightHint(int newHeightHint) {
                ((GridData)this.externalPlugins.getControl().getLayoutData()).heightHint = newHeightHint - this.useDefaultPlugins.computeSize((int)-1, (int)-1).y - this.choosePlugins.computeSize((int)-1, (int)-1).y;
            }

            public Composite createClient(Composite parent, FormWidgetFactory factory) {
                Composite composite = WorkbenchPropertyGroupForm.this.getWidgetFactory().createComposite(parent);
                composite.setLayout((Layout)new GridLayout(1, true));
                this.useDefaultPlugins = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_ALL_PLUGINS, 16);
                this.useDefaultPlugins.setLayoutData((Object)new GridData(1, 1, false, false));
                this.useDefaultPlugins.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean state = 24.access$0(this.this$1).getSelection();
                        WorkbenchLocationUtil.setUseDefaultPlugins((CFGPropertyGroup)this.this$1.getGroup(), (boolean)state);
                        this.this$1.getEditorForm().getBaseEditorExtension().markDirty();
                        24.access$1(this.this$1).getTable().setEnabled(!state);
                    }
                });
                this.choosePlugins = WorkbenchPropertyGroupForm.this.getWidgetFactory().createButton(composite, PluginMessages.WBENCH_FORM_CHOOSE_PLUGINS, 16);
                this.choosePlugins.setLayoutData((Object)new GridData(1, 1, false, false));
                Table table = new Table(composite, 0x800820);
                GridData data = new GridData(4, 1, true, false);
                table.setLayoutData((Object)data);
                this.externalPlugins = new CheckboxTableViewer(table);
                this.externalPlugins.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                    Object[] elements;
                    final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        this.elements = newInput != null && newInput instanceof CFGPropertyGroup ? WorkbenchLocationUtil.getAvailableExternalPlugins((CFGPropertyGroup)((CFGPropertyGroup)newInput)) : new Object[0];
                    }

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        return this.elements;
                    }
                });
                this.externalPlugins.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
                this.externalPlugins.addCheckStateListener(new ICheckStateListener(this){
                    final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.this$1.saveCheckedPlugins();
                    }
                });
                WorkbenchPropertyGroupForm.this.getWidgetFactory().paintBordersFor(composite);
                composite.setLayoutData((Object)GridDataUtil.createFill());
                return composite;
            }

            protected void saveCheckedPlugins() {
                Object[] elements = this.externalPlugins.getCheckedElements();
                ArrayList<String> plugins = new ArrayList<String>();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IPluginModelBase) {
                        IPluginModelBase plugin = (IPluginModelBase)elements[i];
                        plugins.add(plugin.getPluginBase().getId());
                    }
                    ++i;
                }
                WorkbenchLocationUtil.setExternalPlugins((CFGPropertyGroup)this.getGroup(), plugins);
                this.getEditorForm().getBaseEditorExtension().markDirty();
            }

            protected void initializeFields() {
                this.externalPlugins.setInput((Object)this.getGroup());
                if (this.getGroup() != null) {
                    boolean useDefaults = WorkbenchLocationUtil.getUseDefaultPlugins((CFGPropertyGroup)this.getGroup());
                    this.useDefaultPlugins.setEnabled(true);
                    this.choosePlugins.setEnabled(true);
                    this.useDefaultPlugins.setSelection(useDefaults);
                    this.choosePlugins.setSelection(!useDefaults);
                    this.externalPlugins.getTable().setEnabled(!useDefaults);
                    Collection pluginsToCheck = WorkbenchLocationUtil.getExternalPlugins((CFGPropertyGroup)this.getGroup());
                    Object[] elements = ((IStructuredContentProvider)this.externalPlugins.getContentProvider()).getElements((Object)this.getGroup());
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] instanceof IPluginModelBase) {
                            IPluginModelBase plugin = (IPluginModelBase)elements[i];
                            this.externalPlugins.setChecked((Object)plugin, pluginsToCheck.contains(plugin.getPluginBase().getId()));
                        }
                        ++i;
                    }
                } else {
                    this.useDefaultPlugins.setEnabled(false);
                    this.choosePlugins.setEnabled(false);
                    this.externalPlugins.getTable().setEnabled(false);
                }
            }

            public Control getControl(String propertyName) {
                if ("useDefaultPlugins".equals(propertyName)) {
                    return this.useDefaultPlugins;
                }
                if ("externalPlugins".equals(propertyName)) {
                    return this.choosePlugins;
                }
                return null;
            }

            static /* synthetic */ Button access$0(24 var0) {
                return var0.useDefaultPlugins;
            }

            static /* synthetic */ CheckboxTableViewer access$1(24 var0) {
                return var0.externalPlugins;
            }
        };
        section.setHeaderText(PluginMessages.WBENCH_FORM_PLUGINS);
        section.setCollapsable(false);
        Control control = section.createControl(parent, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return section;
    }

    public void init(CFGPropertyGroup group, BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super.init(baseEditorExtension, widgetFactory);
        this.propertyGroup = group;
    }

    protected abstract class PropertyGroupSection
    extends EditorSection {
        private CFGPropertyGroup group;

        protected PropertyGroupSection(EditorForm editorForm) {
            super(editorForm);
        }

        protected CFGPropertyGroup getGroup() {
            return this.group;
        }

        public void setInput(Object object) {
            if (object == this.group) {
                return;
            }
            if (object instanceof CFGPropertyGroup) {
                this.group = (CFGPropertyGroup)object;
            }
            this.initializeFields();
        }

        protected abstract void initializeFields();

        public Object getInput() {
            return this.group;
        }

        public IStructuredSelection getStructuredSelection() {
            return this.group == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.group);
        }

        public void selectReveal(ISelection selection) {
            Control control;
            CFGComparableProperty p;
            String name;
            StructuredSelection sel;
            Object elem;
            if (selection instanceof StructuredSelection && (elem = (sel = (StructuredSelection)selection).getFirstElement()) != null && elem instanceof CFGComparableProperty && (name = (p = (CFGComparableProperty)elem).getName()) != null && (control = this.getControl(name)) != null) {
                control.setFocus();
            }
        }

        public abstract Control getControl(String var1);
    }
}

