/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.plugin.internal.junit.wizard;

import org.eclipse.hyades.test.tools.ui.plugin.internal.PluginMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class WorkbenchLocationDetailsPage
extends WizardPage {
    private Button local;
    private Button remote;
    private Text hostname;
    private Text eclipseDir;
    private Button allowReuse;
    private Link localLabel;
    private Label eclipseLabel;
    private Label hostLabel;
    private Button headless;
    private Button uiThread;
    private static final String DS_USE_LOCAL = "workbenchDetails.useLocal";
    private static final String DS_HOSTNAME = "workbenchDetails.hostname";
    private static final String DS_ECLIPSE_DIR = "workbenchDetails.eclipseDir";
    private static final String DS_ALLOW_REUSE = "workbenchDetails.allowReuse";
    private static final String DS_HEADLESS = "workbenchDetails.headless";
    private static final String DS_UI_THREAD = "workbenchDetails.uiThread";

    protected WorkbenchLocationDetailsPage(IDialogSettings settings) {
        super("workbenchDetailsPage");
        this.setTitle(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_TITLE);
        this.setDescription(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_DESCRIPTION);
        this.initDialogSettings(settings);
    }

    protected void addSpacer(Composite parent, int numColumns) {
        int i = 0;
        while (i < numColumns) {
            Label label = new Label(parent, 0);
            GridData data = new GridData(1, 1, false, false);
            data.widthHint = 20;
            label.setLayoutData((Object)data);
            ++i;
        }
    }

    protected Group createMainGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        FillLayout flayout = new FillLayout();
        flayout.marginHeight = 5;
        flayout.marginWidth = 5;
        group.setLayout((Layout)flayout);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        return group;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Group group = this.createMainGroup(composite, PluginMessages.WORKBENCH_DETAILS_WIZPAGE_LOCATION);
        this.createLocationDetailsPane((Composite)group);
        group = this.createMainGroup(composite, PluginMessages.WORKBENCH_DETAILS_WIZPAGE_OPTIONS);
        this.createOptionsPane((Composite)group);
        this.initControls();
        this.setControl((Control)composite);
    }

    protected void initControls() {
        IDialogSettings settings = this.getWizard().getDialogSettings();
        boolean b = settings.getBoolean(DS_USE_LOCAL);
        if (b) {
            this.local.setSelection(true);
        } else {
            this.remote.setSelection(true);
        }
        this.enableHostControls(b);
        String s = settings.get(DS_HOSTNAME);
        if (s != null) {
            this.hostname.setText(s);
        }
        if ((s = settings.get(DS_ECLIPSE_DIR)) != null) {
            this.eclipseDir.setText(s);
        }
        this.allowReuse.setSelection(settings.getBoolean(DS_ALLOW_REUSE));
        this.headless.setSelection(settings.getBoolean(DS_HEADLESS));
        if (this.headless.getSelection()) {
            this.uiThread.setEnabled(false);
        } else {
            this.uiThread.setSelection(settings.getBoolean(DS_UI_THREAD));
        }
    }

    protected void enableHostControls(boolean isLocal) {
        this.localLabel.setEnabled(isLocal);
        this.hostLabel.setEnabled(!isLocal);
        this.hostname.setEnabled(!isLocal);
        this.eclipseLabel.setEnabled(!isLocal);
        this.eclipseDir.setEnabled(!isLocal);
    }

    public void saveDialogSettings() {
        IDialogSettings settings = this.getWizard().getDialogSettings();
        settings.put(DS_USE_LOCAL, this.local.getSelection());
        settings.put(DS_HOSTNAME, this.hostname.getText());
        settings.put(DS_ECLIPSE_DIR, this.eclipseDir.getText());
        settings.put(DS_ALLOW_REUSE, this.allowReuse.getSelection());
        settings.put(DS_HEADLESS, this.headless.getSelection());
        settings.put(DS_UI_THREAD, this.uiThread.getSelection());
    }

    protected void initDialogSettings(IDialogSettings settings) {
        if (settings.get(DS_USE_LOCAL) == null) {
            settings.put(DS_USE_LOCAL, true);
        }
        if (settings.get(DS_HOSTNAME) == null) {
            settings.put(DS_HOSTNAME, "");
        }
        if (settings.get(DS_ECLIPSE_DIR) == null) {
            settings.put(DS_ECLIPSE_DIR, "");
        }
        if (settings.get(DS_ALLOW_REUSE) == null) {
            settings.put(DS_ALLOW_REUSE, false);
        }
        if (settings.get(DS_HEADLESS) == null) {
            settings.put(DS_HEADLESS, false);
        }
        if (settings.get(DS_UI_THREAD) == null) {
            settings.put(DS_UI_THREAD, false);
        }
    }

    protected Control createLocationDetailsPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int numColumns = 2;
        GridLayout layout = new GridLayout(numColumns, false);
        composite.setLayout((Layout)layout);
        this.local = new Button(composite, 16);
        this.local.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_LOCALHOST);
        GridData gridData = new GridData(1, 1, false, false, numColumns, 1);
        this.local.setLayoutData((Object)gridData);
        this.addSpacer(composite, 1);
        this.localLabel = new Link(composite, 64);
        this.localLabel.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_TARGET_PLATFORM_LINK);
        this.localLabel.setLayoutData((Object)new GridData(1, 1, false, true, numColumns - 1, 1));
        this.localLabel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkbenchLocationDetailsPage.this.linkActivated(e.item);
            }

            public void widgetSelected(SelectionEvent e) {
                WorkbenchLocationDetailsPage.this.linkActivated(e.widget);
            }
        });
        this.remote = new Button(composite, 16);
        this.remote.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_REMOTE_HOST);
        gridData = new GridData(1, 1, false, false, numColumns, 1);
        gridData.verticalIndent = 10;
        this.remote.setLayoutData((Object)gridData);
        this.remote.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WorkbenchLocationDetailsPage.this.enableHostControls(!WorkbenchLocationDetailsPage.this.remote.getSelection());
                WorkbenchLocationDetailsPage.this.validatePage();
            }
        });
        this.addSpacer(composite, 1);
        Control control = this.createRemoteLocationDetails(composite);
        control.setLayoutData((Object)new GridData(4, 1, true, false));
        return composite;
    }

    protected void linkActivated(Widget w) {
        if (w == this.localLabel) {
            String targetPlatformPageId = "org.eclipse.pde.ui.TargetPlatformPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)targetPlatformPageId, (String[])new String[]{targetPlatformPageId}, null).open();
        }
    }

    protected Control createRemoteLocationDetails(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int numColumns = 2;
        GridLayout layout = new GridLayout(numColumns, false);
        composite.setLayout((Layout)layout);
        this.hostLabel = new Label(composite, 0);
        this.hostLabel.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_HOSTNAME_ADDRESS);
        this.hostname = new Text(composite, 2048);
        this.hostname.setLayoutData((Object)new GridData(4, 1, true, false));
        this.hostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkbenchLocationDetailsPage.this.validatePage();
            }
        });
        this.eclipseLabel = new Label(composite, 0);
        this.eclipseLabel.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_ECLIPSE_DIRECTORY);
        this.eclipseDir = new Text(composite, 2048);
        this.eclipseDir.setLayoutData((Object)new GridData(4, 1, true, false));
        this.eclipseDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkbenchLocationDetailsPage.this.validatePage();
            }
        });
        return composite;
    }

    protected Control createOptionsPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int numColumns = 1;
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        this.allowReuse = new Button(composite, 32);
        this.allowReuse.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_ALLOW_REUSE);
        this.allowReuse.setLayoutData((Object)new GridData(1, 1, false, false, numColumns, 1));
        this.headless = new Button(composite, 32);
        this.headless.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_HEADLESS);
        this.headless.setLayoutData((Object)new GridData(1, 1, false, false, numColumns, 1));
        this.headless.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkbenchLocationDetailsPage.this.headless.setSelection(false);
            }

            public void widgetSelected(SelectionEvent e) {
                WorkbenchLocationDetailsPage.this.uiThread.setEnabled(!WorkbenchLocationDetailsPage.this.headless.getSelection());
            }
        });
        this.uiThread = new Button(composite, 32);
        this.uiThread.setText(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_UI_THREAD);
        this.uiThread.setLayoutData((Object)new GridData(1, 1, false, false, numColumns, 1));
        return composite;
    }

    public String getHostName() {
        if (this.local.getSelection()) {
            return null;
        }
        return this.hostname.getText();
    }

    public String getEclipseDirectory() {
        if (this.local.getSelection()) {
            return null;
        }
        return this.eclipseDir.getText();
    }

    public boolean getAllowReuse() {
        return this.allowReuse.getSelection();
    }

    public boolean getHeadless() {
        return this.headless.getSelection();
    }

    public boolean getUiThread() {
        return this.uiThread.getSelection();
    }

    protected void validatePage() {
        if (this.remote.getSelection()) {
            if ("".equals(this.hostname.getText().trim())) {
                this.setErrorMessage(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_MISSING_HOSTNAME);
                this.setPageComplete(false);
                return;
            }
            if ("".equals(this.eclipseDir.getText().trim())) {
                this.setErrorMessage(PluginMessages.WORKBENCH_DETAILS_WIZPAGE_MISSING_DIRECTORY);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

