/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.plugin.internal.junit.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.LocationUtil;
import org.eclipse.hyades.test.tools.core.internal.plugin.util.WorkbenchLocationUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.plugin.internal.PluginMessages;
import org.eclipse.hyades.test.tools.ui.plugin.internal.TestPluginImages;
import org.eclipse.hyades.test.tools.ui.plugin.internal.junit.wizard.WorkbenchLocationDetailsPage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.wizard.LocationNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;

public class WorkbenchLocationNewWizard
extends LocationNewWizard {
    private WorkbenchLocationDetailsPage detailsPage;

    public WorkbenchLocationNewWizard() {
        this.setWindowTitle(PluginMessages.WORKBENCH_LOCATION_NEW_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(TestPluginImages.INSTANCE.getImageDescriptor("new_workbenchlocation_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("WorkbenchLocationNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("WorkbenchLocationNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected boolean createObject(IFile file) throws Exception {
        String hostname = this.getWorkbenchDetailsPage().getHostName();
        if (hostname == null) {
            hostname = UiPlugin.getInstance().getRAServerHost();
        }
        Resource res = LocationUtil.createResource((IFile)file);
        CFGMachineConstraint location = (CFGMachineConstraint)LocationUtil.createLocation((String)this.getLocationPage().getItemName(), (String)this.getAttributeWizardPage().getItemDescription(), (String)hostname);
        CFGPropertyGroup workbenchPropertyGroup = WorkbenchLocationUtil.createWorkbenchPropertyGroup();
        String eclipseDir = this.getWorkbenchDetailsPage().getEclipseDirectory();
        if (eclipseDir != null) {
            WorkbenchLocationUtil.setEclipseLocation((CFGPropertyGroup)workbenchPropertyGroup, (String)eclipseDir);
        }
        WorkbenchLocationUtil.setAllowReuse((CFGPropertyGroup)workbenchPropertyGroup, (boolean)this.getWorkbenchDetailsPage().getAllowReuse());
        WorkbenchLocationUtil.setHeadless((CFGPropertyGroup)workbenchPropertyGroup, (boolean)this.getWorkbenchDetailsPage().getHeadless());
        WorkbenchLocationUtil.setRunInUIThread((CFGPropertyGroup)workbenchPropertyGroup, (boolean)this.getWorkbenchDetailsPage().getUiThread());
        location.getPropertyGroups().add((Object)workbenchPropertyGroup);
        res.getContents().add((Object)location);
        EMFUtil.save((Resource)res);
        return true;
    }

    protected WorkbenchLocationDetailsPage getWorkbenchDetailsPage() {
        return this.detailsPage;
    }

    public void addPages() {
        super.addPages();
        this.getLocationPage().setTitle(PluginMessages.WORKBENCH_LOCATION_NEW_WIZARD_TITLE);
    }

    protected void addLocationDetailsPage() {
        this.detailsPage = new WorkbenchLocationDetailsPage(this.getDialogSettings());
        this.addPage((IWizardPage)this.detailsPage);
    }

    public boolean performFinish() {
        this.getWorkbenchDetailsPage().saveDialogSettings();
        return super.performFinish();
    }
}

