/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.util.TraceAssociationMapping;
import org.eclipse.hyades.ui.internal.util.FileUtil;

public class EMFUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();

    public EMFUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void save(Resource resource) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        boolean isModified = resource.isModified();
        try {
            resource.save(RESOURCE_OPTIONS);
        }
        catch (Exception e) {
            resource.setModified(isModified);
            throw e;
        }
    }

    public static EObject getEObject(ResourceSet resourceSet, EObject eObject, boolean load) {
        if (resourceSet == null || eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resourceSet.equals(resource.getResourceSet())) {
            return eObject;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if ((resource = resourceSet.getResource(resource.getURI(), load)) == null) {
            return null;
        }
        eObject = resource.getEObject(uriFragment);
        if (eObject == null) {
            return null;
        }
        return eObject;
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, IFile file) {
        if (file == null) {
            return new EObject[0];
        }
        return EMFUtil.getEObjects(resourceSet, file.getFullPath().toString());
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, String fullPath) {
        if (resourceSet == null && fullPath == null) {
            return new EObject[0];
        }
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath), false);
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static EObject[] load(ResourceSet resourceSet, IFile file) {
        if (file == null) {
            return new EObject[0];
        }
        return EMFUtil.load(resourceSet, file.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet resourceSet, String fullPath) {
        if (fullPath == null) {
            return new EObject[0];
        }
        URI uri = URI.createPlatformResourceURI((String)fullPath);
        Resource resource = null;
        try {
            if (resourceSet != null) {
                resource = resourceSet.getResource(uri, true);
            } else {
                Resource.Factory factory = EMFUtil.getResourceFactory(FileUtil.getFileExtension((String)fullPath));
                if (factory != null) {
                    resource = factory.createResource(uri);
                    resource.load(RESOURCE_OPTIONS);
                }
            }
        }
        catch (Exception exception) {}
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String fileExtension) {
        Resource.Factory factory;
        if (fileExtension != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get("*");
    }

    public static IFile getWorkspaceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return EMFUtil.getWorkspaceFile(eObject.eResource());
    }

    public static IFile getWorkspaceFile(Resource resource) {
        String filePath = EMFUtil.getWorkspaceFilePath(resource);
        if (filePath == null) {
            return null;
        }
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
        if (workspaceResource == null || workspaceResource.getType() != 1) {
            return null;
        }
        return (IFile)workspaceResource;
    }

    public static String getWorkspaceFilePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String uriToString = resource.getURI().toString();
        if (!uriToString.startsWith("platform:/resource")) {
            return null;
        }
        return uriToString.substring("platform:/resource".length());
    }

    public static Resource getResource(ResourceSet resourceSet, IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        if (resourceSet != null) {
            return resourceSet.getResource(uri, false);
        }
        Resource.Factory factory = EMFUtil.getResourceFactory(file.getFileExtension());
        if (factory != null) {
            return factory.createResource(uri);
        }
        return null;
    }

    public static EObject reload(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return eObject;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if (resource.isLoaded()) {
            resource.unload();
        }
        try {
            resource.load(RESOURCE_OPTIONS);
        }
        catch (IOException iOException) {
            return null;
        }
        return resource.getEObject(uriFragment);
    }

    public static Resource[] remove(EObject eObject) {
        if (eObject == null) {
            return new Resource[0];
        }
        if (eObject.eResource() == null) {
            EcoreUtil.remove((EObject)eObject);
            return new Resource[0];
        }
        Resource resource = eObject.eResource();
        Set changedResources = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((EObject)eObject, (ResourceSet)resource.getResourceSet());
        changedResources.add(resource);
        if (eObject.eContainer() != null) {
            EcoreUtil.remove((EObject)eObject);
        }
        return changedResources.toArray(new Resource[changedResources.size()]);
    }

    public static Resource[] remove(Resource resource) {
        if (resource == null) {
            return new Resource[0];
        }
        Set changedResources = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((Resource)resource);
        return changedResources.toArray(new Resource[changedResources.size()]);
    }

    public static void addAdapter(Iterator objectIterator, Adapter adapter) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().add((Object)adapter);
        }
    }

    public static void removeAdapter(Iterator objectIterator, Adapter adapter) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().remove((Object)adapter);
        }
    }

    public static void removeAdapters(Iterator objectIterator) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().clear();
        }
    }

    public static Resource[] getResources(IPath fullPath, ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        int maxj = resources.size();
        Resource res = null;
        String path = "";
        ArrayList<Resource> result = new ArrayList<Resource>();
        int j = 0;
        while (j < maxj) {
            res = (Resource)resources.get(j);
            if (res != null && (path = EMFUtil.getWorkspaceFilePath(res)) != null && fullPath.isPrefixOf((IPath)new Path(path))) {
                result.add(res);
            }
            ++j;
        }
        return result.toArray(new Resource[result.size()]);
    }

    public static EObject[] loadMonitorsFromResourceSet(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        int size = resources.size();
        EObject[] eObjects = new EObject[size];
        int i = 0;
        int idx = 0;
        while (idx < size) {
            Resource res = (Resource)resources.get(idx);
            EList ext = res.getContents();
            Iterator iter = ext.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TRCMonitor)) continue;
                eObjects[i++] = (TRCMonitor)obj;
            }
            ++idx;
        }
        return eObjects;
    }

    public static List getLogAgentsFromResourceSet(ResourceSet resourceSet) {
        EObject[] monitors = EMFUtil.loadMonitorsFromResourceSet(resourceSet);
        ArrayList agents = new ArrayList();
        EList nodes = null;
        int i = 0;
        while (i < monitors.length) {
            if (monitors[i] != null) {
                nodes = ((TRCMonitor)monitors[i]).getNodes();
                Iterator iter = nodes.iterator();
                while (iter.hasNext()) {
                    TRCNode element = (TRCNode)iter.next();
                    agents.addAll(EMFUtil.getLogAgentsFromNode(element));
                }
            }
            ++i;
        }
        return agents;
    }

    public static List getLogAgentsFromNode(TRCNode node) {
        ArrayList<TRCAgentProxy> agents = new ArrayList<TRCAgentProxy>();
        Iterator l = node.getProcessProxies().iterator();
        while (l.hasNext()) {
            Iterator m = ((TRCProcessProxy)l.next()).getAgentProxies().iterator();
            while (m.hasNext()) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)m.next();
                if (!"Logging".equals(agentProxy.getType()) && !TraceAssociationMapping.getDefault().isViewForType("org.eclipse.tptp.platform.log.views.internal.views.LogViewer", agentProxy.getType())) continue;
                agents.add(agentProxy);
            }
        }
        return agents;
    }
}

