/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.navigator.DistributedLayout;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogContentProvider
extends PDContentProvider
implements IDisposable {
    public static final String SD_FILE_EXTENSION = "trcdbxmi";
    public static final String SYMPTOM_FILE_EXTENSION = "symptom";
    public static final String CORR_FILE_EXTENSION = "corrxmi";
    private TreeViewer treeViewer;
    private LogicalFolder logFolder;
    private LogicalFolder sdFolder;
    private LogicalFolder corrFolder;
    private boolean filesLoaded = false;

    public LogContentProvider(Navigator navigator) {
        super(navigator);
    }

    public void dispose() {
        if (this.logFolder != null) {
            this.logFolder.dispose();
        }
        if (this.sdFolder != null) {
            this.sdFolder.dispose();
        }
        this.treeViewer = null;
    }

    public ResourceSet getResourceSet() {
        return HierarchyResourceSetImpl.getInstance();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void loadFiles() {
        String[] extensions = new String[]{SD_FILE_EXTENSION, SYMPTOM_FILE_EXTENSION, "trcmxmi"};
        Map filesByExtension = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])extensions, null);
        this.getSDFolder().getChildren().addAll((List)filesByExtension.get(SD_FILE_EXTENSION));
        this.getSDFolder().getChildren().addAll((List)filesByExtension.get(SYMPTOM_FILE_EXTENSION));
        EObject[] resourceSetObj = EMFUtil.loadMonitorsFromResourceSet(this.getResourceSet());
        this.loadIntoFolders(resourceSetObj);
        Iterator i = ((List)filesByExtension.get("trcmxmi")).iterator();
        while (i.hasNext()) {
            EObject[] eObjects = EMFUtil.load(this.getResourceSet(), (IFile)i.next());
            this.loadIntoFolders(eObjects);
        }
        this.filesLoaded = true;
    }

    private void loadIntoFolders(EObject[] eObjects) {
        int j = 0;
        int maxj = eObjects.length;
        while (j < maxj) {
            if (eObjects[j] instanceof TRCMonitor) {
                this.getCorrelationFolder().getChildren().addAll(((TRCMonitor)eObjects[j]).getCorrelationContainerProxies());
                Iterator k = ((TRCMonitor)eObjects[j]).getNodes().iterator();
                while (k.hasNext()) {
                    TRCNode node = (TRCNode)k.next();
                    this.getLogFolder().getChildren().add(node);
                }
            }
            ++j;
        }
    }

    public void refreshFromLocal() {
        this.filesLoaded = false;
        this.clearFolders();
        this.getTreeViewer().refresh();
    }

    public LogicalFolder getLogFolder() {
        if (this.logFolder == null) {
            this.logFolder = new LogicalFolder(LogMessages.LOGN_FLD){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.logFolder;
    }

    public LogicalFolder getSDFolder() {
        if (this.sdFolder == null) {
            this.sdFolder = new LogicalFolder(LogMessages.LOGN_SDFLD){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.sdFolder;
    }

    public LogicalFolder getCorrelationFolder() {
        if (this.corrFolder == null) {
            this.corrFolder = new LogicalFolder(LogMessages.LOGN_CORFLD){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.corrFolder;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer && this.treeViewer != viewer) {
            this.filesLoaded = false;
            this.clearFolders();
            this.loadFiles();
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Object getParent(Object element) {
        if (this.fViewer.getLayout() instanceof DistributedLayout) {
            if (element instanceof TRCAgentProxy) {
                return ((TRCAgentProxy)element).getProcessProxy().getNode();
            }
            if (element instanceof TRCNode) {
                return ((TRCNode)element).getMonitor();
            }
            return null;
        }
        if (element instanceof TRCAgentProxy) {
            return this.getLogFolder();
        }
        if (element instanceof CorrelationContainerProxy) {
            return this.getCorrelationFolder();
        }
        if (element instanceof IFile && (SD_FILE_EXTENSION.equals(((IFile)element).getFileExtension()) || SYMPTOM_FILE_EXTENSION.equals(((IFile)element).getFileExtension()))) {
            return this.getSDFolder();
        }
        if (element instanceof LogicalFolder) {
            return ((LogicalFolder)element).getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.fViewer.getLayout() instanceof DistributedLayout) {
            return super.getElements(inputElement);
        }
        ArrayList<LogicalFolder> list = new ArrayList<LogicalFolder>();
        list.add(this.getLogFolder());
        list.add(this.getSDFolder());
        list.add(this.getCorrelationFolder());
        list.addAll(NavigatorExtensionUtil.getAllChildren((Object)inputElement, (String)this.fViewer.getID()));
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TRCAgentProxy) {
            return false;
        }
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)this.fViewer.getID())) {
            return true;
        }
        if (element instanceof LogicalFolder) {
            if (!this.filesLoaded) {
                this.loadFiles();
            }
            return !((LogicalFolder)element).getChildren().isEmpty();
        }
        if (element instanceof CorrelationContainerProxy) {
            return ((CorrelationContainerProxy)element).getCorrelatedAgents().size() > 0;
        }
        if (element instanceof TRCNode) {
            return EMFUtil.getLogAgentsFromNode((TRCNode)element).size() > 0;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList list = new ArrayList();
        Object[] objArray = null;
        if (parentElement == this.getLogFolder()) {
            this.getLogFolder().getChildren().clear();
            this.getLogFolder().getChildren().addAll(this.getLogsFromResourceSet());
            list.addAll(this.getLogFolder().getChildren());
            objArray = list.toArray();
        } else if (parentElement instanceof LogicalFolder) {
            list.addAll(((LogicalFolder)parentElement).getChildren());
            objArray = list.toArray();
        } else if (parentElement instanceof CorrelationContainerProxy) {
            list.addAll(((CorrelationContainerProxy)parentElement).getCorrelatedAgents());
            objArray = list.toArray();
        } else if (parentElement instanceof IProject) {
            objArray = this.getContainerMonitors((IContainer)((IProject)parentElement));
        } else if (parentElement instanceof IFolder) {
            objArray = this.getContainerMonitors((IContainer)((IFolder)parentElement));
        } else if (parentElement instanceof TRCMonitor) {
            objArray = this.getMonitorChildren((TRCMonitor)parentElement);
        } else if (parentElement instanceof TRCNode) {
            list.addAll(EMFUtil.getLogAgentsFromNode((TRCNode)parentElement));
            objArray = list.toArray();
        }
        if (objArray == null) {
            objArray = new Object[]{};
        }
        Object[] delegates = NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)this.fViewer.getID()).toArray();
        Object[] finalList = new Object[objArray.length + delegates.length];
        System.arraycopy(objArray, 0, finalList, 0, objArray.length);
        System.arraycopy(delegates, 0, finalList, objArray.length, delegates.length);
        return finalList;
    }

    private void clearFolders() {
        if (this.logFolder != null) {
            this.logFolder.getChildren().clear();
        }
        if (this.sdFolder != null) {
            this.sdFolder.getChildren().clear();
        }
        if (this.corrFolder != null) {
            this.corrFolder.getChildren().clear();
        }
    }

    protected ArrayList getContainerMonitors0(IContainer res) {
        ArrayList list = super.getContainerMonitors0(res);
        try {
            IResource[] members = res.members();
            int idx = 0;
            while (idx < members.length) {
                IResource member = members[idx];
                if (member != null && member.exists() && member instanceof IFile && member.getFileExtension() != null && (member.getFileExtension().equals(SD_FILE_EXTENSION) || member.getFileExtension().equals(SYMPTOM_FILE_EXTENSION))) {
                    list.add(member);
                }
                ++idx;
            }
        }
        catch (CoreException exc) {
            UIPlugin.getDefault().log(exc);
        }
        return list;
    }

    protected ArrayList getContainerMonitorsArray(IContainer res) {
        return this.getContainerMonitors0(res);
    }

    protected ArrayList getMonitorChildren0(TRCMonitor monitor) {
        ArrayList list = super.getMonitorChildren0(monitor);
        try {
            Iterator i = monitor.getCorrelationContainerProxies().iterator();
            while (i.hasNext()) {
                CorrelationContainerProxy corr = (CorrelationContainerProxy)i.next();
                if (corr.eIsProxy()) continue;
                list.add(corr);
            }
        }
        catch (Exception exception) {
            return list;
        }
        return list;
    }

    private List getLogsFromResourceSet() {
        EList resources = this.getResourceSet().getResources();
        int size = resources.size();
        ArrayList logs = new ArrayList();
        int idx = 0;
        while (idx < size) {
            Resource res = (Resource)resources.get(idx);
            EList ext = res.getContents();
            Iterator iter = ext.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TRCMonitor)) continue;
                Iterator iterator = ((TRCMonitor)obj).getNodes().iterator();
                while (iterator.hasNext()) {
                    TRCNode node = (TRCNode)iterator.next();
                    logs.addAll(EMFUtil.getLogAgentsFromNode(node));
                }
            }
            ++idx;
        }
        return logs;
    }
}

