/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ImageOverlayIcon;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LogLabelProvider
extends LabelProvider
implements ILabelDecorator {
    private Image fMonitor = PDPluginImages.getImage("monitor_obj.gif");
    private Image fNode = PDPluginImages.getImage("node_obj.gif");
    private Map images = new Hashtable();
    static /* synthetic */ Class class$0;

    public void dispose() {
        super.dispose();
        Iterator iter = this.images.values().iterator();
        while (iter.hasNext()) {
            Image element = (Image)iter.next();
            if (element.isDisposed()) continue;
            element.dispose();
        }
        this.images.clear();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof LogicalFolder) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof TRCAgentProxy) {
            if (((TRCAgentProxy)element).isActive()) {
                return LogUIPluginImages.getImage("livelog_obj.gif");
            }
            if (!((TRCAgentProxy)element).isActive()) {
                return LogUIPluginImages.getImage("default_log_obj.gif");
            }
        }
        if (element instanceof CorrelationContainerProxy) {
            return LogUIPluginImages.getImage("correlation_obj.gif");
        }
        if (element instanceof IResource) {
            IWorkbenchAdapter workbenchAdapter;
            IResource iResource = (IResource)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workbenchAdapter = (IWorkbenchAdapter)iResource.getAdapter((Class)clazz)) != null) {
                return workbenchAdapter.getImageDescriptor(element).createImage();
            }
        } else {
            if (element instanceof TRCMonitor) {
                return this.fMonitor;
            }
            if (element instanceof TRCNode) {
                return this.fNode;
            }
        }
        if (element instanceof INavigatorItem) {
            return ((INavigatorItem)element).getImage();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getText(Object element) {
        String label;
        block19: {
            block23: {
                String file;
                block25: {
                    block24: {
                        block22: {
                            block21: {
                                block20: {
                                    block18: {
                                        label = null;
                                        if (!(element instanceof IAdaptable)) break block18;
                                        IAdaptable iAdaptable = (IAdaptable)element;
                                        Class<?> clazz = class$0;
                                        if (clazz == null) {
                                            Class<?> clazz2;
                                            try {
                                                clazz2 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            clazz = class$0 = clazz2;
                                        }
                                        if (iAdaptable.getAdapter((Class)clazz) == null) break block18;
                                        IAdaptable iAdaptable2 = (IAdaptable)element;
                                        Class<?> clazz3 = class$0;
                                        if (clazz3 == null) {
                                            Class<?> clazz4;
                                            try {
                                                clazz4 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            clazz3 = class$0 = clazz4;
                                        }
                                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz3);
                                        label = adapter.getLabel(element);
                                        break block19;
                                    }
                                    if (!(element instanceof LogicalFolder)) break block20;
                                    label = ((LogicalFolder)element).getName();
                                    break block19;
                                }
                                if (!(element instanceof TRCMonitor)) break block21;
                                label = ((TRCMonitor)element).getName();
                                break block19;
                            }
                            if (!(element instanceof TRCNode)) break block22;
                            label = ((TRCNode)element).getName();
                            break block19;
                        }
                        if (!(element instanceof TRCAgentProxy)) break block23;
                        TRCAgentProxy agentProxy = (TRCAgentProxy)element;
                        file = agentProxy.getProfileFile();
                        String aname = agentProxy.getName();
                        if (file == null || file.length() == 0) {
                            if (UIPlugin.getDefault().getPreferenceStore().getBoolean("hyde_logtype")) {
                                file = HyadesUtil.resolveLogAgentDisplayName(aname);
                            } else {
                                StringBuffer buffer = new StringBuffer(HyadesUtil.resolveLogAgentType(aname));
                                buffer.append(" ").append(HyadesUtil.resolveLogAgentDisplayName(aname));
                                file = buffer.toString();
                            }
                        }
                        if (file == null || file.length() == 0) {
                            label = "";
                        }
                        if (agentProxy.getProcessProxy() == null || agentProxy.getProcessProxy().getNode() == null) break block24;
                        String node = agentProxy.getProcessProxy().getNode().getName();
                        if (node != null) {
                            label = file;
                            if (UIPlugin.getDefault().getPreferenceStore().getInt("logn_layout") == 0) {
                                label = NLS.bind((String)LogMessages.LOG_NAV_LOGLBLFMT, (Object[])new String[]{node, file});
                            }
                            if (((TRCAgentProxy)element).isActive()) {
                                label = "<" + LogMessages.STR_LIVE_LOG + "> " + label;
                            }
                        }
                        break block25;
                    }
                    label = LogMessages.LOG_REMOVED;
                }
                label = file;
                break block19;
            }
            if (element instanceof CorrelationContainerProxy) {
                label = ((CorrelationContainerProxy)element).getName();
            } else if (element instanceof IFile) {
                label = ((IFile)element).getFullPath().toString();
            } else if (element instanceof INavigatorItem) {
                label = ((INavigatorItem)element).getText();
            }
        }
        if (label != null) return label;
        return "?";
    }

    public Image decorateImage(Image image, Object element) {
        if (element instanceof TRCAgentProxy && !this.isXMI((EObject)((TRCAgentProxy)element))) {
            return this.getImage(image, LogUIPluginImages.getImageDescriptor("db_resource_ovr.gif"));
        }
        if (element instanceof CorrelationContainerProxy && !this.isXMI((EObject)((CorrelationContainerProxy)element))) {
            return this.getImage(image, LogUIPluginImages.getImageDescriptor("db_resource_ovr.gif"));
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    private boolean isXMI(EObject input) {
        if (input instanceof TRCAgentProxy) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)input;
            TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent == null) {
                return true;
            }
            if (EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                return true;
            }
        } else if (input instanceof CorrelationContainerProxy && !LoadersUtils.getPostfix((URI)EcoreUtil.getURI((EObject)((EObject)input.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false)))).endsWith("corrdb")) {
            return true;
        }
        return false;
    }

    private Image getImage(Image srcImage, ImageDescriptor ovrImage) {
        String key2;
        String key1 = String.valueOf(srcImage.hashCode());
        Image image = (Image)this.images.get(key1.concat(key2 = String.valueOf(ovrImage.hashCode())));
        if (image == null) {
            ImageOverlayIcon overDesc = new ImageOverlayIcon(srcImage, new ImageDescriptor[][]{{ovrImage}, new ImageDescriptor[0], new ImageDescriptor[0], new ImageDescriptor[0]});
            image = overDesc.createImage();
            this.images.put(key1.concat(key2), image);
        }
        return image;
    }
}

