/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.log.ui.internal.actions.SaveAction;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.navigator.NewActionGroup;
import org.eclipse.hyades.log.ui.internal.wizards.EditCorrelationWizard;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.EditCorrAction;
import org.eclipse.hyades.trace.ui.internal.actions.ToggleHidingAction;
import org.eclipse.hyades.trace.ui.internal.actions.TraceLogActionGroup;
import org.eclipse.hyades.trace.ui.internal.navigator.DistributedLayout;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.action.LayoutAction;
import org.eclipse.hyades.ui.internal.extension.INavigatorLayout;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenFileAction;

public class LogNavigatorActionGroup
extends TraceLogActionGroup {
    private OpenFileAction fOpenFileAction;
    private NewActionGroup newActionGroup;
    private SaveAction fLogNavigatorSaveAction;
    private EditCorrAction openEditCorrelationWizardAction;
    private ToggleHidingAction toggleHidingAction;
    protected LayoutAction fFlatLayout;
    protected LayoutAction fHierarchicalLayout;

    public LogNavigatorActionGroup(LogNavigator logNavigator) {
        super((INavigator)logNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.newActionGroup = null;
        this.fOpenFileAction = null;
        this.fFlatLayout = null;
        this.fHierarchicalLayout = null;
        super.dispose();
    }

    public void setContext(ActionContext context) {
        if (this.newActionGroup != null) {
            this.newActionGroup.setContext(context);
        }
        super.setContext(context);
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean multiSelection;
        super.fillContextMenu(menu);
        this.newActionGroup.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean sameClass = false;
        boolean bl = multiSelection = selection.size() > 1;
        if (multiSelection) {
            sameClass = this.areSameClass(selection);
        }
        Object sel = null;
        if (selection.iterator().hasNext()) {
            sel = selection.iterator().next();
        }
        this.updateActions(selection);
        if (sel != null) {
            if (sel instanceof LogicalFolder) {
                if (!multiSelection && ((LogicalFolder)sel).hasChildren()) {
                    menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
                }
                if (multiSelection) {
                    Object sel2 = null;
                    boolean ifAppendSaveAction = false;
                    Iterator i = selection.iterator();
                    while (i.hasNext()) {
                        sel2 = i.next();
                        if (!(sel2 instanceof LogicalFolder) || !((LogicalFolder)sel2).hasChildren()) continue;
                        ifAppendSaveAction = true;
                        break;
                    }
                    if (ifAppendSaveAction) {
                        menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
                    }
                }
            } else if (sel instanceof TRCAgentProxy) {
                if (!multiSelection || sameClass) {
                    menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
                }
                if (!multiSelection) {
                    menu.appendToGroup("group.additions", (IContributionItem)this.fNewSnapshotGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                    this.addViews(menu, sel);
                }
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof CorrelationContainerProxy) {
                if (!multiSelection) {
                    menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                    this.addViews(menu, sel);
                }
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof IFile) {
                menu.appendToGroup("org.eclipse.ui.OpenWithSubMenu", (IAction)this.fOpenFileAction);
                this.fOpenFileAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof TRCMonitor) {
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.additions", (IContributionItem)this.fRefreshGrp);
            } else if (sel instanceof INavigatorItem) {
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.additions", (IContributionItem)this.fRefreshGrp);
            }
        }
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshLocal);
        if (!multiSelection) {
            if (sel instanceof TRCAgentProxy) {
                if (((TRCAgentProxy)sel).getType().equals("Logging")) {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenLogAgentAction);
                }
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenNodeAction);
            } else if (sel instanceof CorrelationContainerProxy) {
                menu.appendToGroup("group.properties", (IAction)this.openEditCorrelationWizardAction);
            }
        }
        this.fImportActionGroup.fillContextMenu(menu);
    }

    protected void addViews(IMenuManager menu, Object obj) {
        block26: {
            MenuManager popup;
            block29: {
                block28: {
                    block27: {
                        block25: {
                            if (obj == null || !(obj instanceof EObject) && !(obj instanceof INavigatorItem)) {
                                return;
                            }
                            popup = new MenuManager(LogMessages.MENU_MANAGER);
                            menu.appendToGroup("group.add.views", (IContributionItem)popup);
                            if (!(obj instanceof TRCAgentProxy)) break block25;
                            IAction[] actions = this.getViewMappingForType(((TRCAgentProxy)obj).getType());
                            int idx = 0;
                            while (idx < actions.length) {
                                if (actions[idx] != null) {
                                    popup.add(actions[idx]);
                                }
                                ++idx;
                            }
                            break block26;
                        }
                        if (!(obj instanceof CorrelationContainerProxy)) break block27;
                        IAction[] actions = this.getViewMappingForType("Logging");
                        int idx = 0;
                        while (idx < actions.length) {
                            if (actions[idx] != null) {
                                popup.add(actions[idx]);
                            }
                            ++idx;
                        }
                        break block26;
                    }
                    if (!(obj instanceof TRCNode)) break block28;
                    IAction[] actions = this.getViewMappingForType("Host");
                    int idx = 0;
                    while (idx < actions.length) {
                        if (actions[idx] != null) {
                            popup.add(actions[idx]);
                        }
                        ++idx;
                    }
                    ArrayList<String> typesList = new ArrayList<String>();
                    EList processes = ((TRCNode)obj).getProcessProxies();
                    int i = 0;
                    while (i < processes.size()) {
                        TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
                        EList agents = process.getAgentProxies();
                        int j = 0;
                        while (j < agents.size()) {
                            TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                            if (!typesList.contains(agent.getType())) {
                                typesList.add(agent.getType());
                                actions = this.getViewMappingForType(agent.getType());
                                if (actions.length > 0) {
                                    popup.add((IContributionItem)new Separator());
                                    int k = 0;
                                    while (k < actions.length) {
                                        popup.add(actions[k]);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block26;
                }
                if (!(obj instanceof TRCMonitor)) break block29;
                IAction[] actions = this.getViewMappingForType("Monitor");
                int idx = 0;
                while (idx < actions.length) {
                    if (actions[idx] != null) {
                        popup.add(actions[idx]);
                    }
                    ++idx;
                }
                ArrayList<String> typesList = new ArrayList<String>();
                EList nodes = ((TRCMonitor)obj).getNodes();
                if (nodes.size() > 0) {
                    popup.add((IContributionItem)new Separator());
                    actions = this.getViewMappingForType("Host");
                    int idx2 = 0;
                    while (idx2 < actions.length) {
                        if (actions[idx2] != null) {
                            popup.add(actions[idx2]);
                        }
                        ++idx2;
                    }
                }
                int n = 0;
                while (n < nodes.size()) {
                    TRCNode node = (TRCNode)nodes.get(n);
                    EList processes = node.getProcessProxies();
                    int i = 0;
                    while (i < processes.size()) {
                        TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
                        EList agents = process.getAgentProxies();
                        int j = 0;
                        while (j < agents.size()) {
                            TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                            if (!typesList.contains(agent.getType())) {
                                typesList.add(agent.getType());
                                actions = this.getViewMappingForType(agent.getType());
                                if (actions.length > 0) {
                                    popup.add((IContributionItem)new Separator());
                                    int k = 0;
                                    while (k < actions.length) {
                                        popup.add(actions[k]);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    ++n;
                }
                break block26;
            }
            if (!(obj instanceof INavigatorItem)) break block26;
            IAction[] actions = this.getViewMappingForType(((INavigatorItem)obj).getType());
            int idx = 0;
            while (idx < actions.length) {
                if (actions[idx] != null) {
                    popup.add(actions[idx]);
                }
                ++idx;
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.newActionGroup != null) {
            this.newActionGroup.fillActionBars(actionBars);
        }
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.fFlatLayout);
        menu.add((IAction)this.fHierarchicalLayout);
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IAction)this.toggleHidingAction);
        super.fillActionBars(actionBars);
    }

    protected void createActions() {
        super.createActions();
        this.fOpenFileAction = new OpenFileAction(this.getNavigator().getSite().getPage());
        this.fLogNavigatorSaveAction = new SaveAction(this.getNavigator());
        this.openEditCorrelationWizardAction = new EditCorrAction(this.getNavigator());
        INavigatorLayout layout = this.getNavigator().getLayout();
        this.fFlatLayout = new LayoutAction(this.getNavigator(), (INavigatorLayout)new SimpleLayout((Navigator)((LogNavigator)this.getNavigator())), TraceMessages.LY_FLAT, PDPluginImages.DESC_IMG_UI_LAYOUT_FLAT, UIPlugin.getDefault().getPreferenceStore(), "logn_layout", 0);
        this.fFlatLayout.setChecked(layout instanceof SimpleLayout);
        this.fHierarchicalLayout = new LayoutAction(this.getNavigator(), (INavigatorLayout)new DistributedLayout((Navigator)((LogNavigator)this.getNavigator())), TraceMessages.LY_HR, PDPluginImages.DESC_IMG_UI_LAYOUT_HIERARCHICAL, UIPlugin.getDefault().getPreferenceStore(), "logn_layout", 1);
        this.fHierarchicalLayout.setChecked(layout instanceof DistributedLayout);
        this.toggleHidingAction = new ToggleHidingAction(this.getNavigator(), TraceMessages.HDTP);
        this.toggleHidingAction.setToolTipText(TraceMessages.HDTP);
        this.toggleHidingAction.setChecked(UIPlugin.getDefault().getPreferenceStore().getBoolean("hyde_logtype"));
        PDPluginImages.setImageDescriptors((IAction)this.toggleHidingAction, "lcl16", "hidetype.gif");
    }

    protected void createActionGroups() {
        super.createActionGroups();
        this.newActionGroup = new NewActionGroup((Navigator)((LogNavigator)this.getNavigator()));
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        super.handleDoubleClick(event);
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj instanceof IFile) {
            this.fOpenFileAction.selectionChanged(s);
            this.fOpenFileAction.run();
        } else if (obj instanceof CorrelationContainerProxy) {
            EditCorrelationWizard wizard = new EditCorrelationWizard();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            wizard.init(window.getWorkbench(), s);
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            INavigator navigator = HyadesUtil.getActiveNavigator();
            IStructuredSelection selection = navigator.getStructuredSelection();
            this.updateActions(selection);
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof LogicalFolder)) continue;
                this.fDeleteAction.setEnabled(false);
            }
            if (this.fDeleteAction.isEnabled()) {
                this.fDeleteAction.run();
            }
        }
    }
}

