/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.wizards.CorrelationWizard;
import org.eclipse.hyades.log.ui.internal.wizards.EditLogSelectionWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogWizardMessages;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditCorrelationWizard
extends CorrelationWizard {
    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.sel = selection;
        this.sel.isEmpty();
        this.workbench = wb;
    }

    public void addPages() {
        this.setWindowTitle(LogWizardMessages.EDIT_COR_WT);
        super.addPages();
        this.selPage = new EditLogSelectionWizardPage(LogWizardMessages.EDIT_COR_WT, this.sel);
        this.addPage((IWizardPage)this.selPage);
    }

    public boolean performFinish() {
        Object element;
        if (this.sel != null && !this.sel.isEmpty() && (element = this.sel.getFirstElement()) != null && element instanceof CorrelationContainerProxy) {
            this.correlationContainerProxy = (CorrelationContainerProxy)element;
        }
        if (this.correlationContainerProxy != null) {
            this.correlationContainerProxy.setName(this.selPage.getName());
            this.updateCorrelation(this.correlationContainerProxy);
            try {
                IViewPart part;
                IWorkspaceRoot element2;
                IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
                boolean shouldSwitch = false;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", LogWizardMessages.CONFIRM_PSWITCH);
                if (shouldSwitch && page != null && !page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective") && (element2 = ResourcesPlugin.getWorkspace().getRoot()) != null) {
                    page = this.workbench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", this.workbench.getActiveWorkbenchWindow(), (IAdaptable)element2);
                }
                if (page != null && "org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(page.getPerspective().getId()) && (part = page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ((LogNavigator)part).selectReveal((ISelection)new StructuredSelection((Object)EditCorrelationWizard.this.correlationContainerProxy));
                        }
                    });
                }
            }
            catch (Exception e) {
                UIPlugin.getDefault().log(e);
            }
        }
        return true;
    }

    private void updateCorrelation(CorrelationContainerProxy cor) {
        if (cor == null) {
            return;
        }
        Iterator curIterator = cor.getCorrelatedAgents().iterator();
        List list = this.selPage.getLogFiles();
        boolean recorrelate = false;
        if (list.size() != cor.getCorrelatedAgents().size()) {
            recorrelate = true;
        }
        while (!recorrelate && curIterator.hasNext()) {
            TRCAgentProxy agent = (TRCAgentProxy)curIterator.next();
            if (!list.contains(agent)) {
                // empty if block
            }
            recorrelate = true;
        }
        if (recorrelate) {
            CorrelationHelper.getInstance().updateCorrelation(cor, list);
        }
    }
}

