/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.wizards.LogSelectionWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogWizardMessages;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditLogSelectionWizardPage
extends LogSelectionWizardPage {
    protected EditLogSelectionWizardPage(String pageName, IStructuredSelection sel) {
        super(pageName, sel);
        this.setTitle(LogWizardMessages.ELGSEL_PT);
    }

    protected void initializeValues() {
        List source = new ArrayList();
        ArrayList target = new ArrayList();
        source = this.populateLogFilesList();
        this.doubleList.removeAll();
        this.doubleList.initializeSourceList(source);
        this.doubleList.initializeTargetList(target);
        if (this.sel != null && !this.sel.isEmpty()) {
            Object element = this.sel.getFirstElement();
            if (element != null && element instanceof CorrelationContainerProxy) {
                CorrelationContainerProxy cor = (CorrelationContainerProxy)element;
                this.txtName.setText(cor.getName());
                Iterator citer = cor.getCorrelatedAgents().iterator();
                while (citer.hasNext()) {
                    Object obj = citer.next();
                    if (!(obj instanceof TRCAgentProxy)) continue;
                    this.doubleList.getSourceItems().remove(obj);
                    this.doubleList.getTargetItems().add(obj);
                }
            }
            this.doubleList.refreshViews();
            this.txtName.setFocus();
            this.txtName.selectAll();
        }
    }

    protected void loadCorrelationContainerProxyNames(LogContentProvider provider) {
        Object element;
        CorrelationContainerProxy cor = null;
        if (this.sel != null && !this.sel.isEmpty() && (element = this.sel.getFirstElement()) != null && element instanceof CorrelationContainerProxy) {
            cor = (CorrelationContainerProxy)element;
        }
        if (this.existingCorrNames == null) {
            this.existingCorrNames = new HashSet();
        }
        if (provider != null) {
            Object[] correlations = provider.getChildren(provider.getCorrelationFolder());
            int i = 0;
            while (i < correlations.length) {
                CorrelationContainerProxy tmpCor = (CorrelationContainerProxy)correlations[i];
                if (cor != tmpCor) {
                    this.existingCorrNames.add(((CorrelationContainerProxy)correlations[i]).getName().trim());
                }
                ++i;
            }
        }
    }

    protected boolean validateTargetList() {
        int s = this.doubleList.getTargetItems().size();
        if (s == 0) {
            return false;
        }
        Object element = this.sel.getFirstElement();
        String correlationType = null;
        if (element != null && element instanceof CorrelationContainerProxy) {
            correlationType = ((CorrelationContainerProxy)element).getCorrelationEngine().getId();
        }
        if (correlationType == null) {
            return false;
        }
        short val = HyadesUtil.containsMixedResources(this.doubleList.getTargetItems().toArray(new TRCAgentProxy[s]));
        if (correlationType != null && correlationType.equals(LogMessages.COR_NM) && val > -1 && val != 2) {
            this.setErrorMessage(LogMessages.SAME_DB);
            return false;
        }
        if (val == 0) {
            this.setErrorMessage(LogMessages.MIX_LOGT);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

