/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logc.internal.extensions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.logc.extensions.ICorrelationMonitor;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.internal.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.osgi.util.NLS;

public class TimeBasedLogRecordCorrelationEngineImpl
implements ILogRecordCorrelationEngine {
    String correlationName;
    CorrelationEngine correlationEngine;
    CorrelationContainer correlationContainer;
    EMap existingCorrelations;
    int size;

    public void correlate(CorrelationContainerProxy correlationContainerProxy, EList list, ICorrelationMonitor monitor) {
        PerfUtil p = PerfUtil.createInstance((String)"TimeBasedCorrelator", (boolean)false);
        p.setMessageAndStart("timeBasedCorrelator");
        this.correlationEngine = correlationContainerProxy.getCorrelationEngine();
        this.correlationContainer = correlationContainerProxy.getCorrelationContainer();
        if (this.correlationEngine == null) {
            this.correlationName = LogMessages.COR_NM;
            this.correlationEngine.setType(LogMessages.CORR_TP);
            this.correlationEngine.setName(LogMessages.COR_NM);
            this.correlationEngine.setId(LogMessages.COR_NM);
        }
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) != null) {
                EList recordList = ((RecordList)((Object)list.get(i))).getList();
                this.size += recordList.size();
            }
            ++i;
        }
        CBECommonBaseEvent[] mergedArray = new CBECommonBaseEvent[this.size];
        int sl = list.size();
        int sr = 0;
        int index = 0;
        int i2 = 0;
        while (i2 < sl) {
            if (list.get(i2) != null) {
                EList recordList = ((RecordList)((Object)list.get(i2))).getList();
                sr = recordList.size();
                int j = 0;
                while (j < sr) {
                    mergedArray[index++] = (CBECommonBaseEvent)recordList.get(j);
                    ++j;
                }
            }
            ++i2;
        }
        this.existingCorrelations = this.correlationContainer.getCorrelations();
        EList agentProxies = correlationContainerProxy.getCorrelatedAgents();
        Arrays.sort(mergedArray, new Comparator((List)agentProxies){
            private final /* synthetic */ List val$agentProxies;
            {
                this.val$agentProxies = list;
            }

            public int compare(Object o1, Object o2) {
                if (((CBECommonBaseEvent)o1).getAdjustedCreationTime() > ((CBECommonBaseEvent)o2).getAdjustedCreationTime()) {
                    return 1;
                }
                if (((CBECommonBaseEvent)o1).getAdjustedCreationTime() == ((CBECommonBaseEvent)o2).getAdjustedCreationTime()) {
                    if (this.val$agentProxies.indexOf(((CBECommonBaseEvent)o1).getAgent().getAgentProxy()) > this.val$agentProxies.indexOf(((CBECommonBaseEvent)o2).getAgent().getAgentProxy())) {
                        return 1;
                    }
                    if (this.val$agentProxies.indexOf(((CBECommonBaseEvent)o1).getAgent().getAgentProxy()) == this.val$agentProxies.indexOf(((CBECommonBaseEvent)o2).getAgent().getAgentProxy())) {
                        if (((CBECommonBaseEvent)o1).getSequenceNumber() > ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                            return 1;
                        }
                        if (((CBECommonBaseEvent)o1).getSequenceNumber() == ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                            return 0;
                        }
                        return -1;
                    }
                    return -1;
                }
                return -1;
            }
        });
        monitor.beginTask(correlationContainerProxy.getCorrelationEngine().getName(), this.size > 100 ? 100 : this.size);
        String[] msg = new String[]{"0", String.valueOf(this.size)};
        int l = mergedArray.length;
        CBECommonBaseEvent currentEvent = null;
        CBECommonBaseEvent previousEvent = null;
        int step = this.size / 100;
        int startEventBlockIndex = -1;
        int endEventBlockIndex = -1;
        int i3 = 0;
        while (i3 < l) {
            currentEvent = mergedArray[i3];
            if (previousEvent != null && currentEvent != null && previousEvent.getAdjustedCreationTime() == currentEvent.getAdjustedCreationTime()) {
                if (startEventBlockIndex == -1) {
                    startEventBlockIndex = i3 - 1;
                }
            } else {
                endEventBlockIndex = i3;
                if (startEventBlockIndex > -1) {
                    this.createCorrelations(startEventBlockIndex, endEventBlockIndex, mergedArray);
                    startEventBlockIndex = -1;
                }
                previousEvent = currentEvent;
            }
            if (monitor != null) {
                this.updateProgressMonitor(monitor, i3, step, msg);
                if (monitor.isCanceled()) break;
            }
            ++i3;
        }
        if (monitor != null) {
            monitor.done();
        }
        p.stopAndPrintStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCorrelations(int startEventsBlockIndex, int endEventsBlockIndex, CBECommonBaseEvent[] events) {
        BasicEList correlations = null;
        int i = startEventsBlockIndex;
        while (i < endEventsBlockIndex) {
            correlations = new BasicEList();
            int j = i + 1;
            while (j < endEventsBlockIndex) {
                correlations.add(events[j]);
                ++j;
            }
            EMap eMap = this.existingCorrelations;
            synchronized (eMap) {
                this.existingCorrelations.put((Object)events[i], (Object)correlations);
            }
            ++i;
        }
    }

    private void updateProgressMonitor(ICorrelationMonitor m, int index, int step, String[] msg) {
        if (this.size < 100) {
            m.worked(1);
            msg[0] = String.valueOf(index + 1);
            m.subTask(NLS.bind((String)LogMessages.PROC_MSG, (Object[])msg));
        } else if (index % step == 0) {
            if (step == 1) {
                if (index < 99) {
                    m.worked(1);
                } else if (index == this.size - 1) {
                    m.worked(this.size - 99);
                }
            } else {
                m.worked(1);
            }
            msg[0] = String.valueOf(index + 1);
            m.subTask(NLS.bind((String)LogMessages.PROC_MSG, (Object[])msg));
        } else if (index == this.size - 1) {
            m.worked(1);
            msg[0] = String.valueOf(index + 1);
            m.subTask(NLS.bind((String)LogMessages.PROC_MSG, (Object[])msg));
        }
    }
}

