/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logc.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logc.internal.correlators.RecordList;
import org.eclipse.hyades.logc.internal.extensions.ProgressMonitorAdapter;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class CorrelationHelper {
    private static CorrelationHelper instance;
    private List agentsList = new ArrayList();
    private List jobListeners = null;
    private Set correlationsUpdated = null;

    protected CorrelationHelper() {
    }

    public static CorrelationHelper getInstance() {
        if (instance == null) {
            instance = new CorrelationHelper();
        }
        return instance;
    }

    public IExtension[] getCorrelationExtensions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.getPluginId(), "logInteractionView");
        IExtension[] extensions = null;
        if (point != null) {
            extensions = point.getExtensions();
        }
        return extensions;
    }

    public IConfigurationElement getCorrelationByName(String name) {
        IExtension[] extensions = this.getCorrelationExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement elem = elements[j];
                    if ("view".equals(elements[j].getName()) && elements[j].getAttribute("name").equals(name)) {
                        return elem;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public CorrelationContainerProxy createCorrelationContainer(IConfigurationElement correlation, Object inputObject, String name) {
        this.agentsList.clear();
        if (correlation == null) {
            return null;
        }
        if (!(inputObject instanceof TRCAgentProxy[])) {
            this.loadLogAgents(inputObject);
        } else {
            int l = ((TRCAgentProxy[])inputObject).length;
            int i = 0;
            while (i < l) {
                this.agentsList.add(((TRCAgentProxy[])inputObject)[i]);
                ++i;
            }
        }
        BasicEList recordListToCorrelate = new BasicEList();
        String correlationType = null;
        CorrelationContainerProxy correlationContainerProxy = null;
        ILogRecordCorrelationEngine recordCorrelator = null;
        boolean isXMI = true;
        correlationType = correlation.getAttribute("name");
        if (!correlation.getAttribute("name").equals(LogMessages.COR_NM) || !this.isInputSQL(this.agentsList)) {
            IConfigurationElement[] filters_correlators = this.addNodes(correlation, recordListToCorrelate);
            int k = 0;
            while (k < filters_correlators.length) {
                if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine")) {
                    try {
                        recordCorrelator = (ILogRecordCorrelationEngine)filters_correlators[k].createExecutableExtension("class");
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log(e);
                    }
                }
                ++k;
            }
        } else {
            isXMI = false;
        }
        if (this.agentsList.size() > 0 && (isXMI && recordCorrelator != null || !isXMI)) {
            CorrelationJob correlationJob;
            correlationContainerProxy = isXMI ? LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)this.agentsList.get(0)), (String)correlationType, (String)name) : LoadersUtils.getSQLCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)this.agentsList.get(0)), (String)correlationType, (String)name);
            correlationContainerProxy.setName(name);
            CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
            String idAttr = correlation.getAttribute("id");
            if (idAttr == null) {
                correlationEngine.setId(correlationType);
            } else {
                correlationEngine.setId(idAttr);
            }
            correlationEngine.setType(correlation.getAttribute("log_types"));
            correlationEngine.setName(correlation.getAttribute("name"));
            correlationContainerProxy.setCorrelationEngine(correlationEngine);
            int i = 1;
            while (i < this.agentsList.size()) {
                if (this.agentsList.get(i) != null) {
                    correlationContainerProxy.getCorrelatedAgents().add(this.agentsList.get(i));
                }
                ++i;
            }
            if (isXMI) {
                correlationJob = new CorrelationJob(LogMessages.JOB_LBL, recordCorrelator, correlationContainerProxy, (EList)recordListToCorrelate);
            } else {
                TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation((List)this.agentsList);
                query.setCorrelationContainerURI(correlationContainerProxy.getCorrelationContainer().eResource().getURI().toString());
                correlationJob = new DBCorrelationJob(LogMessages.JOB_LBL, (Query)query, correlationContainerProxy);
            }
            if (this.jobListeners != null) {
                int s = this.jobListeners.size();
                int i2 = 0;
                while (i2 < s) {
                    correlationJob.addJobChangeListener((IJobChangeListener)this.jobListeners.get(i2));
                    ++i2;
                }
            }
            correlationJob.schedule();
        }
        return correlationContainerProxy;
    }

    public void addJobChangeListener(IJobChangeListener listener) {
        if (this.jobListeners == null) {
            this.jobListeners = new ArrayList();
        }
        this.jobListeners.add(listener);
    }

    public void removeJobChangeListener(IJobChangeListener listener) {
        if (this.jobListeners != null) {
            this.jobListeners.remove(listener);
        }
    }

    public synchronized void startUpdate(CorrelationContainerProxy ccProxy) {
        this.getCorrelationsUpdated().add(ccProxy);
    }

    public synchronized void endUpdate(CorrelationContainerProxy ccProxy) {
        this.getCorrelationsUpdated().remove(ccProxy);
    }

    public synchronized boolean isCorrelationUpdated(CorrelationContainerProxy ccProxy) {
        return this.getCorrelationsUpdated().contains(ccProxy);
    }

    protected Set getCorrelationsUpdated() {
        if (this.correlationsUpdated == null) {
            this.correlationsUpdated = new HashSet();
        }
        return this.correlationsUpdated;
    }

    public void updateCorrelation(CorrelationContainerProxy correlation, List agentProxies) {
        CorrelationJob correlationJob;
        this.startUpdate(correlation);
        this.agentsList.clear();
        this.agentsList.addAll(agentProxies);
        correlation.getCorrelatedAgents().clear();
        correlation.getCorrelatedAgents().addAll((Collection)this.agentsList);
        ILogRecordCorrelationEngine recordCorrelator = null;
        boolean isXMI = true;
        IConfigurationElement element = this.getCorrelationById(correlation.getCorrelationEngine().getId());
        if (element == null) {
            element = this.getCorrelationByName(correlation.getCorrelationEngine().getName());
        }
        BasicEList recordListToCorrelate = new BasicEList();
        if (!element.getAttribute("name").equals(LogMessages.COR_NM) || !this.isInputSQL(this.agentsList)) {
            IConfigurationElement[] filters_correlators = this.addNodes(element, recordListToCorrelate);
            int k = 0;
            while (k < filters_correlators.length) {
                if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine")) {
                    try {
                        recordCorrelator = (ILogRecordCorrelationEngine)filters_correlators[k].createExecutableExtension("class");
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log(e);
                    }
                }
                ++k;
            }
        } else {
            isXMI = false;
        }
        if (isXMI) {
            correlationJob = new CorrelationJob(LogMessages.JOB_LBL, recordCorrelator, correlation, (EList)recordListToCorrelate);
        } else {
            TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation((List)this.agentsList);
            query.setCorrelationContainerURI(correlation.getCorrelationContainer().eResource().getURI().toString());
            correlationJob = new DBCorrelationJob(LogMessages.JOB_LBL, (Query)query, correlation);
        }
        if (this.jobListeners != null) {
            int s = this.jobListeners.size();
            int i = 0;
            while (i < s) {
                correlationJob.addJobChangeListener((IJobChangeListener)this.jobListeners.get(i));
                ++i;
            }
        }
        correlationJob.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (event.getJob() instanceof CorrelationJob) {
                    CorrelationHelper.this.endUpdate(((CorrelationJob)event.getJob()).getContainer());
                }
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        correlationJob.schedule();
    }

    public void recorrelate(CorrelationContainerProxy correlationContainerProxy) {
        if (correlationContainerProxy.getCorrelatedAgents().size() == 0) {
            return;
        }
        this.startUpdate(correlationContainerProxy);
        this.agentsList.clear();
        this.agentsList.addAll(correlationContainerProxy.getCorrelatedAgents());
        correlationContainerProxy.getCorrelationContainer().setCorrelationContainerProxy(null);
        correlationContainerProxy.setCorrelationContainer(null);
        ILogRecordCorrelationEngine recordCorrelator = null;
        boolean isXMI = true;
        IConfigurationElement element = this.getCorrelationById(correlationContainerProxy.getCorrelationEngine().getId());
        if (element == null) {
            element = this.getCorrelationByName(correlationContainerProxy.getCorrelationEngine().getName());
        }
        String correlationType = element.getAttribute("name");
        BasicEList recordListToCorrelate = new BasicEList();
        if (!element.getAttribute("name").equals(LogMessages.COR_NM) || !this.isInputSQL(this.agentsList)) {
            IConfigurationElement[] filters_correlators = this.addNodes(element, recordListToCorrelate);
            int k = 0;
            while (k < filters_correlators.length) {
                if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine")) {
                    try {
                        recordCorrelator = (ILogRecordCorrelationEngine)filters_correlators[k].createExecutableExtension("class");
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log(e);
                    }
                }
                ++k;
            }
        } else {
            isXMI = false;
        }
        String name = element.getAttribute("name");
        if (this.agentsList.size() > 0) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)this.agentsList.get(0);
            if (isXMI && recordCorrelator != null || !isXMI) {
                CorrelationJob correlationJob;
                CorrelationContainer correlationContainer;
                if (isXMI) {
                    correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
                    correlationContainer.setCorrelationContainerProxy(correlationContainerProxy);
                    LoadersUtils.createCorrelationContainerResource((TRCAgentProxy)agentProxy, (String)correlationType, (CorrelationContainer)correlationContainer, (String)name);
                    correlationContainerProxy.setCreationTime(new Date().getTime());
                    correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
                    agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
                } else {
                    correlationContainerProxy = LoadersUtils.getSQLCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)this.agentsList.get(0)), (String)correlationType, (String)name);
                    correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
                    URI agentURI = EcoreUtil.getURI((EObject)((TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)));
                    String agentPostfix = LoadersUtils.getPostfix((URI)agentURI);
                    URI uri = EcoreUtil.getURI((EObject)agentProxy.getAgent());
                    Properties p = HyadesExtendedResourceFactory.getPropertiesFromURI((URI)uri);
                    String storeType = ((IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)uri.toString()))).getStoreType(LoadersUtils.getPostfix((String)uri.toString()));
                    HyadesResourceExtensions.getInstance().setProperties(storeType, p);
                    String ccPostfix = LoadersUtils.getCorrelationNamePostfix((String)storeType);
                    String ccs = StringUtil.change((String)agentURI.toString(), (String)agentPostfix, (String)("_" + name + "-" + correlationType + ccPostfix));
                    URI correlationContainerResourceURI = SaveUtil.createURI((String)LoadersUtils.getContainerResourceURI((String)ccs));
                    Resource ccr = HierarchyResourceSetImpl.getInstance().createResource(correlationContainerResourceURI);
                    ccr.getContents().add((Object)correlationContainer);
                    correlationContainerProxy.setCorrelationContainer(correlationContainer);
                    correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
                    correlationContainerProxy.setCreationTime(new Date().getTime());
                    correlationContainerProxy.setName(String.valueOf(name) + "_" + correlationType);
                    correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
                    agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
                }
                if (isXMI) {
                    correlationJob = new CorrelationJob(LogMessages.JOB_LBL, recordCorrelator, correlationContainerProxy, (EList)recordListToCorrelate);
                } else {
                    TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation((List)this.agentsList);
                    query.setCorrelationContainerURI(correlationContainerProxy.getCorrelationContainer().eResource().getURI().toString());
                    correlationJob = new DBCorrelationJob(LogMessages.JOB_LBL, (Query)query, correlationContainerProxy);
                }
                if (this.jobListeners != null) {
                    int s = this.jobListeners.size();
                    int i = 0;
                    while (i < s) {
                        correlationJob.addJobChangeListener((IJobChangeListener)this.jobListeners.get(i));
                        ++i;
                    }
                }
                correlationJob.addJobChangeListener(new IJobChangeListener(){

                    public void aboutToRun(IJobChangeEvent event) {
                    }

                    public void awake(IJobChangeEvent event) {
                    }

                    public void done(IJobChangeEvent event) {
                        if (event.getJob() instanceof CorrelationJob) {
                            CorrelationHelper.this.endUpdate(((CorrelationJob)event.getJob()).getContainer());
                        }
                    }

                    public void running(IJobChangeEvent event) {
                    }

                    public void scheduled(IJobChangeEvent event) {
                    }

                    public void sleeping(IJobChangeEvent event) {
                    }
                });
                correlationJob.schedule();
            }
        }
    }

    private IConfigurationElement[] addNodes(IConfigurationElement correlation, BasicEList recordListToCorrelate) {
        IConfigurationElement[] filters_correlators = correlation.getChildren();
        ILogRecordFilter logFilter = null;
        boolean notAdded = true;
        int i = 0;
        while (i < this.agentsList.size()) {
            if (this.agentsList.get(i) != null) {
                int k = 0;
                while (k < filters_correlators.length) {
                    if (filters_correlators[k].getName().equals("LogRecordFilter") && ((TRCAgentProxy)this.agentsList.get(i)).getName().startsWith(filters_correlators[k].getAttribute("log_type"))) {
                        try {
                            logFilter = (ILogRecordFilter)filters_correlators[k].createExecutableExtension("class");
                            recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), logFilter));
                            notAdded = false;
                        }
                        catch (Exception exception) {
                            recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                            notAdded = false;
                        }
                    } else if (((TRCAgentProxy)this.agentsList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type"))) {
                        recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                        notAdded = false;
                    }
                    ++k;
                }
                if (notAdded) {
                    recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                }
            }
            notAdded = true;
            ++i;
        }
        return filters_correlators;
    }

    private RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter) {
        RecordList recList = null;
        recList = logFilter != null ? new RecordList(this.cbeEventFilter(logFilter.filter(agent.getAgent().getDefaultEvents())), agent.getName()) : new RecordList(this.cbeEventFilter(agent.getAgent().getDefaultEvents()), agent.getName());
        return recList;
    }

    private EList cbeEventFilter(EList list) {
        BasicEList filteredList = new BasicEList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (!(event instanceof CBECommonBaseEvent)) continue;
            filteredList.add(event);
        }
        return filteredList;
    }

    private void loadLogAgents(Object object) {
        if (object instanceof List) {
            Object element = null;
            Iterator iter = ((List)object).iterator();
            while (iter.hasNext()) {
                element = iter.next();
                if (!(element instanceof TRCAgentProxy) || !((TRCAgentProxy)element).getType().equals("Logging")) continue;
                this.agentsList.add(element);
            }
        } else if (object instanceof CorrelationContainerProxy) {
            Iterator iter = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator();
            while (iter.hasNext()) {
                TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
                if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
                this.agentsList.add(trcAgentProxy);
            }
            IConfigurationElement correlation = this.getCorrelation(((CorrelationContainerProxy)object).getCorrelationEngine());
            if (correlation != null) {
                this.addNodes(correlation, new BasicEList());
            } else if (this.isInternalCorrelation((CorrelationContainerProxy)object)) {
                this.addAllNodes();
            }
        } else if (object instanceof TRCMonitor) {
            this.loadAllAgents((TRCMonitor)object);
        } else if (object instanceof TRCNode) {
            this.loadAllAgents((TRCNode)object);
        } else if (object instanceof TRCProcessProxy) {
            this.loadAllAgents((TRCProcessProxy)object);
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Logging")) {
            this.agentsList.add((TRCAgentProxy)object);
        }
    }

    private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
        Iterator iter = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iter.hasNext()) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)iter.next();
            if (!agentProxy.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            return true;
        }
        return false;
    }

    private void addAllNodes() {
        int i = 0;
        while (i < this.agentsList.size()) {
            if (this.agentsList.get(i) != null) {
                this.loadLog((TRCAgentProxy)this.agentsList.get(i), null);
            }
            ++i;
        }
    }

    public IConfigurationElement getCorrelation(CorrelationEngine engine) {
        String name = engine.getName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.getPluginId(), "logInteractionView");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement elem = elements[j];
                    if ("view".equals(elements[j].getName()) && elements[j].getAttribute("name").equals(name)) {
                        return elem;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public IConfigurationElement getCorrelationById(String id) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.getPluginId(), "logInteractionView");
        IConfigurationElement element = null;
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("view".equals(elements[j].getName()) && elements[j].getAttribute("id") != null && elements[j].getAttribute("id").equals(id)) {
                        element = elements[j];
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return element;
    }

    private void loadAllAgents(TRCMonitor monitor) {
        if (monitor != null) {
            Iterator nodes = monitor.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                if (node == null) continue;
                this.loadAllAgents(node);
            }
        }
    }

    private void loadAllAgents(TRCNode node) {
        Iterator processProxies = node.getProcessProxies().iterator();
        while (processProxies.hasNext()) {
            TRCProcessProxy processProxy = (TRCProcessProxy)processProxies.next();
            if (processProxy == null) continue;
            this.loadAllAgents(processProxy);
        }
    }

    private void loadAllAgents(TRCProcessProxy processProxy) {
        Iterator agents = processProxy.getAgentProxies().iterator();
        while (agents.hasNext()) {
            TRCAgentProxy trcAgent = (TRCAgentProxy)agents.next();
            if (trcAgent == null || trcAgent.eIsProxy() || !trcAgent.getType().equals("Logging")) continue;
            this.agentsList.add(trcAgent);
        }
    }

    private boolean isInputSQL(List agentProxies) {
        int s = agentProxies.size();
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        if (s == 0) {
            return false;
        }
        int i = 0;
        while (i < s) {
            proxy = (TRCAgentProxy)agentProxies.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent != null && EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public class CorrelationJob
    extends Job {
        private ILogRecordCorrelationEngine recordCorrelator;
        private EList recordListToCorrelate;
        protected CorrelationContainerProxy container;

        CorrelationJob(String name, ILogRecordCorrelationEngine recordCorrelator, CorrelationContainerProxy container, EList recordListToCorrelate) {
            super(name);
            this.recordCorrelator = recordCorrelator;
            this.container = container;
            this.recordListToCorrelate = recordListToCorrelate;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ProgressMonitorAdapter correlationMonitor = new ProgressMonitorAdapter(monitor);
            try {
                this.recordCorrelator.correlate(this.container, this.recordListToCorrelate, correlationMonitor);
                this.saveCorrelationState();
            }
            catch (Exception e) {
                return new Status(4, UIPlugin.getPluginId(), 4, e.getLocalizedMessage(), (Throwable)e);
            }
            return new Status(0, UIPlugin.getPluginId(), 0, "", null);
        }

        public CorrelationContainerProxy getContainer() {
            return this.container;
        }

        private void saveCorrelationState() {
            int s = this.recordListToCorrelate.size();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            RecordList element = null;
            StringBuffer prefString = new StringBuffer();
            int i = 0;
            while (i < s) {
                element = (RecordList)((Object)this.recordListToCorrelate.get(i));
                if (element != null) {
                    EList recordList = element.getList();
                    prefString.append(((CBECommonBaseEvent)recordList.get(recordList.size() - 1)).getGlobalInstanceId());
                }
                prefString.append(";");
                ++i;
            }
            prefString.deleteCharAt(prefString.length() - 1);
            store.setValue(this.container.eResource().getURI().toString(), prefString.toString());
        }
    }

    class DBCorrelationJob
    extends CorrelationJob {
        private Query query;

        DBCorrelationJob(String name, Query query, CorrelationContainerProxy container) {
            super(name, null, null, null);
            this.query = query;
            this.container = container;
        }

        protected IStatus run(IProgressMonitor monitor) {
            new ProgressMonitorAdapter(monitor);
            PerfUtil p = PerfUtil.createInstance((String)"createCorrelation", (boolean)true);
            try {
                LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
            }
            catch (Exception e) {
                return new Status(4, UIPlugin.getPluginId(), 4, e.getLocalizedMessage(), (Throwable)e);
            }
            p.stopAndPrintStatus();
            return new Status(0, UIPlugin.getPluginId(), 0, "", null);
        }
    }
}

