/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PDLabelProvider
extends LabelProvider {
    private Map imageTable;
    private Image fMonitor = PDPluginImages.getImage("monitor_obj.gif");
    private Image fNode = PDPluginImages.getImage("node_obj.gif");
    private Image fProcess = PDPluginImages.getImage("process_obj.gif");
    private Image fMonAgent = PDPluginImages.getImage("agent_mon_obj.gif");
    private Image fRunAgent = PDPluginImages.getImage("agent_run_obj.gif");
    private Image fStopAgent = PDPluginImages.getImage("agent_stop_obj.gif");
    private Image fDetachedAgent = PDPluginImages.getImage("agent_detach_obj.gif");
    static /* synthetic */ Class class$0;

    public void dispose() {
        if (this.imageTable != null) {
            Iterator i = this.imageTable.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageTable = null;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) {
                ImageDescriptor descriptor;
                IAdaptable iAdaptable2 = (IAdaptable)element;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2);
                if (this.imageTable == null) {
                    this.imageTable = new Hashtable(40);
                }
                if ((descriptor = adapter.getImageDescriptor(element)) != null) {
                    Image image = (Image)this.imageTable.get(descriptor);
                    if (image == null) {
                        image = descriptor.createImage();
                        this.imageTable.put(descriptor, image);
                    }
                    return image;
                }
                return null;
            }
        }
        if (element instanceof TRCMonitor) {
            return this.fMonitor;
        }
        if (element instanceof TRCNode) {
            return this.fNode;
        }
        if (element instanceof TRCProcessProxy) {
            return this.fProcess;
        }
        if (element instanceof TRCAgentProxy) {
            if (!((TRCAgentProxy)element).isActive()) {
                return this.fStopAgent;
            }
            if (!((TRCAgentProxy)element).isAttached()) {
                return this.fDetachedAgent;
            }
            if (((TRCAgentProxy)element).isMonitored()) {
                return this.fMonAgent;
            }
            return this.fRunAgent;
        }
        if (element instanceof INavigatorItem) {
            return ((INavigatorItem)element).getImage();
        }
        return null;
    }

    protected String getProcessLabel(TRCProcessProxy process) {
        if (UIPlugin.getDefault().getPreferenceStore().getInt("profiling_monitor_layout") == 0) {
            if (process.getPid() > 0) {
                return NLS.bind((String)TraceMessages.PRC_LNG, (Object[])new Object[]{process.getName() == null || process.getName().length() == 0 ? TraceMessages.UNK : process.getName(), process.getNode().getName(), String.valueOf(process.getPid())});
            }
            return NLS.bind((String)TraceMessages.PRC_LNG_NID, (Object[])new Object[]{process.getName() == null || process.getName().length() == 0 ? TraceMessages.UNK : process.getName(), process.getNode().getName()});
        }
        if (process.getPid() > 0) {
            return NLS.bind((String)TraceMessages.PRC_SHRT, (Object[])new Object[]{process.getName() == null || process.getName().length() == 0 ? TraceMessages.UNK : process.getName(), String.valueOf(process.getPid())});
        }
        return process.getName();
    }

    public String getText(Object element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) {
                IAdaptable iAdaptable2 = (IAdaptable)element;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2);
                return adapter.getLabel(element);
            }
        }
        if (element instanceof TRCMonitor) {
            return ((TRCMonitor)element).getName();
        }
        if (element instanceof TRCNode) {
            return ((TRCNode)element).getName();
        }
        if (element instanceof TRCProcessProxy) {
            return this.getProcessLabel((TRCProcessProxy)element);
        }
        if (element instanceof TRCAgentProxy) {
            TRCAgentProxy a = (TRCAgentProxy)element;
            String status = HyadesUtil.getAgentLabel(a);
            return String.valueOf(status) + " " + HyadesUtil.getAgentName(a);
        }
        if (element instanceof INavigatorItem) {
            return ((INavigatorItem)element).getText();
        }
        return "?";
    }
}

