/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyFactoryImpl;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.TraceSelection;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class TraceUIManager
implements ISelectionChangedListener {
    private static TraceUIManager traceUIManager;
    protected ResourceSet resourceSet;
    protected HierarchyFactory factory;
    protected HashMap fSelectionModel = new HashMap();
    protected ProfileEvent fProfileEvent = new ProfileEvent();
    protected ViewSelectionChangedEvent pdViewEvent = new ViewSelectionChangedEvent();
    protected ProfileEvent updateModelEvent = new ProfileEvent(32);
    protected ProfileEvent refreshViewsEvent = new ProfileEvent(64);
    protected ProfileEvent contextHandlerSelectionChangedEvent = new ProfileEvent(6144);
    protected ListenerList fProfileEventListeners = new ListenerList();
    protected ListenerList fPDViewEventListeners = new ListenerList();
    protected List fSelectionParts = new ArrayList(2);
    protected List fSelectionProviders = new ArrayList(2);
    protected ListenerList fListeners = new ListenerList();
    protected ArrayList fDeleteListener = new ArrayList(1);

    private TraceUIManager() {
    }

    public static TraceUIManager getTraceUIManager() {
        if (traceUIManager == null) {
            traceUIManager = new TraceUIManager();
        }
        return traceUIManager;
    }

    public void addSelectionListener(ISelectionListener l) {
        this.fListeners.add((Object)l);
    }

    public void removeSelectionListener(ISelectionListener l) {
        this.fListeners.remove((Object)l);
    }

    public void addSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        this.fSelectionProviders.add(provider);
        this.fSelectionParts.add(part);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deregisterLaunchProcess(IProcess iprocess) {
    }

    public void deleteLaunch(IProcess iprocess) {
        ProcessAdapter adapter;
        ILaunch launch;
        if (iprocess instanceof ProcessAdapter && (launch = (adapter = (ProcessAdapter)iprocess).getLaunch()) != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }

    public HierarchyFactory getPerftraceFactory() {
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            HierarchyPackageImpl.init();
            this.factory = new HierarchyFactoryImpl();
            this.resourceSet = HierarchyResourceSetImpl.getInstance();
        }
        return this.resourceSet;
    }

    public void registerLaunchProcess(final IProcess iprocess) {
        if (iprocess instanceof ProcessAdapter) {
            ProcessAdapter processAdapter = (ProcessAdapter)iprocess;
            ILaunch launch = processAdapter.getLaunch();
            if (launch != null) {
                launch.addProcess((IProcess)processAdapter);
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    org.eclipse.ui.console.IConsole console = TraceUIManager.this.getConsole(iprocess);
                    TraceUIManager.this.showConsole(console);
                }
            });
        }
    }

    public void removeSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        this.fSelectionProviders.remove(provider);
        this.fSelectionParts.remove(part);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged(null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int index;
        Object[] copiedListeners = this.fListeners.getListeners();
        ISelection selection = null;
        ISelectionProvider provider = null;
        IWorkbenchPart part = null;
        if (event != null) {
            selection = TraceUIManager.convertNavigatorItems(event.getSelection());
            provider = (ISelectionProvider)event.getSource();
            index = this.fSelectionProviders.indexOf(provider);
            if (index == -1) {
                return;
            }
        } else {
            return;
        }
        part = (IWorkbenchPart)this.fSelectionParts.get(index);
        this.selectionChanged(part, selection);
        int i = 0;
        while (i < copiedListeners.length) {
            ISelectionListener l = (ISelectionListener)copiedListeners[i];
            l.selectionChanged(part, selection);
            ++i;
        }
    }

    private static ISelection convertNavigatorItems(ISelection sel) {
        if (sel != null && sel instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)sel;
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof INavigatorItem) {
                    list.add(((INavigatorItem)obj).getData());
                    continue;
                }
                list.add(obj);
            }
            return new StructuredSelection(list);
        }
        return sel;
    }

    private org.eclipse.ui.console.IConsole getConsole(IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            org.eclipse.ui.console.IConsole console = consoles[i];
            if (console instanceof IConsole && ((IConsole)console).getProcess().equals(process)) {
                return console;
            }
            ++i;
        }
        return null;
    }

    private TRCProcessProxy getProcessFromInput(Object input) {
        TRCProcessProxy processInput = null;
        if (input instanceof TRCProcessProxy) {
            processInput = (TRCProcessProxy)input;
        } else if (input instanceof TRCAgentProxy) {
            processInput = ((TRCAgentProxy)input).getProcessProxy();
        }
        return processInput;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel != null && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            IProcess process = ProcessMap.get(this.getProcessFromInput(selection.getFirstElement()));
            org.eclipse.ui.console.IConsole console = this.getConsole(process);
            this.showConsole(console);
        }
    }

    private void showConsole(org.eclipse.ui.console.IConsole console) {
        IViewPart consoleView;
        IWorkbenchPage page;
        if (console == null) {
            return;
        }
        IWorkbenchWindow window = UIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (consoleView = page.findView("org.eclipse.ui.console.ConsoleView")) != null && consoleView instanceof IConsoleView) {
            ((IConsoleView)consoleView).display(console);
        }
    }

    public void dispose() {
        this.fListeners.clear();
        this.fDeleteListener.clear();
        this.fSelectionParts.clear();
        this.fSelectionProviders.clear();
        this.resourceSet = null;
        this.factory = null;
        this.fPDViewEventListeners.clear();
        this.fDeleteListener.clear();
        this.fProfileEventListeners.clear();
        this.fSelectionModel.clear();
        this.fProfileEvent = null;
        this.pdViewEvent = null;
        this.refreshViewsEvent = null;
        this.updateModelEvent = null;
        this.contextHandlerSelectionChangedEvent = null;
        traceUIManager = null;
    }

    public void addProfileEventListener(IProfileEventListener listener) {
        this.fProfileEventListeners.add((Object)listener);
    }

    public void removeProfileEventListener(IProfileEventListener listener) {
        this.fProfileEventListeners.remove((Object)listener);
    }

    public void addDeleteListener(IDeleteListener listener) {
        this.fDeleteListener.add(listener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        this.fPDViewEventListeners.add((Object)listener);
    }

    public void addSelectionModel(EObject mofObject, ITraceSelection model) {
        this.fSelectionModel.put(mofObject, model);
    }

    public ArrayList getDeleteListeners() {
        return this.fDeleteListener;
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return this.pdViewEvent;
    }

    public ProfileEvent getProfileEvent() {
        return this.fProfileEvent;
    }

    public ProfileEvent getRefreshViewEvent(Object source) {
        this.refreshViewsEvent.setSource(source);
        return this.refreshViewsEvent;
    }

    public ProfileEvent getContextHandlerSelectionChangedEvent(Object source) {
        this.contextHandlerSelectionChangedEvent.setSource(source);
        return this.contextHandlerSelectionChangedEvent;
    }

    public ITraceSelection getSelectionModel(EObject mofObject) {
        Object model = this.fSelectionModel.get(mofObject);
        if (model == null) {
            model = new TraceSelection();
            this.fSelectionModel.put(mofObject, model);
        }
        return (ITraceSelection)model;
    }

    public ProfileEvent getUpdateModelEvent(Object source) {
        this.updateModelEvent.setSource(source);
        return this.updateModelEvent;
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
        Object[] listeners = this.fPDViewEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IViewSelectionChangedListener)listeners[idx]).handleViewSelectionChangedEvent(event);
            ++idx;
        }
    }

    public void notifyProfileEventListener(ProfileEvent event) {
        Object[] listeners = this.fProfileEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IProfileEventListener)listeners[idx]).handleProfileEvent(event);
            ++idx;
        }
    }

    public void removeDeleteListener(IDeleteListener listener) {
        this.fDeleteListener.remove(listener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        this.fPDViewEventListeners.remove((Object)listener);
    }

    public void removeSelectionModel(EObject mofObject) {
        this.fSelectionModel.remove(mofObject);
    }
}

