/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;

public abstract class FilterTraceViewer
extends TraceViewer
implements IFilterViewer {
    private FilterInformationManager _fi;
    private IFilterQueryProvider _fqp;
    private String _contentDescription = null;
    private boolean _internalCall = false;

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        super.makeActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this._fi = FilterInformationManager.instance((IFilterViewer)this);
        if (!tbm.isEmpty()) {
            tbm.add((IContributionItem)new Separator());
        }
        tbm.add((IAction)new FiltersSelectionAction(this._fi));
    }

    public void dispose() {
        if (this._fqp != null) {
            this._fqp.viewerDisposed();
        }
        this._fqp = null;
        super.dispose();
    }

    public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider) {
        this._fqp = filterQueryProvider;
    }

    public SimpleSearchQuery getCurrentFilter() {
        return this._fqp.getCurrentFilter();
    }

    public SimpleSearchQuery standardQuery() {
        return this._fqp.standardQuery();
    }

    public SimpleSearchQuery advancedQuery() {
        return this._fqp.advancedQuery();
    }

    public void updateAdvancedQuery(SimpleSearchQuery query, int advancedTabSelectionIndex) {
        this._fqp.updateAdvancedQuery(query, advancedTabSelectionIndex);
    }

    public void updateFilterAppliedDescription() {
        String filterAppliedName = this._fqp != null && this._fqp.getCurrentFilter() != null ? this._fqp.getCurrentFilter().getName() : TraceMessages.ST_FLTAPN;
        if (this._contentDescription == null) {
            this._contentDescription = "";
        }
        String filterStr = NLS.bind((String)TraceMessages.ST_FLTAPF, (Object)filterAppliedName);
        this._internalCall = true;
        this.setContentDescription(String.valueOf(this._contentDescription) + "  (" + filterStr + " )");
        this._internalCall = false;
    }

    protected void setContentDescription(String description) {
        if (this._internalCall) {
            super.setContentDescription(description);
        } else {
            this._contentDescription = description;
            this.updateFilterAppliedDescription();
        }
    }
}

