/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceAssociationMapping;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.util.AnalysisHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HyadesUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    private static StringBuffer tmpBuffer = new StringBuffer();

    public static String change(String in, String oldPat, String newPat) {
        if (oldPat.length() == 0) {
            return in;
        }
        if (oldPat.length() == 1 && newPat.length() == 1) {
            return in.replace(oldPat.charAt(0), newPat.charAt(0));
        }
        int lastIndex = 0;
        int newIndex = 0;
        tmpBuffer.setLength(0);
        while ((newIndex = in.indexOf(oldPat, lastIndex)) != -1) {
            tmpBuffer.append(in.substring(lastIndex, newIndex)).append(newPat);
            lastIndex = newIndex + oldPat.length();
        }
        tmpBuffer.append(in.substring(lastIndex));
        return tmpBuffer.toString();
    }

    public static String getAgentName(TRCAgentProxy agent) {
        String type = agent.getType();
        String name = agent.getName();
        if (name == null) {
            name = "";
        }
        if (type.equals("Profiler")) {
            if (!name.equals("J2EE Request Profiler")) {
                name = TraceMessages.TRCNM;
            }
        } else if (type.equals("Logging") && name.equals("")) {
            name = TraceMessages.LGNM;
        }
        if (agent.getStartTime() > 0.0) {
            Date date = new Date((long)agent.getStartTime() * 1000L);
            String timestamp = DateFormat.getDateTimeInstance((int)3, (int)2).format(date);
            name = String.valueOf(name) + " (" + timestamp + ")";
        }
        return name;
    }

    public static String getProcessName(TRCProcessProxy process) {
        if (process.getPid() > 0) {
            String msg = process.getName() == null || process.getName().length() == 0 ? TraceMessages.UNK : process.getName();
            return NLS.bind((String)TraceMessages.PRC_LNG, (Object[])new Object[]{msg, process.getNode().getName(), String.valueOf(process.getPid())});
        }
        String msg = process.getName() == null || process.getName().length() == 0 ? TraceMessages.UNK : process.getName();
        return NLS.bind((String)TraceMessages.PRC_LNG_NID, (Object[])new Object[]{msg, process.getNode().getName()});
    }

    public static String getAgentLabel(TRCAgentProxy a) {
        tmpBuffer.setLength(0);
        if (a.isActive() && a.isMonitored()) {
            tmpBuffer.append("<").append(TraceMessages.AG_MON);
        } else if (a.isActive() && a.isAttached()) {
            tmpBuffer.append("<").append(TraceMessages.AG_AT);
        } else if (a.isActive()) {
            tmpBuffer.append("<").append(TraceMessages.AG_DET);
        } else {
            if (HyadesUtil.isNotInitialized(a)) {
                return "";
            }
            tmpBuffer.append("<").append(TraceMessages.AG_TERM);
        }
        if (a.isCollectionData()) {
            tmpBuffer.append(TraceMessages.COLLECT).append(">");
        } else {
            tmpBuffer.append(">");
        }
        return tmpBuffer.toString();
    }

    private static boolean isNotInitialized(TRCAgentProxy a) {
        return (a.getType() == null || a.getType() != null && a.getType().equals("Profiler")) && !a.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_RuntimeId());
    }

    public static int testConnection(String host, String port, boolean message, Shell shell) {
        if (host == null || host.trim() == "" || port == null || port.trim() == "") {
            String text = UIPlugin.getResourceString("INVALID_HOST");
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            ErrorDialog.openError((Shell)shell, (String)TraceMessages.TRC_MSGT, (String)TraceMessages.CON_ERROR_, (IStatus)err);
            return 2;
        }
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        ConnectUtil util = new ConnectUtil(host, port, store.getString("user_id"), (Application)UIPlugin.getDefault());
        int result = util.connect();
        if (result == 0) {
            store.setValue("user_id", util.getUserId());
            if (message) {
                String text = TraceMessages.CON_SUC;
                MessageDialog.openInformation((Shell)shell, (String)TraceMessages.TRC_MSGT, (String)text);
            }
        }
        return result;
    }

    public static IResource getSelectionFolder(Object selection) {
        if (selection != null) {
            if (selection instanceof IResource) {
                return (IResource)selection;
            }
            if (selection instanceof EObject) {
                String strPath = TString.resourcePath(((EObject)selection).eResource().getURI());
                return UIPlugin.getPluginWorkbench().getRoot().findMember(new Path(strPath).removeLastSegments(1));
            }
            if (selection instanceof INavigatorItem) {
                return HyadesUtil.getSelectionFolder(((INavigatorItem)selection).getParent());
            }
        }
        return null;
    }

    public static IResource getSelectionFolder(INavigator viewer) {
        if (!viewer.getStructuredSelection().isEmpty()) {
            return HyadesUtil.getSelectionFolder(viewer.getStructuredSelection().getFirstElement());
        }
        return null;
    }

    public static void cleanupResources(String navigatorID) {
        IViewPart part;
        ProfileEvent event = new ProfileEvent();
        event.setSource(null);
        event.setType(4096);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        IWorkbenchPage page = null;
        IWorkbenchWindow[] windows = UIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                page = pages[j];
                if (page != null && page.getPerspective() != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) break;
                ++j;
            }
            ++i;
        }
        if (page != null && (navigatorID.equals("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer") ? (part = page.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null : navigatorID.equals("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator") && (part = page.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer")) != null)) {
            return;
        }
        try {
            boolean modified = false;
            if (HierarchyResourceSetImpl.getInstance().getResources().size() > 0) {
                boolean externalModified;
                Iterator docs = HierarchyResourceSetImpl.getInstance().getResources().iterator();
                while (docs.hasNext()) {
                    Resource res = (Resource)docs.next();
                    if (res == null || !res.isLoaded() || !res.isModified()) continue;
                    modified = true;
                    break;
                }
                Collection external = NavigatorExtensionUtil.getAllModifiedItems(null);
                boolean bl = externalModified = !external.isEmpty();
                if (modified || externalModified) {
                    String title = TraceMessages.TRC_MSGT;
                    String msg = TraceMessages.SAVE_PSQ;
                    String toggleMsg = TraceMessages.RDEC;
                    IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
                    String value = store.getString("save_on_exit");
                    if (value == null || "".equals(value)) {
                        value = "prompt";
                        store.setValue("save_on_exit", value);
                    }
                    boolean saveRequested = false;
                    if ("prompt".equals(value)) {
                        boolean bl2 = saveRequested = MessageDialogWithToggle.openYesNoQuestion(null, (String)title, (String)msg, (String)toggleMsg, (boolean)false, (IPreferenceStore)UIPlugin.getDefault().getPreferenceStore(), (String)"save_on_exit").getReturnCode() == 2;
                    }
                    if (saveRequested || "always".equals(value)) {
                        if (modified) {
                            SaveUtil.saveDocuments();
                            IWorkspaceRoot res = UIPlugin.getPluginWorkbench().getRoot();
                            res.refreshLocal(2, null);
                        }
                        if (externalModified) {
                            Iterator i2 = external.iterator();
                            while (i2.hasNext()) {
                                ((INavigatorItem)i2.next()).save(false);
                            }
                        }
                    }
                }
                EList resources = HierarchyResourceSetImpl.getInstance().getResources();
                int s = resources.size();
                ArrayList documents = new ArrayList(s);
                documents.addAll(resources);
                int i3 = 0;
                while (i3 < s) {
                    Resource res = (Resource)documents.get(i3);
                    if (!PlatformUI.getWorkbench().isClosing()) {
                        if (res.isLoaded()) {
                            try {
                                res.unload();
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        res.setModified(false);
                    }
                    ++i3;
                }
                if (!PlatformUI.getWorkbench().isClosing()) {
                    resources.clear();
                }
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
        AnalysisHelper.getInstance().dispose();
        TraceUIManager.getTraceUIManager().dispose();
        PDContentProvider.resetMonitors();
    }

    public static EObject getMofObject() {
        EObject sel = HyadesUtil.getNavigatorSelection(HyadesUtil.getActiveNavigator());
        if (sel instanceof EObject) {
            return sel;
        }
        if (sel instanceof INavigatorItem) {
            return (EObject)((INavigatorItem)sel).getData();
        }
        return null;
    }

    public static INavigator getActiveNavigator() {
        UIPlugin ui_plugin = UIPlugin.getDefault();
        if (ui_plugin == null) {
            return null;
        }
        IWorkbench workbench = ui_plugin.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IViewPart part = page.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (part != null && ((Navigator)part).isActiveNavigator()) {
            return (INavigator)part;
        }
        part = page.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        if (part != null && ((Navigator)part).isActiveNavigator()) {
            return (INavigator)part;
        }
        return null;
    }

    public static EObject getNavigatorSelection(INavigator navigator) {
        Object obj;
        if (navigator == null) {
            return null;
        }
        IStructuredSelection selection = navigator.getStructuredSelection();
        if (!selection.isEmpty() && (obj = selection.getFirstElement()) != null) {
            if (obj instanceof EObject) {
                return (EObject)obj;
            }
            if (obj instanceof INavigatorItem) {
                return (EObject)((INavigatorItem)obj).getData();
            }
        }
        return null;
    }

    public static EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        List list = null;
        if (selObject instanceof TRCMonitor) {
            list = HyadesUtil.getLogObjectInMonitor((EObject)((TRCMonitor)selObject));
        } else if (selObject instanceof TRCNode) {
            list = HyadesUtil.getLogObjectInNode((EObject)((TRCNode)selObject));
        } else if (selObject instanceof TRCProcessProxy) {
            list = HyadesUtil.getLogAgentInProcess((EObject)((TRCProcessProxy)selObject));
        }
        if (list != null && list.size() == 1) {
            return (EObject)list.get(0);
        }
        return selObject;
    }

    public static List getLogObjectInMonitor(EObject selObject) {
        List list;
        EList nodes = ((TRCMonitor)selObject).getNodes();
        TRCNode node = null;
        int size = nodes.size();
        int nrOfNodes = 0;
        ArrayList<Object> object_list = new ArrayList<Object>();
        int i = 0;
        while (i < size && nrOfNodes < 2) {
            node = (TRCNode)nodes.get(i);
            if (node != null && (list = HyadesUtil.getLogObjectInNode((EObject)node)).size() >= 1) {
                ++nrOfNodes;
                object_list.add(node);
            }
            ++i;
        }
        if (object_list.size() == 1 && (list = HyadesUtil.getLogObjectInNode((EObject)((TRCNode)object_list.get(0)))).size() == 1) {
            object_list.clear();
            object_list.add(list.get(0));
        }
        return object_list;
    }

    public static List getLogObjectInNode(EObject selObject) {
        List list;
        EList processes = ((TRCNode)selObject).getProcessProxies();
        TRCProcessProxy process = null;
        int nrOfProcesses = 0;
        int size = processes.size();
        ArrayList<Object> object_list = new ArrayList<Object>();
        int i = 0;
        while (i < size && nrOfProcesses < 2) {
            process = (TRCProcessProxy)processes.get(i);
            if (process != null && (list = HyadesUtil.getLogAgentInProcess((EObject)process)).size() >= 1) {
                ++nrOfProcesses;
                object_list.add(process);
            }
            ++i;
        }
        if (object_list.size() == 1 && (list = HyadesUtil.getLogAgentInProcess((EObject)((TRCProcessProxy)object_list.get(0)))).size() == 1) {
            object_list.clear();
            object_list.add(list.get(0));
        }
        return object_list;
    }

    public static List getLogAgentInProcess(EObject selObject) {
        int nrOfAgents = 0;
        EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
        int size = agents.size();
        TRCAgentProxy a = null;
        ArrayList<TRCAgentProxy> list = new ArrayList<TRCAgentProxy>();
        int idx = 0;
        while (idx < size && nrOfAgents < 2) {
            a = (TRCAgentProxy)agents.get(idx);
            if (a != null && !a.eIsProxy() && (a.getType().equals("Logging") || TraceAssociationMapping.getDefault().isViewForType("org.eclipse.tptp.platform.log.views.internal.views.LogViewer", a.getType()))) {
                ++nrOfAgents;
                list.add(a);
            }
            ++idx;
        }
        return list;
    }

    public static Collection getLogAgents(EObject eObject) {
        ArrayList<Object> log_agents = new ArrayList<Object>();
        ArrayList<EObject> processes = null;
        if (eObject instanceof CorrelationContainerProxy) {
            log_agents.addAll((Collection<Object>)((CorrelationContainerProxy)eObject).getCorrelatedAgents());
        }
        if (eObject instanceof TRCMonitor) {
            processes = HyadesUtil.getProcesses((TRCMonitor)eObject);
        } else if (eObject instanceof TRCNode) {
            processes = ((TRCNode)eObject).getProcessProxies();
        } else if (eObject instanceof TRCProcessProxy) {
            processes = new ArrayList<EObject>(1);
            processes.add(eObject);
        } else if (eObject instanceof TRCAgentProxy && (((TRCAgentProxy)eObject).getType().equals("Logging") || TraceAssociationMapping.getDefault().isViewForType("org.eclipse.tptp.platform.log.views.internal.views.LogViewer", ((TRCAgentProxy)eObject).getType()))) {
            log_agents.add(eObject);
        }
        if (processes != null) {
            TRCProcessProxy process = null;
            Iterator iter = processes.iterator();
            while (iter.hasNext()) {
                process = (TRCProcessProxy)iter.next();
                if (process == null) continue;
                EList agents = process.getAgentProxies();
                TRCAgentProxy agentProxy = null;
                Iterator iterator = agents.iterator();
                while (iterator.hasNext()) {
                    agentProxy = (TRCAgentProxy)iterator.next();
                    if (agentProxy == null || !agentProxy.getType().equals("Logging") && !TraceAssociationMapping.getDefault().isViewForType("org.eclipse.tptp.platform.log.views.internal.views.LogViewer", agentProxy.getType())) continue;
                    log_agents.add(agentProxy);
                }
            }
        }
        return log_agents;
    }

    public static Collection getLogAgents(EObject eObject, int type) {
        ArrayList<TRCAgentProxy> result = new ArrayList<TRCAgentProxy>();
        Collection logAgents = HyadesUtil.getLogAgents(eObject);
        TRCAgentProxy element = null;
        TRCAgent agent = null;
        Iterator iter = logAgents.iterator();
        while (iter.hasNext()) {
            element = (TRCAgentProxy)iter.next();
            agent = (TRCAgent)element.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent == null) continue;
            if (type == 0 && EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                result.add(element);
                continue;
            }
            if (type != 1 || EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) continue;
            result.add(element);
        }
        return result;
    }

    public static Collection getProcesses(TRCMonitor monitor) {
        EList nodes = monitor.getNodes();
        ArrayList processes = new ArrayList();
        int nodes_size = nodes.size();
        int i = 0;
        while (i < nodes_size) {
            EList list = ((TRCNode)nodes.get(i)).getProcessProxies();
            processes.addAll(list);
            ++i;
        }
        return processes;
    }

    public static List getResources(IProject project) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            IResource[] members = project.members();
            int idx = 0;
            while (idx < members.length) {
                IResource member = members[idx];
                if (member != null && member.exists() && member instanceof IFile && ((IFile)member).getFileExtension() != null && ((IFile)member).getFileExtension().equals("trcmxmi")) {
                    resources.add(member);
                }
                ++idx;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return resources;
    }

    public static List getMonitors(IResource resource, ResourceSet resourceSet) {
        ArrayList monList = new ArrayList();
        Resource res = null;
        try {
            String monPath;
            String name = monPath = resource.getFullPath().toString();
            res = resourceSet.getResource(SaveUtil.createURI((String)("platform:/resource" + name + "#")).trimFragment(), true);
            EList ext = res.getContents();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof TRCMonitor)) continue;
                monList.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monList;
    }

    public static short containsMixedResources(TRCAgentProxy[] agentProxies) {
        TRCAgentProxy agentProxy = null;
        TRCAgent agent = null;
        int xmiCount = 0;
        int dbCount = 0;
        int sameDB = 1;
        Properties p = null;
        String dbType = null;
        int i = 0;
        while (i < agentProxies.length) {
            agentProxy = agentProxies[i];
            if (agentProxy != null && (agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)) != null) {
                if (EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                    ++xmiCount;
                } else {
                    ++dbCount;
                    URI uri = EcoreUtil.getURI((EObject)agentProxy.getAgent());
                    Properties currentProperties = HyadesExtendedResourceFactory.getPropertiesFromURI((URI)uri);
                    String storeType = ((IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)uri.toString()))).getStoreType(LoadersUtils.getPostfix((String)uri.toString()));
                    if (p != null && dbType != null && dbType.equals(storeType) && HyadesUtil.sameDB(p, currentProperties)) {
                        ++sameDB;
                    }
                    p = currentProperties;
                    dbType = storeType;
                }
            }
            ++i;
        }
        if (dbCount == 0 && xmiCount == agentProxies.length) {
            return -1;
        }
        if (dbCount == agentProxies.length && xmiCount == 0) {
            return sameDB == dbCount ? (short)2 : 1;
        }
        if (dbCount > 0 && xmiCount > 0) {
            return 0;
        }
        return -1;
    }

    private static boolean sameDB(Properties p1, Properties p2) {
        String l1 = (String)p1.get("location");
        String l2 = (String)p2.get("location");
        return l1 != null && l2 != null && l1.equals(l2);
    }

    public static String codeLogAgentName(String type, String name, String userInput) {
        StringBuffer tmp = new StringBuffer(type);
        tmp.append("  #  ").append(name).append("  #  ").append(userInput);
        return tmp.toString();
    }

    public static String resolveLogAgentType(String name) {
        if (name == null) {
            return "";
        }
        int idx = name.indexOf("  #  ");
        if (idx != -1) {
            return name.substring(0, idx);
        }
        idx = name.lastIndexOf(" ");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    public static String resolveLogAgentDisplayName(String name) {
        if (name == null) {
            return "";
        }
        int idx = name.lastIndexOf("  #  ");
        if (idx != -1 && idx < name.length() - 1) {
            return name.substring(idx + 5);
        }
        idx = name.lastIndexOf(" ");
        if (idx != -1 && idx < name.length() - 1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    public static String resolveLogAgentPath(String name) {
        if (name == null) {
            return "";
        }
        int idx = name.indexOf("  #  ");
        if (idx != -1) {
            if ((idx = (name = name.substring(idx + 5)).indexOf("  #  ")) != -1) {
                return name.substring(0, idx);
            }
        } else {
            idx = name.lastIndexOf(" ");
            if (idx != -1 && idx < name.length() - 1) {
                return name.substring(idx + 1);
            }
        }
        return name;
    }
}

