/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AttachActionDelegate
extends AbstractListenerActionDelegate {
    public void run(TRCAgentProxy fAgent, INavigator fViewer) {
        try {
            Agent a;
            TRCProcessProxy process = fAgent.getProcessProxy();
            String hostName = process.getNode().getName();
            Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)fAgent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isActive()) {
                if (fAgent.isActive()) {
                    PDCoreUtil.detachAgent(fAgent);
                    fAgent.setActive(false);
                }
                TRCAgentProxy fAgentOld = fAgent;
                fAgent = PDCoreUtil.createUniqueAgent(process, a);
                PDCoreUtil.copyAgentProperties(fAgentOld, fAgent);
                PDCoreUtil.doAttach(a, fAgent);
                PDCoreUtil.activate(fAgent);
            }
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(fAgent);
            event.setType(4);
            UIPlugin.getDefault().notifyProfileEventListener(event);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
                            MessageDialogWithToggle.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)TraceMessages.PROF_TT, (String)TraceMessages.AT_INFOM, (String)TraceMessages.AT_MSGCB, (boolean)false, (IPreferenceStore)UIPlugin.getDefault().getPreferenceStore(), (String)"profile_tips");
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object element) {
        return element != null && element instanceof TRCAgentProxy && ((TRCAgentProxy)element).isActive() && !((TRCAgentProxy)element).isAttached();
    }

    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, fViewer);
    }

    public void dispose() {
        super.dispose();
    }
}

