/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CollectObjRefActionDelegate
extends AbstractListenerActionDelegate {
    public void run(TRCAgentProxy fAgent, INavigator fViewer) {
        if (fAgent == null) {
            return;
        }
        if (!fAgent.isMonitored()) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.COBJR_INFO_);
            return;
        }
        if (fAgent.getType().equals("Profiler")) {
            TRCProcessProxy process = fAgent.getProcessProxy();
            String hostName = process.getNode().getName();
            try {
                Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
                if (node == null) {
                    return;
                }
                Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)fAgent);
                if (instance != null && instance instanceof Agent) {
                    Agent a = (Agent)instance;
                    CustomCommand command = new CustomCommand();
                    command.setData("ANALYSEHEAP");
                    a.invokeCustomCommand(command);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected boolean isEnabledFor(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof TRCAgentProxy) {
            TRCAgentProxy agent = (TRCAgentProxy)element;
            return agent.getType().equals("Profiler") && agent.isMonitored() && this.collectInstanceInformation(agent);
        }
        if (element instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)element).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (!agent.eIsProxy() && agent.getType().equals("Profiler") && agent.isMonitored() && this.collectInstanceInformation(agent)) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy) && !(object instanceof TRCProcessProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        TRCAgentProxy agent = null;
        if (object instanceof TRCAgentProxy) {
            agent = (TRCAgentProxy)object;
        } else if (object instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)object).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.get(idx);
                if (!ag.eIsProxy() && ag.getType().equals("Profiler")) {
                    agent = ag;
                }
                ++idx;
            }
        }
        this.run(agent, fViewer);
    }

    private boolean collectInstanceInformation(TRCAgentProxy agent) {
        TRCConfiguration config;
        EList options;
        TRCCollectionMode type = agent.getCollectionMode();
        if (type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) {
            return false;
        }
        Iterator configs = agent.getConfigurations().iterator();
        if (configs.hasNext() && (options = (config = (TRCConfiguration)configs.next()).getOptions()) != null) {
            Iterator i = options.iterator();
            while (i.hasNext()) {
                TRCOption option = (TRCOption)i.next();
                if (!option.getKey().equals("TRACE_MODE") || !option.getValue().equals("noObjectCorrelation")) continue;
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }
}

