/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RefreshTreeAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private INavigator fViewer;

    public RefreshTreeAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString(TraceMessages.REFRESH));
        this.setDescription(UIPlugin.getResourceString(TraceMessages.RTREE));
        PDPluginImages.setImageDescriptors((IAction)this, "lcl16", "refresh.gif");
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(UIPlugin.getPluginId()) + ".refr0000");
        this.setToolTipText(UIPlugin.getResourceString(TraceMessages.RTREET));
    }

    public void run() {
        RefreshResourceDialog dlg = new RefreshResourceDialog(this.fViewer.getViewSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        boolean refreshContents = dlg.getRefreshContent();
        if (refreshContents) {
            PDContentProvider.resetMonitors();
            Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
            int idx = 0;
            while (idx < resources.length) {
                Resource element = (Resource)resources[idx];
                if (element != null && element.isLoaded()) {
                    Object[] elements = element.getContents().toArray();
                    int i = 0;
                    while (i < elements.length) {
                        Object obj = elements[i];
                        ArrayList deletelist = UIPlugin.getDefault().getDeleteListeners();
                        int j = 0;
                        while (j < deletelist.size()) {
                            ((IDeleteListener)deletelist.get(j)).deregister(obj);
                            ++j;
                        }
                        element.unload();
                        ++i;
                    }
                }
                ++idx;
            }
            if (!(this.fViewer instanceof PDProjectExplorer)) {
                ProfileEvent event = new ProfileEvent();
                event.setSource(ResourcesPlugin.getWorkspace().getRoot());
                event.setType(4608);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            } else {
                this.fViewer.getViewer().refresh();
            }
        } else {
            this.fViewer.getViewer().refresh();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    class RefreshResourceDialog
    extends MessageDialog {
        private boolean refreshContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ RefreshResourceDialog this$1;
            {
                this.this$1 = refreshResourceDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    RefreshResourceDialog.access$1(this.this$1, button == RefreshResourceDialog.access$0(this.this$1));
                }
            }
        };

        RefreshResourceDialog(Shell parentShell) {
            super(parentShell, UIPlugin.getResourceString(TraceMessages.TRC_MSGT), null, UIPlugin.getResourceString(TraceMessages.CRTREE), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = UIPlugin.getResourceString(TraceMessages.RTREE_SYS);
            this.radio1.setText(text1);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = UIPlugin.getResourceString(TraceMessages.RTREE_RES);
            this.radio2.setText(text2);
            this.radio1.setSelection(this.refreshContent);
            this.radio2.setSelection(!this.refreshContent);
            return composite;
        }

        public boolean getRefreshContent() {
            return this.refreshContent;
        }

        static /* synthetic */ Button access$0(RefreshResourceDialog refreshResourceDialog) {
            return refreshResourceDialog.radio1;
        }

        static /* synthetic */ void access$1(RefreshResourceDialog refreshResourceDialog, boolean bl) {
            refreshResourceDialog.refreshContent = bl;
        }
    }
}

