/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RunGCActionDelegate
extends AbstractListenerActionDelegate {
    public void run(TRCAgentProxy fAgent, INavigator fViewer) {
        if (!fAgent.isMonitored()) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString(TraceMessages.TRC_MSGT), (String)UIPlugin.getResourceString(TraceMessages.RUN_GC_INFO_));
            return;
        }
        if (fAgent.getType().equals("Profiler")) {
            TRCProcessProxy process = fAgent.getProcessProxy();
            String hostName = process.getNode().getName();
            try {
                Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
                if (node == null) {
                    return;
                }
                Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)fAgent);
                if (instance != null && instance instanceof Agent) {
                    Agent a = (Agent)instance;
                    CustomCommand command = new CustomCommand();
                    command.setData("RUNGC");
                    a.invokeCustomCommand(command);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected boolean isEnabledFor(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof TRCAgentProxy) {
            TRCAgentProxy agent = (TRCAgentProxy)element;
            return agent.getType().equals("Profiler") && agent.isMonitored();
        }
        if (element instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)element).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (!agent.eIsProxy() && agent.getType().equals("Profiler") && agent.isMonitored()) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, fViewer);
    }

    public void dispose() {
        super.dispose();
    }
}

