/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class SaveAction
extends SelectionProviderAction
implements ISelectionChangedListener,
IRunnableWithProgress {
    private INavigator fViewer;
    private Object[] fSelections;

    public SaveAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString(TraceMessages.SAVE));
        this.setDescription(UIPlugin.getResourceString(TraceMessages.SAVE));
        PDPluginImages.setImageDescriptors((IAction)this, "lcl16", "save.gif");
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(UIPlugin.getPluginId()) + ".save0000");
    }

    public void run() {
        String msg = "";
        ISelection sel = this.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        if (sel != null && !sel.isEmpty()) {
            msg = ((IStructuredSelection)sel).size() == 1 && ((IStructuredSelection)sel).getFirstElement() != null && ((IStructuredSelection)sel).getFirstElement() instanceof IProject ? UIPlugin.getResourceString(TraceMessages.SAVE_PQ) : UIPlugin.getResourceString(TraceMessages.SAVE_RQ);
        }
        if (!MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)UIPlugin.getResourceString(TraceMessages.TRC_MSGT), (String)msg)) {
            return;
        }
        this.finishSaving(((IStructuredSelection)sel).toArray());
    }

    public void finishSaving(Object[] selections) {
        this.fSelections = selections;
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this));
        }
        catch (InterruptedException interruptedException) {
            try {
                ArrayList<IResource> folders = new ArrayList<IResource>();
                int idx = 0;
                while (idx < this.fSelections.length) {
                    IResource res = HyadesUtil.getSelectionFolder(this.fSelections[idx]);
                    if (res != null && res.exists() && !folders.contains(res)) {
                        folders.add(res);
                        res.getProject().refreshLocal(2, null);
                    }
                    ++idx;
                }
                folders.clear();
                this.fSelections = null;
                return;
            }
            catch (CoreException exc) {
                exc.printStackTrace();
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            ArrayList<IResource> folders = new ArrayList<IResource>();
            int idx = 0;
            while (idx < this.fSelections.length) {
                IResource res = HyadesUtil.getSelectionFolder(this.fSelections[idx]);
                if (res != null && res.exists() && !folders.contains(res)) {
                    folders.add(res);
                    res.getProject().refreshLocal(2, null);
                }
                ++idx;
            }
            folders.clear();
            this.fSelections = null;
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
    }

    protected INavigator getViewer() {
        return this.fViewer;
    }

    public ISelection getSelection() {
        return this.fViewer.getViewer().getSelection();
    }

    public void run(IProgressMonitor monitor) {
        if (this.fSelections == null) {
            return;
        }
        SaveUtil.save(Arrays.asList(this.fSelections), monitor, this.fViewer.getID());
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fSelections = null;
    }
}

