/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.TraceLogActionGroup;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.navigator.DistributedLayout;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.action.LayoutAction;
import org.eclipse.hyades.ui.internal.extension.INavigatorLayout;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class TraceNavigatorActionGroup
extends TraceLogActionGroup {
    protected OpenWizardAction fOpenMonitorAction;
    protected OpenWizardAction fOpenProfAgentAction;
    protected PropertyDialogAction fPropertyDialogAction;
    protected OpenWizardAction fOpenProcessAction;
    private LayoutAction fFlatLayout;
    private LayoutAction fHierarchicalLayout;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TraceNavigatorActionGroup(INavigator navigator) {
        super(navigator);
    }

    public void dispose() {
        this.deleteActions();
        super.dispose();
    }

    private void deleteActions() {
        if (this.fOpenMonitorAction != null) {
            this.fOpenMonitorAction.dispose();
            this.fOpenMonitorAction = null;
        }
        if (this.fOpenProcessAction != null) {
            this.fOpenProcessAction.dispose();
            this.fOpenProcessAction = null;
        }
        if (this.fPropertyDialogAction != null) {
            this.fPropertyDialogAction.dispose();
            this.fPropertyDialogAction = null;
        }
        if (this.fOpenProfAgentAction != null) {
            this.fOpenProfAgentAction.dispose();
            this.fOpenProfAgentAction = null;
        }
        this.fFlatLayout = null;
        this.fHierarchicalLayout = null;
    }

    protected void createActions() {
        super.createActions();
        this.fNewSnapshotGrp = new Separator("newSnapshotGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fSaveToFile = new SaveAction(this.getNavigator());
        PDProjectExplorer pDProjectExplorer = (PDProjectExplorer)this.getNavigator();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.trace.ui.internal.wizard.OpenMonitorWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fOpenMonitorAction = new OpenWizardAction((INavigator)pDProjectExplorer, clazz, UIPlugin.getResourceString(TraceMessages.PROP));
        PDProjectExplorer pDProjectExplorer2 = (PDProjectExplorer)this.getNavigator();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fOpenProfAgentAction = new OpenWizardAction((INavigator)pDProjectExplorer2, clazz2, UIPlugin.getResourceString(TraceMessages.PROP));
        PDProjectExplorer pDProjectExplorer3 = (PDProjectExplorer)this.getNavigator();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fOpenProcessAction = new OpenWizardAction((INavigator)pDProjectExplorer3, clazz3, UIPlugin.getResourceString(TraceMessages.PROP));
        INavigatorLayout layout = this.getNavigator().getLayout();
        this.fFlatLayout = new LayoutAction(this.getNavigator(), (INavigatorLayout)new SimpleLayout((PDProjectExplorer)this.getNavigator()), UIPlugin.getResourceString(TraceMessages.LY_FLAT), PDPluginImages.DESC_IMG_UI_LAYOUT_FLAT, UIPlugin.getDefault().getPreferenceStore(), "profiling_monitor_layout", 0);
        this.fFlatLayout.setChecked(layout instanceof SimpleLayout);
        this.fHierarchicalLayout = new LayoutAction(this.getNavigator(), (INavigatorLayout)new DistributedLayout((PDProjectExplorer)this.getNavigator()), UIPlugin.getResourceString(TraceMessages.LY_HR), PDPluginImages.DESC_IMG_UI_LAYOUT_HIERARCHICAL, UIPlugin.getDefault().getPreferenceStore(), "profiling_monitor_layout", 1);
        this.fHierarchicalLayout.setChecked(layout instanceof DistributedLayout);
        this.fDeleteAction = new DeleteAction(this.getNavigator());
        this.fPropertyDialogAction = new PropertyDialogAction((IShellProvider)this.getNavigator().getViewSite(), (ISelectionProvider)this.getNavigator().getViewer());
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean multiSelection;
        super.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean sameClass = false;
        boolean bl = multiSelection = selection.size() > 1;
        if (multiSelection) {
            sameClass = this.areSameClass(selection);
        }
        if (selection.isEmpty()) {
            this.fImportActionGroup.fillContextMenu(menu);
            menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
            return;
        }
        Object sel = selection.iterator().next();
        this.updateActions(selection);
        if (sel instanceof TRCMonitor) {
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        } else if (sel instanceof TRCNode) {
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        } else if (sel instanceof TRCProcessProxy) {
            if (!multiSelection) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
            }
        } else if (sel instanceof TRCAgentProxy) {
            if (!multiSelection || sameClass) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
                menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
            }
            if (!multiSelection) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fNewSnapshotGrp);
                menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
            }
        } else if (sel instanceof INavigatorItem && !multiSelection) {
            menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
            menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
            menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        }
        menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
        menu.appendToGroup("group.save", (IAction)this.fSaveToFile);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshLocal);
        if (!multiSelection) {
            if (this.fPropertyDialogAction.isApplicableForSelection()) {
                menu.appendToGroup("group.properties", (IAction)this.fPropertyDialogAction);
            }
            if (sel instanceof TRCMonitor) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenMonitorAction);
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenNodeAction);
            } else if (sel instanceof TRCProcessProxy) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenProcessAction);
            } else if (sel instanceof TRCAgentProxy) {
                if (((TRCAgentProxy)sel).getType().equals("Profiler")) {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenProfAgentAction);
                } else {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenLogAgentAction);
                }
            }
        }
        this.fImportActionGroup.fillContextMenu(menu);
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.fFlatLayout);
        menu.add((IAction)this.fHierarchicalLayout);
        super.fillActionBars(actionBars);
    }

    private void addActions(IMenuManager menu, Collection views) {
        menu.add((IContributionItem)new Separator());
        Iterator iter = views.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next == null || !(next instanceof IAction) || !((IAction)next).isEnabled()) continue;
            menu.add((IAction)next);
        }
    }

    private void addViews(IMenuManager menu, Object obj) {
        if (obj != null && (obj instanceof EObject || obj instanceof INavigatorItem)) {
            MenuManager popup = new MenuManager(LogMessages.MENU_MANAGER);
            menu.appendToGroup("group.add.views", (IContributionItem)popup);
            TreeSet views = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((IAction)o1).getText().compareTo(((IAction)o2).getText());
                }
            });
            if (obj instanceof TRCMonitor || obj instanceof TRCNode) {
                this.getViews(obj, views, true, false);
                this.addActions((IMenuManager)popup, views);
                views.clear();
                this.getViews(obj, views, false, true);
                this.addActions((IMenuManager)popup, views);
            } else {
                this.getViews(obj, views, true, true);
                this.addActions((IMenuManager)popup, views);
            }
        }
    }

    private void getViews(Object obj, Set set, boolean includeSelf, boolean includeChildren) {
        Iterator<Object> iter;
        String type = null;
        List<ProfileDetailItem> children = new ArrayList();
        if (obj instanceof TRCMonitor) {
            type = "Monitor";
            children.addAll((Collection<ProfileDetailItem>)((TRCMonitor)obj).getNodes());
        } else if (obj instanceof TRCNode) {
            type = "Host";
            children.addAll((Collection<ProfileDetailItem>)((TRCNode)obj).getProcessProxies());
        } else if (obj instanceof TRCProcessProxy) {
            type = null;
            children.addAll((Collection<ProfileDetailItem>)((TRCProcessProxy)obj).getAgentProxies());
        } else if (obj instanceof TRCAgentProxy) {
            type = ((TRCAgentProxy)obj).getType();
            if (type.equals("Profiler") && !this.hasProfilingTypes(obj)) {
                Map typesMap = ProfilingSetsManager.instance().getProfilingTypes();
                children = new ArrayList();
                iter = typesMap.values().iterator();
                while (iter.hasNext()) {
                    IProfilingSetType next = (IProfilingSetType)iter.next();
                    children.add(new ProfileDetailItem(obj, next.getName(), next.getId(), null));
                }
            }
        } else if (obj instanceof INavigatorItem) {
            type = ((INavigatorItem)obj).getType();
        }
        List items = null;
        items = NavigatorExtensionUtil.getAllChildren((Object)obj, (String)"org.eclipse.hyades.trace.ui.profileNavigator");
        if (items != null) {
            if (children == null) {
                children = items;
            } else {
                children.addAll(items);
            }
        }
        if (includeSelf && type != null) {
            IAction[] actions = this.getViewMappingForType(type);
            int i = 0;
            while (i < actions.length) {
                if (!(!(actions[i] instanceof OpenAssociatedTraceViewAction) || set.contains(actions[i]) && actions[i].isEnabled())) {
                    actions[i].setEnabled(((OpenAssociatedTraceViewAction)actions[i]).isEnabledForObject(obj));
                }
                set.add(actions[i]);
                ++i;
            }
        }
        if (includeChildren && children != null) {
            iter = children.iterator();
            while (iter.hasNext()) {
                this.getViews(iter.next(), set, true, true);
            }
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        IStructuredSelection selection;
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.updateActions(HyadesUtil.getActiveNavigator().getStructuredSelection());
            if (this.fDeleteAction.isEnabled()) {
                this.fDeleteAction.run();
            }
        }
        if (event.keyCode == 13 && (event.stateMask & 0x10000) != 0 && (selection = HyadesUtil.getActiveNavigator().getStructuredSelection()).size() == 1) {
            Object sel = selection.iterator().next();
            this.updateActions(selection);
            if (sel instanceof IProject) {
                this.fPropertyDialogAction.run();
            } else if (sel instanceof TRCMonitor) {
                this.fOpenMonitorAction.run();
            } else if (sel instanceof TRCNode) {
                this.fOpenNodeAction.run();
            }
            if (sel instanceof TRCProcessProxy) {
                this.fOpenProcessAction.run();
            }
            if (sel instanceof TRCAgentProxy) {
                this.fOpenProfAgentAction.run();
            }
        }
    }
}

