/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.ui.PlatformUI;

public class TraceAssociationManager {
    public static final String GENERIC_TEST_SUITE_TYPE = "org.eclipse.hyades.GenericTestSuite";
    public static final String GENERIC_TEST_SUITE_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart";
    private static IAssociationMappingRegistry traceViewMappingRegistry;

    public static void dispose() {
        if (traceViewMappingRegistry != null) {
            traceViewMappingRegistry.dispose();
        }
    }

    public static IAssociationMappingRegistry getTraceViewMappingRegistry() {
        if (traceViewMappingRegistry == null) {
            traceViewMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            traceViewMappingRegistry.initialize("trace", (IAssociationDescriptorFilter)new TraceDescriptorFilter(), HyadesUIPlugin.getInstance().getPreferenceStore());
            traceViewMappingRegistry.retrieveAssociationMapping("typeDescriptions", HyadesUIPlugin.getID());
            traceViewMappingRegistry.retrieveAssociationMapping("analyzerExtensions", HyadesUIPlugin.getID());
        }
        return traceViewMappingRegistry;
    }

    private static class TraceDescriptorFilter
    implements IAssociationDescriptorFilter {
        TraceDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"trace".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("typeDescriptions".equals(extensionPoint)) {
                if (associationDescriptor.applyToAllTypes()) {
                    return false;
                }
                if (associationDescriptor.types().length != 1) {
                    return false;
                }
                if (associationDescriptor.getImageDescriptor() == null) {
                    associationDescriptor.setImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("blank_obj.gif"));
                }
            } else if ("analyzerExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }
}

