/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.net.InetAddress;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;
import org.eclipse.ui.PlatformUI;

public class TraceHostUI
extends AbstractChangeable
implements SelectionListener {
    private Button _edit;
    private Button _delete;
    private Button _add;
    private Button _testConnection;
    private Text _host;
    private Text _port;
    private Table _list;
    private WizardPage _wizardPage = null;

    public TraceHostUI(WizardPage wp) {
        this.setWizardPage(wp);
    }

    public TraceHostUI() {
    }

    public void addHost() {
        HostDialog dialog = new HostDialog(TraceMessages.ADD_HST, null, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            StringBuffer buffer = new StringBuffer(dialog.getHost());
            buffer.append(":").append(dialog.getPort());
            this.addHost(buffer.toString());
            this.enableButtons();
            this.changed();
            this.setHostText();
        }
    }

    public void editHost() {
        int exist = -1;
        HostDialog dialog = new HostDialog(TraceMessages.EDT_HST, this._host.getText(), this._port.getText());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            StringBuffer buffer = new StringBuffer(dialog.getHost());
            buffer.append(":").append(dialog.getPort());
            int idx = 0;
            while (idx < this._list.getItemCount()) {
                if (buffer.toString().equals(this._list.getItem(idx).getText())) {
                    exist = idx;
                }
                ++idx;
            }
            if (exist > 0) {
                this.deleteHost();
                this._list.select(exist >= this._list.getItemCount() ? exist - 1 : exist);
            } else {
                this.editHost(buffer.toString());
            }
            this.enableButtons();
            this.changed();
            this.setHostText();
        }
    }

    public void addHost(String text) {
        if (text == null) {
            return;
        }
        if (text.equals("localhost") || text.equals("localhost:-1")) {
            text = SecurityMessages._75;
        }
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (text.equals(this._list.getItem(idx).getText())) {
                this._list.select(idx);
                return;
            }
            ++idx;
        }
        TableItem item = new TableItem(this._list, 0);
        item.setText(text.trim());
        item.setImage(PDPluginImages.getImage("node_obj.gif"));
        this._list.setSelection(new TableItem[]{item});
    }

    public void editHost(String text) {
        int i = this._list.getSelectionIndex();
        TableItem item = this._list.getItem(i);
        item.setText(text.trim());
        item.setImage(PDPluginImages.getImage("node_obj.gif"));
    }

    private void addHosts(String hosts) {
        if (hosts != null && hosts.length() > 0) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this.addHost(hosts);
            }
        }
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        Label desc = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        desc.setLayoutData((Object)data);
        desc.setText(TraceMessages.PHNODE);
        Composite dataGroup = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        dataGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        dataGroup.setLayoutData((Object)data);
        this._list = new Table(dataGroup, 2304);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite bottomWidget = new Composite(dataGroup, 0);
        data = new GridData();
        bottomWidget.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        bottomWidget.setLayout((Layout)layout);
        Label hostLabel = new Label(bottomWidget, 0);
        hostLabel.setText(TraceMessages.PHIP);
        this._host = new Text(bottomWidget, 2048);
        this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label portLabel = new Label(bottomWidget, 0);
        portLabel.setText(TraceMessages.RAC_PT);
        this._port = new Text(bottomWidget, 2048);
        this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._port.setText(String.valueOf(10002));
        Composite buttonWidget = new Composite(result, 0);
        data = GridUtil.createVerticalFill();
        buttonWidget.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget.setLayout((Layout)layout);
        Composite buttonWidget1 = new Composite(buttonWidget, 0);
        data = GridUtil.createFill();
        buttonWidget1.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget1.setLayout((Layout)layout);
        this._edit = new Button(buttonWidget1, 0);
        this._edit.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._edit.setText(TraceMessages.PEDT);
        this._add = new Button(buttonWidget1, 0);
        this._add.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._add.setText(TraceMessages.PADD);
        this._delete = new Button(buttonWidget1, 0);
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._delete.setText(TraceMessages.RMV_TXT);
        this._testConnection = new Button(buttonWidget1, 0);
        this._testConnection.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._testConnection.setText(TraceMessages.TST_CON);
        Label l = new Label(buttonWidget1, 0);
        l.setLayoutData((Object)GridUtil.createVerticalFill());
        this._edit.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._testConnection.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        this._host.setEditable(false);
        this._port.setEditable(false);
        this._delete.setEnabled(false);
        this._testConnection.setEnabled(false);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._list, String.valueOf(UIPlugin.getPluginId()) + ".hstp0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._host, String.valueOf(UIPlugin.getPluginId()) + ".hstp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._delete, String.valueOf(UIPlugin.getPluginId()) + ".hstp0003");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._add, String.valueOf(UIPlugin.getPluginId()) + ".hstp0004");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._testConnection, String.valueOf(UIPlugin.getPluginId()) + ".hstp0005");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._port, String.valueOf(UIPlugin.getPluginId()) + ".hstp0006");
        return result;
    }

    public Table getListUI() {
        return this._list;
    }

    public Text getHostUI() {
        return this._host;
    }

    public Text getPortUI() {
        return this._port;
    }

    public Button getDeleteUI() {
        return this._delete;
    }

    public Button getAddUI() {
        return this._add;
    }

    public WizardPage getWizardPage() {
        return this._wizardPage;
    }

    public void setWizardPage(WizardPage wp) {
        this._wizardPage = wp;
    }

    private void deleteHost() {
        int i = this._list.getSelectionIndex();
        if (i != -1) {
            this._list.remove(i);
        }
        this._host.setText("");
        this._port.setText("");
        if (this._list.getItemCount() > 0) {
            if (i - 1 > 0 && i - 1 < this._list.getSelectionCount()) {
                this._list.select(i - 1);
            } else {
                this._list.select(0);
            }
        }
    }

    private void testConnection() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TableItem tblItem;
                String hosts;
                int i = TraceHostUI.this._list.getSelectionIndex();
                if (i != -1 && (hosts = (tblItem = TraceHostUI.this._list.getItem(i)).getText()) != null && !hosts.equals("")) {
                    String port;
                    String host;
                    int idx = 0;
                    idx = hosts.lastIndexOf(":");
                    if (idx != -1) {
                        host = hosts.substring(0, idx);
                        port = hosts.substring(idx + 1);
                    } else {
                        host = hosts;
                        port = "-1";
                    }
                    int state = AgentControllerFactoryImpl.whoIsRunning();
                    if (hosts.equals(SecurityMessages._75)) {
                        if (state == 1 || state == 0) {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.CON_SUC);
                            return;
                        }
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)TraceMessages.TRC_MSGT, (String)SecurityMessages._73);
                        return;
                    }
                    try {
                        if (host.equals("localhost") || InetAddress.getByName(host).equals(InetAddress.getLocalHost())) {
                            if (state == 1) {
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)TraceMessages.TRC_MSGT, (String)SecurityMessages._74);
                                return;
                            }
                            if (state == 0) {
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)TraceMessages.TRC_MSGT, (String)NLS.bind((String)SecurityMessages._67, (Object)"localhost"));
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {}
                    HyadesUtil.testConnection(host, port, true, TraceHostUI.this._list.getShell());
                }
            }
        });
    }

    public String getHost() {
        String name = null;
        int idx = this._list.getSelectionIndex();
        if (idx == -1) {
            return name;
        }
        name = this._list.getItem(idx).getText();
        if (name.equals(SecurityMessages._75)) {
            name = "localhost";
        } else {
            int id = name.indexOf(":");
            if (id != -1) {
                name = name.substring(0, id);
            }
        }
        return name;
    }

    public int getPort() {
        String port = String.valueOf(10002);
        int idx = this._list.getSelectionIndex();
        if (idx != -1) {
            port = this._list.getItem(idx).getText();
        }
        if (port.equals(SecurityMessages._75)) {
            return -1;
        }
        int id = port.indexOf(":");
        port = id != -1 ? port.substring(id + 1) : String.valueOf(10002);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public TableItem[] getHosts() {
        return this._list.getItems();
    }

    private void initializeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String hosts = store.getString("use_host");
        this.addHosts(hosts);
        this.setHostText();
        this.enableButtons();
    }

    public void reset() {
        this._list.removeAll();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this._list && this._wizardPage != null && this._wizardPage.getNextPage() != null) {
            this._wizardPage.getWizard().getContainer().showPage(this._wizardPage.getNextPage());
        }
    }

    private void enableButtons() {
        int idx = this._list.getSelectionIndex();
        String text = null;
        if (idx == -1) {
            this._edit.setEnabled(false);
            this._delete.setEnabled(false);
            this._testConnection.setEnabled(false);
            return;
        }
        text = this._list.getItem(this._list.getSelectionIndex()).getText();
        this._edit.setEnabled(this._list.getItemCount() > 1 && text != null && !text.equals(SecurityMessages._75));
        this._delete.setEnabled(this._list.getItemCount() > 1 && text != null && !text.equals(SecurityMessages._75) && !text.startsWith("localhost:"));
        this._testConnection.setEnabled(idx != -1);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._edit) {
            this.editHost();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        }
        if (e.widget == this._add) {
            this.addHost();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._delete) {
            this.deleteHost();
            this.enableButtons();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._list) {
            this.enableButtons();
            this.setHostText();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._testConnection) {
            this.testConnection();
            this.enableButtons();
            this._testConnection.setFocus();
        }
    }

    public void selectHost(String hostname) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (hostname.equals(this._list.getItem(idx).getText()) || hostname.equals(SecurityMessages._75) && this._list.getItem(idx).getText().equals(SecurityMessages._75) || hostname.equals("localhost") && this._list.getItem(idx).getText().equals(SecurityMessages._75)) {
                this._list.setSelection(idx);
                this.enableButtons();
                return;
            }
            ++idx;
        }
        this.enableButtons();
    }

    private void setHostText() {
        TableItem[] selected = this._list.getSelection();
        if (selected.length > 0) {
            String text = selected[0].getText();
            if (text.equals(SecurityMessages._75)) {
                this._host.setText(SecurityMessages._75);
                this._port.setText("");
            } else {
                int idx = text.lastIndexOf(":");
                if (idx != -1) {
                    this._host.setText(text.substring(0, idx));
                    if (idx < text.length() - 1) {
                        this._port.setText(text.substring(idx + 1));
                    } else {
                        this._port.setText("");
                    }
                }
            }
        } else {
            this._host.setText("");
            this._port.setText("");
        }
    }

    class HostDialog
    extends Dialog
    implements ModifyListener {
        private Text _host;
        private Text _port;
        private String hostStr;
        private String portStr;
        private String title;

        public HostDialog(String _title, String _hostStr, String _portStr) {
            super(Display.getCurrent().getActiveShell());
            this.title = _title;
            this.hostStr = _hostStr;
            this.portStr = _portStr;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(TraceMessages.PHIP);
            this._host = new Text(result, 2048);
            this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._host.addModifyListener((ModifyListener)this);
            label = new Label(result, 0);
            label.setText(TraceMessages.RAC_PT);
            this._port = new Text(result, 2048);
            this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._port.addModifyListener((ModifyListener)this);
            this._port.setText(this.portStr != null ? this.portStr : String.valueOf(10002));
            this._host.setText(this.hostStr != null ? this.hostStr : "localhost");
            this._host.setFocus();
            this._host.selectAll();
            this.enableField();
            return result;
        }

        private void enableField() {
            if (this.title.equals(TraceMessages.EDT_HST)) {
                this._host.setEnabled(!this._host.getText().equals("localhost"));
            }
        }

        public void modifyText(ModifyEvent e) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._port.getText().trim().length() > 0 && this._host.getText().trim().length() > 0);
            }
        }

        protected void okPressed() {
            this.hostStr = this._host.getText().trim();
            this.portStr = this._port.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this._port.getText().trim().length() > 0);
            return result;
        }

        public String getHost() {
            return this.hostStr;
        }

        public String getPort() {
            return this.portStr;
        }
    }
}

