/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class TraceLocationUI
extends AbstractChangeable
implements SelectionListener {
    private Button _browseLocation;
    private Text _location;
    private Text _monitor;
    private Button _browseMonitor;
    private Label _locationLabel;

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        result.setLayoutData((Object)data);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                TraceLocationUI.this.changed();
            }
        };
        this._locationLabel = new Label(result, 0);
        this._locationLabel.setText(TraceMessages.TRACE_LOC);
        this._location = new Text(result, 2048);
        this._location.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._location.addListener(24, modifyListener);
        this._browseLocation = new Button(result, 0);
        this._browseLocation.setText(TraceMessages.BROWSE);
        Label desc = new Label(result, 0);
        desc.setText(TraceMessages.MON_LOC);
        this._monitor = new Text(result, 2048);
        this._monitor.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._monitor.addListener(24, modifyListener);
        this._browseMonitor = new Button(result, 0);
        this._browseMonitor.setText(TraceMessages.BROWSE1);
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this._browseMonitor.addSelectionListener((SelectionListener)this);
        this._location.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._location, String.valueOf(UIPlugin.getPluginId()) + ".tloc0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._browseLocation, String.valueOf(UIPlugin.getPluginId()) + ".tloc0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._monitor, String.valueOf(UIPlugin.getPluginId()) + ".tloc0003");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._browseMonitor, String.valueOf(UIPlugin.getPluginId()) + ".tloc0004");
        this.initialize();
        return result;
    }

    public void initialize() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this._location.setText(store.getString("prj_name"));
        this._monitor.setText(store.getString("mon_name"));
    }

    public Label getLocationLabel() {
        return this._locationLabel;
    }

    public Text getLocation() {
        return this._location;
    }

    public Text getMonitor() {
        return this._monitor;
    }

    public void setEnabled(boolean enable) {
        this._location.setEnabled(enable);
        this._browseLocation.setEnabled(enable);
        this._monitor.setEnabled(enable);
        this._browseMonitor.setEnabled(enable);
    }

    public void setEnabledBrowse(boolean enable) {
        this._browseLocation.setEnabled(enable);
        this._browseMonitor.setEnabled(enable);
    }

    public void setEnabledLocation(boolean enable) {
        this._location.setEnabled(enable);
    }

    public void setLocation(String location) {
        this._location.setText(location);
    }

    public void setMonitor(String text) {
        this._monitor.setText(text);
    }

    private void showMonitorsDialog() {
        Object[] result;
        MonitorSelectionDialog dialog = new MonitorSelectionDialog(UIPlugin.getActiveWorkbenchShell(), UIPlugin.getResourceString(TraceMessages.RES_DLGM));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1 && result[0] != null) {
            IPath path = (IPath)result[0];
            this._monitor.setText(path.lastSegment());
            this._location.setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            this._monitor.setFocus();
        }
    }

    private void showResourceDialog() {
        ContainerSelectionDialog dialog;
        Path path = new Path(this._location.getText().trim());
        IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
        IContainer cont = null;
        if (res != null && res.exists() && res instanceof IContainer) {
            cont = (IContainer)res;
        }
        if ((dialog = new ContainerSelectionDialog(UIPlugin.getActiveWorkbenchShell(), cont, true, UIPlugin.getResourceString(TraceMessages.RES_DLGM))).open() == 0) {
            Object[] result = dialog.getResult();
            if (result != null && result.length == 1 && result[0] != null) {
                this._location.setText(((IPath)result[0]).toOSString());
            }
            this._location.setFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._browseLocation) {
            this.showResourceDialog();
        } else if (e.widget == this._browseMonitor) {
            this.showMonitorsDialog();
        }
    }
}

