/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TraceLogUI
implements SelectionListener {
    private Table _list;
    private Button _delete;
    private Button _addAgent;
    private Button _editAgent;
    private Text _newAgent;

    protected void addAgent() {
        AgentDialog dialog = new AgentDialog(true, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.addAgent(dialog.getAgentName());
            this.enableButtons();
            this.setAgentText();
        }
    }

    protected void editAgent() {
        int exist = -1;
        AgentDialog dialog = new AgentDialog(false, this._newAgent.getText());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            StringBuffer buffer = new StringBuffer(dialog.getAgentName());
            int idx = 0;
            while (idx < this._list.getItemCount()) {
                if (buffer.toString().equals(this._list.getItem(idx).getText())) {
                    exist = idx;
                }
                ++idx;
            }
            if (exist > 0) {
                this.removeAgent();
                this._list.select(exist >= this._list.getItemCount() ? exist - 1 : exist);
            } else {
                this.editAgent(buffer.toString());
            }
            this.enableButtons();
            this.setAgentText();
        }
    }

    public void addAgent(String text) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (text.equals(this._list.getItem(idx).getText())) {
                this._list.select(idx);
                this.setAgentText();
                return;
            }
            ++idx;
        }
        TableItem item = new TableItem(this._list, 0);
        item.setText(text);
        this._list.setSelection(new TableItem[]{item});
        this.setAgentText();
    }

    public void editAgent(String text) {
        int i = this._list.getSelectionIndex();
        TableItem item = this._list.getItem(i);
        item.setText(text.trim());
    }

    public Composite createControl(Composite parent) {
        Composite _result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        _result.setLayout((Layout)layout);
        _result.setLayoutData((Object)GridUtil.createFill());
        this._list = new Table(_result, 2304);
        GridData gd = GridUtil.createFill();
        this._list.setLayoutData((Object)gd);
        Composite buttons = new Composite(_result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 120;
        buttons.setLayoutData((Object)gd);
        this._editAgent = new Button(buttons, 0);
        this._editAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editAgent.setText(UIPlugin.getResourceString(TraceMessages.PEDT));
        this._addAgent = new Button(buttons, 8);
        this._addAgent.setText(UIPlugin.getResourceString(TraceMessages.PADD));
        this._addAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._delete = new Button(buttons, 8);
        this._delete.setText(UIPlugin.getResourceString(TraceMessages.RMV_TXT));
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite space = new Composite(buttons, 0);
        space.setLayout((Layout)layout);
        space.setLayoutData((Object)GridUtil.createFill());
        Composite addAgent = new Composite(_result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        addAgent.setLayout((Layout)layout);
        addAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(addAgent, 0);
        label.setText(UIPlugin.getResourceString(TraceMessages.LA_LBL));
        this._newAgent = new Text(addAgent, 2048);
        this._newAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._newAgent.setEditable(false);
        this._editAgent.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._addAgent.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._list, String.valueOf(UIPlugin.getPluginId()) + ".lapp0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._editAgent, String.valueOf(UIPlugin.getPluginId()) + ".lapp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._delete, String.valueOf(UIPlugin.getPluginId()) + ".lapp0003");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._addAgent, String.valueOf(UIPlugin.getPluginId()) + ".lapp0004");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._newAgent, String.valueOf(UIPlugin.getPluginId()) + ".lapp0005");
        return _result;
    }

    public String[] getAgents() {
        TableItem[] items = this._list.getItems();
        String[] agents = new String[items.length];
        int idx = 0;
        while (idx < items.length) {
            agents[idx] = items[idx].getText();
            ++idx;
        }
        return agents;
    }

    protected void removeAgent() {
        int i = this._list.getSelectionIndex();
        if (i != -1) {
            this._list.remove(i);
        }
        this._newAgent.setText("");
    }

    public void reset() {
        this._list.removeAll();
        this._delete.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._editAgent) {
            this.editAgent();
        } else if (event.widget == this._addAgent) {
            this.addAgent();
        } else if (event.widget == this._delete) {
            int i = this._list.getSelectionIndex();
            this.removeAgent();
            this._list.setSelection(i < this._list.getItemCount() ? i : (this._list.getItemCount() > 0 ? this._list.getItemCount() - 1 : -1));
            this.enableButtons();
            this.setAgentText();
        } else if (event.widget == this._list) {
            this.enableButtons();
            this.setAgentText();
        }
    }

    public void enableButtons() {
        int idx = this._list.getSelectionIndex();
        if (idx == -1) {
            this._editAgent.setEnabled(false);
            this._delete.setEnabled(false);
            return;
        }
        this._editAgent.setEnabled(true);
        this._delete.setEnabled(true);
    }

    private void setAgentText() {
        TableItem[] selected = this._list.getSelection();
        if (selected.length > 0) {
            this._newAgent.setText(selected[0].getText());
        } else {
            this._newAgent.setText("");
        }
    }

    class AgentDialog
    extends Dialog
    implements ModifyListener {
        private Text agent;
        private String agentStr;
        private boolean isAdding;
        private String agentName;

        public AgentDialog(boolean isAdding, String agentName) {
            super(Display.getCurrent().getActiveShell());
            this.isAdding = isAdding;
            this.agentName = agentName;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.isAdding) {
                shell.setText(UIPlugin.getResourceString(TraceMessages.ADDLA));
            } else {
                shell.setText(UIPlugin.getResourceString(TraceMessages.EDITLA));
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString(TraceMessages.LA_LBL));
            this.agent = new Text(result, 2048);
            this.agent.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.agent.addModifyListener((ModifyListener)this);
            this.agent.setText(this.isAdding ? "logAgent" : this.agentName);
            this.agent.setFocus();
            this.agent.selectAll();
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(this.agent.getText().trim().length() > 0);
            }
        }

        protected void okPressed() {
            this.agentStr = this.agent.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this.agent.getText().trim().length() > 0);
            return result;
        }

        public String getAgentName() {
            return this.agentStr;
        }
    }
}

